package com.corejsf;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentELTag;

public class SpinnerTag extends UIComponentELTag {
   private ValueExpression minimum = null; 
   private ValueExpression maximum = null; 
   private ValueExpression size = null;
   private ValueExpression value = null;
   
   public String getRendererType() { return null; }
   public String getComponentType() { return "com.corejsf.Spinner"; }

   public void setMinimum(ValueExpression newValue) { minimum = newValue; }
   public void setMaximum(ValueExpression newValue) { maximum = newValue; }
   public void setSize(ValueExpression newValue) { size = newValue; }
   public void setValue(ValueExpression newValue) { value = newValue; }

   public void setProperties(UIComponent component) {
      // zawsze wywoujemy najpierw metod setProperties klasy bazowej
      super.setProperties(component);
      
      component.setValueExpression("size", size);
      component.setValueExpression("minimum", minimum);
      component.setValueExpression("maximum", maximum);
      component.setValueExpression("value", value);
   }
   
   public void release() {
      // zawsze wywoujemy najpierw metod release klasy bazowej
      super.release();

      minimum = null;
      maximum = null;
      size = null;
      value = null;
   }
}
