package com.corejsf;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.faces.model.SelectItem;

public class RegisterForm {
   enum Education { HIGH_SCHOOL, BACHELOR, MASTER, DOCTOR };

   private String name;
   private boolean contactMe;
   private Integer[] bestDaysToContact;
   private Integer yearOfBirth;
   private String[] colors;
   private String[] languages;
   private Education education;

   // Waciwo name:
   public String getName() {
      return name;
   }
   public void setName(String newValue) {
      name = newValue;
   }

   // Waciwo contactMe:
   public boolean getContactMe() {
      return contactMe;
   }
   public void setContactMe(boolean newValue) {
      contactMe = newValue;
   }

   // Waciwo bestDaysToContact:
   public Integer[] getBestDaysToContact() {
      return bestDaysToContact;
   }
   public void setBestDaysToContact(Integer[] newValue) {
      bestDaysToContact = newValue;
   }

   // Waciwo yearOfBirth:
   public Integer getYearOfBirth() {
      return yearOfBirth;
   }
   public void setYearOfBirth(Integer newValue) {
      yearOfBirth = newValue;
   }

   // Waciwo colors:
   public String[] getColors() {
      return colors;
   }
   public void setColors(String[] newValue) {
      colors = newValue;
   }

   // Waciwo languages:
   public String[] getLanguages() {
      return languages;
   }
   public void setLanguages(String[] newValue) {
      languages = newValue;
   }

   // Waciwo education:
   public Education getEducation() {
      return education;
   }
   
   public void setEducation(Education newValue) {
      education = newValue;
   }

   // Waciwo yearItems:
   public Collection<SelectItem> getYearItems() {
      return birthYears;
   }

   // Waciwo daysOfTheWeekItems:
   public SelectItem[] getDaysOfTheWeekItems() {
      return daysOfTheWeek;
   }

   // Waciwo languageItems:
   public Map<String, Object> getLanguageItems() {
      return languageItems;
   }
   
   // Waciwo colorItems:
   public SelectItem[] getColorItems() {
      return colorItems;
   }
   
   // Waciwo educationItems:
   public SelectItem[] getEducationItems() {
      return educationItems;
   }
   
   // Waciwo bestDaysConcatenated:
   public String getBestDaysConcatenated() {
      return concatenate(bestDaysToContact);
   }

   // Waciwo languagesConcatenated:
   public String getLanguagesConcatenated() {
      return concatenate(languages);
   }

   // Waciwo colorsConcatenated:
   public String getColorsConcatenated() {
      return concatenate(colors);
   }

   private static String concatenate(Object[] values) {
      if (values == null)
         return "";
      StringBuilder r = new StringBuilder();
      for (Object value : values) {
         if (r.length()> 0)
            r.append(',');
         r.append(value.toString());
      }
      return r.toString();
   }

   private static SelectItem[] colorItems = {
      new SelectItem("Czerwony"),
      new SelectItem("Niebieski"),
      new SelectItem("ty"),
      new SelectItem("Zielony"),
      new SelectItem("Pomaraczowy")
   };

   private static SelectItem[] educationItems = {
      new SelectItem(Education.HIGH_SCHOOL, "rednie"),
      new SelectItem(Education.BACHELOR, "Licencjat"),
      new SelectItem(Education.MASTER, "Wysze"),
      new SelectItem(Education.DOCTOR, "Doktorat") };

   private static Map<String, Object> languageItems; 
   static {
      languageItems = new LinkedHashMap<String, Object>();
      languageItems.put("angielski", "en"); // etykieta, warto
      languageItems.put("polski", "pl");
      languageItems.put("rosyjski", "ru");
      languageItems.put("woski", "it");
      languageItems.put("hiszpaski", "es");
   }
   
   private static Collection<SelectItem> birthYears;
   static {
      birthYears = new ArrayList<SelectItem>();
      for (int i = 1900; i < 2000; ++i) {
         birthYears.add(new SelectItem(i));
      }            
   }
   
   private static SelectItem[] daysOfTheWeek;
   static {
      DateFormatSymbols symbols = new DateFormatSymbols();
      String[] weekdays = symbols.getWeekdays();
      daysOfTheWeek = new SelectItem[7];
      for (int i = Calendar.SUNDAY; i <= Calendar.SATURDAY; i++) {
         daysOfTheWeek[i - 1] = new SelectItem(new Integer(i), weekdays[i]);
      }      
   }
}
