package com.corejsf;

public class QuizBean {
   private int currentProblem;
   private int tries;
   private int score;
   private String response;
   private String correctAnswer;

   // Poniej zakodowano problemy na stae. W rzeczywistej aplikacji
   // problemy najprawdopodobniej zostayby odczytane z bazy danych.
   private Problem[] problems = {
      new Problem(
         "Jak brzmia slogan reklamowy opisujcy programowanie w Javie? Write once, ...",
         "run anywhere"),
      new Problem(
         "Jak wyglda reprezentacja szesnastkowa czterech pierwszych bajtw kadego pliku klasy?",
         "CAFEBABE"),
      new Problem(
         "Co zostanie wywietlone przez nastpujce wyraenie? System.out.println(1+\"2\");",
         "12"),
      new Problem(
         "Ktre sowo kluczowe Javy suy do definiowania podklasy?",
         "extends"),
      new Problem(
         "Jak brzmiaa oryginalna nazwa jzyka programowania Java?",
         "Oak"),
      new Problem(
         "Ktra klasa pakietu java.util opisuje punkt w czasie?",
         "Date")
   };

   public QuizBean() { startOver(); }

   // Waciwo question:
   public String getQuestion() {
      return problems[currentProblem].getQuestion();
   }

   // Waciwo answer:
   public String getAnswer() { return correctAnswer; }
   
   // Waciwo score:
   public int getScore() { return score; }

   // Waciwo response:
   public String getResponse() { return response; }
   public void setResponse(String newValue) { response = newValue; }

   public String answerAction() {
      tries++;
      if (problems[currentProblem].isCorrect(response)) {
         score++;
         nextProblem();
         if (currentProblem == problems.length) return "done";
         else return "success";
      }
      else if (tries == 1) {
         return "again";
      }
      else {
         nextProblem();
         if (currentProblem == problems.length) return "done";
         else return "failure";
      }
   }

   public String startOverAction() {
      startOver();
      return "startOver";
   }

   private void startOver() {
      currentProblem = 0;
      score = 0;
      tries = 0;
      response = "";
   }

   private void nextProblem() {
      correctAnswer = problems[currentProblem].getAnswer();
      currentProblem++;
      tries = 0;
      response = "";
   }
}
