package com.corejsf;
import java.util.ArrayList;

public class QuizBean {
   private ArrayList<ProblemBean> problems = new ArrayList<ProblemBean>();     
   private int currentIndex;
   private int score;
   
   public QuizBean() {      
      problems.add(
         new ProblemBean(new int[] { 3, 1, 4, 1, 5 }, 9)); // liczba pi
      problems.add(
         new ProblemBean(new int[] { 1, 1, 2, 3, 5 }, 8)); // cig Fibonacciego
      problems.add(
         new ProblemBean(new int[] { 1, 4, 9, 16, 25 }, 36)); // kwadraty
      problems.add(
         new ProblemBean(new int[] { 2, 3, 5, 7, 11 }, 13)); // liczby pierwsze
      problems.add(
         new ProblemBean(new int[] { 1, 2, 4, 8, 16 }, 32)); // potgi dwjki
   }   

   // Waciwo problems:
   public void setProblems(ArrayList<ProblemBean> newValue) { 
      problems = newValue;
      currentIndex = 0;
      score = 0;
   } 
      
   // Waciwo score:
   public int getScore() { return score; }

   // Waciwo current:
   public ProblemBean getCurrent() {
      return problems.get(currentIndex);
   }

   // Waciwo answer:
   public String getAnswer() { return ""; }
   public void setAnswer(String newValue) { 
      try {
         int answer = Integer.parseInt(newValue.trim());
         if (getCurrent().getSolution() == answer) score++;            
         currentIndex = (currentIndex + 1) % problems.size();      
      }
      catch (NumberFormatException ex) {
      }
   }
}
