package com.corejsf;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Resource;
import javax.sql.DataSource;

public class UserBean {
   private String name;
   private String password;
   private boolean loggedIn;
   private Logger logger = Logger.getLogger("com.corejsf");
   
   @Resource(name="jdbc/mydb")
   private DataSource ds;
   
   /*
    Jeli uywasz serwera Tomcat lub pracujesz w technologii JSF 1.1, usu wiersz z adnotacj @Resource i dodaj ten konstruktor:
    public UserBean()
    {
      try {
          Context ctx = new InitialContext();
          ds = (DataSource) ctx.lookup("java:comp/env/jdbc/mydb");
      } catch (NamingException ex) {
      logger.log(Level.SEVERE, "Poszukiwanie rda danych nie powiodo si", ex);
      }
    }
   */

   public String getName() { return name; }
   public void setName(String newValue) { name = newValue; }

   public String getPassword() { return password; }
   public void setPassword(String newValue) { password = newValue; }

   public String login() {
      try {
         doLogin();
      }
      catch (SQLException ex) {
         logger.log(Level.SEVERE, "login failed", ex);
         return "internalError";
      }
      if (loggedIn)
         return "loginSuccess";
      else 
         return "loginFailure";
   }

   public String logout() { 
      loggedIn = false;
      return "login";
   }

   public void doLogin() throws SQLException {  
      if (ds == null) throw new SQLException("Brak rda danych");
      Connection conn = ds.getConnection();
      if (conn == null) throw new SQLException("Brak poczenia");

      try {
         PreparedStatement passwordQuery = conn.prepareStatement(
            "SELECT password from Users WHERE username = ?");

         passwordQuery.setString(1, name);
         
         ResultSet result = passwordQuery.executeQuery();

         if (!result.next()) return;
         String storedPassword = result.getString("password");                
         loggedIn = password.equals(storedPassword.trim());
      }
      finally {      
         conn.close();
      }
   }
}
