/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.util;

import java.beans.Beans;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class LoadBundle {
    private static final Locale defaultLocale;
    private String basename = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LoadBundle() {
        this(null);
    }

    public LoadBundle(String basename) {
        this.basename = basename;
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public Map getMap() {
        if (this.basename == null) {
            if (Beans.isDesignTime()) {
                return Collections.EMPTY_MAP;
            }
            throw new IllegalStateException("The 'basename' property cannot be null");
        }
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot root = null;
        Locale locale = null;
        if (context != null) {
            root = context.getViewRoot();
        }
        if (root != null) {
            locale = root.getLocale();
        }
        if (locale == null) {
            throw new IllegalStateException("Cannot retrieve locale-specific map if there is not a current Faces request, containing a valid view root, witha Locale instance inside.");
        }
        final ResourceBundle bundle = this.getBundle(this.basename, locale);
        if (bundle == null) {
            throw new IllegalArgumentException("No resource bundle found for base name '" + this.basename + "' and locale '" + locale + "'");
        }
        Map map = new Map(){

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public boolean containsKey(Object key) {
                boolean result = false;
                if (key != null) {
                    result = bundle.getObject(key.toString()) != null;
                }
                return result;
            }

            public boolean containsValue(Object value) {
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    Object val = bundle.getObject(keys.nextElement().toString());
                    if (val == null || !val.equals(value)) continue;
                    return true;
                }
                return false;
            }

            public Set entrySet() {
                HashMap<String, Object> map = new HashMap<String, Object>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    Object value = bundle.getObject(key);
                    map.put(key, value);
                }
                return map.entrySet();
            }

            public boolean equals(Object o) {
                if (o == null || !(o instanceof Map)) {
                    return false;
                }
                return ((Object)this.entrySet()).equals(((Map)o).entrySet());
            }

            public Object get(Object key) {
                if (key == null) {
                    return null;
                }
                try {
                    return bundle.getObject(key.toString());
                }
                catch (MissingResourceException e) {
                    return "???" + key.toString() + "???";
                }
            }

            public int hashCode() {
                return bundle.hashCode();
            }

            public boolean isEmpty() {
                Enumeration<String> keys = bundle.getKeys();
                return !keys.hasMoreElements();
            }

            public Set keySet() {
                HashSet<String> set = new HashSet<String>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    set.add(keys.nextElement());
                }
                return set;
            }

            public Object put(Object key, Object value) {
                throw new UnsupportedOperationException();
            }

            public void putAll(Map map) {
                throw new UnsupportedOperationException();
            }

            public Object remove(Object key) {
                throw new UnsupportedOperationException();
            }

            public int size() {
                int size = 0;
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    keys.nextElement();
                    ++size;
                }
                return size;
            }

            public Collection values() {
                ArrayList<Object> list = new ArrayList<Object>();
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement().toString();
                    list.add(bundle.getObject(key));
                }
                return list;
            }
        };
        return map;
    }

    private ResourceBundle getBundle(String basename, Locale locale) {
        if (!$assertionsDisabled && basename == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && locale == null) {
            throw new AssertionError();
        }
        ClassLoader rbcl = Thread.currentThread().getContextClassLoader();
        if (rbcl == null) {
            rbcl = this.getClass().getClassLoader();
        }
        try {
            return ResourceBundle.getBundle(basename, locale, rbcl);
        }
        catch (MissingResourceException e) {
            return ResourceBundle.getBundle(basename, defaultLocale, rbcl);
        }
    }

    static {
        $assertionsDisabled = !LoadBundle.class.desiredAssertionStatus();
        defaultLocale = Locale.getDefault();
    }
}

