/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.faces;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.faces.FacesException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.config.ConfigParser;
import org.apache.commons.chain.impl.CatalogBase;
import org.apache.commons.chain.web.servlet.ServletWebContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.faces.ShaleWebContext;
import org.apache.shale.util.Messages;
import org.apache.shale.view.ViewControllerMapper;

public class ShaleApplicationFilter
implements Filter {
    public static final String CATALOG_NAME = "shale";
    public static final String COMMAND_DESTROY = "destroy";
    public static final String COMMAND_INIT = "init";
    public static final String COMMAND_PREPROCESS = "preprocess";
    public static final String COMMAND_POSTPROCESS = "postprocess";
    public static final String CONTEXT_ATTR = "org.apache.shale.CONTEXT_ATTR";
    public static final String RESOURCE_NAME = "org/apache/shale/faces/shale-config.xml";
    public static final String VIEW_CONTROLLER_MAPPER = "org.apache.shale.view.VIEW_CONTROLLER_MAPPER";
    private Catalog catalog = null;
    private ServletContext context = null;
    private transient Log log = null;
    private static Messages messages = new Messages("org.apache.shale.resources.Bundle", ShaleApplicationFilter.class.getClassLoader());
    private Object tiger = null;

    public void destroy() {
        block4: {
            Command command;
            if (this.log().isInfoEnabled()) {
                this.log().info((Object)messages.getMessage("filter.finalizing"));
            }
            if ((command = this.catalog.getCommand(COMMAND_DESTROY)) != null) {
                ServletWebContext webContext = new ServletWebContext(this.context, null, null);
                try {
                    command.execute((Context)webContext);
                }
                catch (Exception e) {
                    if (!this.log().isErrorEnabled()) break block4;
                    this.log().error((Object)messages.getMessage("filter.destroyException"), (Throwable)e);
                }
            }
        }
        this.destroyTiger();
        this.context = null;
        this.catalog = null;
        CatalogFactory.clear();
        PropertyUtils.clearDescriptors();
        LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Command command = null;
        boolean result = false;
        ShaleWebContext context = new ShaleWebContext(this.context, (HttpServletRequest)request, (HttpServletResponse)response);
        request.setAttribute(CONTEXT_ATTR, (Object)context);
        command = this.catalog.getCommand(COMMAND_PREPROCESS);
        if (command != null) {
            try {
                result = command.execute((Context)context);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            if (result) {
                request.removeAttribute(CONTEXT_ATTR);
                return;
            }
        }
        chain.doFilter(request, response);
        command = this.catalog.getCommand(COMMAND_POSTPROCESS);
        if (command != null) {
            try {
                command.execute((Context)context);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        request.removeAttribute(CONTEXT_ATTR);
    }

    public void init(FilterConfig config) throws ServletException {
        if (this.log().isInfoEnabled()) {
            this.log().info((Object)messages.getMessage("filter.initializing"));
        }
        this.context = config.getServletContext();
        this.context.setAttribute("org.apache.shale.view.VIEW_MAPPER", (Object)this.getViewControllerMapper());
        this.initTiger(config);
        try {
            this.catalog = this.getCatalog();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        Command command = this.catalog.getCommand(COMMAND_INIT);
        if (command != null) {
            ServletWebContext webContext = new ServletWebContext(this.context, null, null);
            try {
                command.execute((Context)webContext);
            }
            catch (Exception e) {
                if (this.log().isErrorEnabled()) {
                    this.log().error((Object)messages.getMessage("filter.initException"), (Throwable)e);
                }
                throw new ServletException((Throwable)e);
            }
        }
    }

    private Catalog getCatalog() throws Exception {
        Catalog catalog = CatalogFactory.getInstance().getCatalog(CATALOG_NAME);
        if (catalog != null && catalog.getCommand(COMMAND_INIT) != null && catalog.getCommand(COMMAND_DESTROY) != null) {
            return catalog;
        }
        if (catalog == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)messages.getMessage("filter.creatingCatalog", new Object[]{CATALOG_NAME}));
            }
            catalog = new CatalogBase();
            CatalogFactory.getInstance().addCatalog(CATALOG_NAME, catalog);
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)messages.getMessage("filter.parsingResource", new Object[]{RESOURCE_NAME}));
        }
        ConfigParser parser = new ConfigParser();
        URL url = this.getClass().getClassLoader().getResource(RESOURCE_NAME);
        if (url == null) {
            throw new IllegalArgumentException(RESOURCE_NAME);
        }
        parser.parse(url);
        return catalog;
    }

    private ViewControllerMapper getViewControllerMapper() throws ServletException {
        ClassLoader cl;
        String className = this.context.getInitParameter(VIEW_CONTROLLER_MAPPER);
        if (className == null) {
            className = "org.apache.shale.view.impl.DefaultViewControllerMapper";
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            Class<?> clazz = cl.loadClass(className);
            return (ViewControllerMapper)clazz.newInstance();
        }
        catch (ClassCastException e) {
            throw new ServletException(messages.getMessage("filter.vcmCast", new Object[]{className}), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(messages.getMessage("filter.vcmClass", new Object[]{className}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ServletException(messages.getMessage("filter.vcmAccess", new Object[]{className}), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ServletException(messages.getMessage("filter.vcmInstantiate", new Object[]{className}), (Throwable)e);
        }
    }

    private void destroyTiger() {
        if (this.tiger != null) {
            ServletContextEvent event = new ServletContextEvent(this.context);
            try {
                Method method = this.tiger.getClass().getMethod("contextDestroyed", ServletContextEvent.class);
                method.invoke(this.tiger, event);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new FacesException(cause);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    private void initTiger(FilterConfig config) throws ServletException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            Class<?> clazz = cl.loadClass("org.apache.shale.tiger.faces.LifecycleListener");
            this.tiger = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (this.tiger != null) {
            ServletContextEvent event = new ServletContextEvent(this.context);
            try {
                Method method = this.tiger.getClass().getMethod("contextInitialized", ServletContextEvent.class);
                method.invoke(this.tiger, event);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new ServletException(cause);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)ShaleApplicationFilter.class);
        }
        return this.log;
    }
}

