/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.application;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.faces.ShaleWebContext;

public abstract class AbstractRegExpFilter
implements Command {
    private static final Log log = LogFactory.getLog((Class)AbstractRegExpFilter.class);
    private String excludes = null;
    private Pattern[] excludesPatterns = new Pattern[0];
    private String includes = null;
    private Pattern[] includesPatterns = new Pattern[0];

    protected Pattern[] getIncludesPatterns() {
        return this.includesPatterns;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
        this.excludesPatterns = this.precompile(excludes);
    }

    public String getIncludes() {
        return this.includes;
    }

    public void setIncludes(String includes) {
        this.includes = includes;
        this.includesPatterns = this.precompile(includes);
    }

    public boolean execute(Context context) throws Exception {
        ShaleWebContext webContext = (ShaleWebContext)context;
        String value = this.value(webContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute(" + value + ")"));
        }
        if (value == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  reject(null)");
            }
            this.reject(webContext);
            return true;
        }
        if (this.matches(value, this.includesPatterns, true)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  accept(include)");
            }
            this.accept(webContext);
            return false;
        }
        if (this.matches(value, this.excludesPatterns, false)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  reject(exclude)");
            }
            this.reject(webContext);
            return true;
        }
        if (this.includesPatterns != null && this.includesPatterns.length > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  reject(not include)");
            }
            this.reject(webContext);
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  accept(default)");
        }
        this.accept(webContext);
        return false;
    }

    protected void accept(ShaleWebContext context) throws Exception {
    }

    protected void reject(ShaleWebContext context) throws Exception {
        HttpServletResponse response = context.getResponse();
        response.sendError(403);
    }

    protected abstract String value(ShaleWebContext var1);

    protected boolean matches(String expr, Pattern[] patterns, boolean unrestricted) {
        if (patterns == null || patterns.length == 0) {
            return unrestricted;
        }
        for (int i = 0; i < patterns.length; ++i) {
            if (!patterns[i].matcher(expr).matches()) continue;
            return true;
        }
        return false;
    }

    private Pattern[] precompile(String expr) {
        ArrayList<Pattern> list;
        block5: {
            if (expr == null) {
                return new Pattern[0];
            }
            StreamTokenizer st = new StreamTokenizer(new StringReader(expr));
            st.eolIsSignificant(false);
            st.lowerCaseMode(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(0, 255);
            st.quoteChar(39);
            st.quoteChar(34);
            st.whitespaceChars(0, 32);
            st.whitespaceChars(44, 44);
            list = new ArrayList<Pattern>();
            int type = 0;
            while (true) {
                try {
                    type = st.nextToken();
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (type == -1) break block5;
                if (type == -2) {
                    list.add(Pattern.compile("" + st.nval));
                    continue;
                }
                if (type != -3) break;
                list.add(Pattern.compile(st.sval.trim()));
            }
            throw new IllegalArgumentException(expr);
        }
        return list.toArray(new Pattern[list.size()]);
    }
}

