/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.metadata.jaxrpcmapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.webservice.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.webservice.metadata.jaxrpcmapping.WsdlReturnValueMapping;

public class ServiceEndpointMethodMapping
implements Serializable {
    private static final long serialVersionUID = 7857267872017006227L;
    private ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping;
    private String javaMethodName;
    private String wsdlOperation;
    private boolean wrappedElement;
    private List methodParamPartsMappings = new ArrayList();
    private WsdlReturnValueMapping wsdlReturnValueMapping;

    public ServiceEndpointMethodMapping(ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping) {
        this.serviceEndpointInterfaceMapping = serviceEndpointInterfaceMapping;
    }

    public ServiceEndpointInterfaceMapping getServiceEndpointInterfaceMapping() {
        return this.serviceEndpointInterfaceMapping;
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public void setJavaMethodName(String javaMethodName) {
        this.javaMethodName = javaMethodName;
    }

    public MethodParamPartsMapping[] getMethodParamPartsMappings() {
        MethodParamPartsMapping[] arr = new MethodParamPartsMapping[this.methodParamPartsMappings.size()];
        this.methodParamPartsMappings.toArray(arr);
        return arr;
    }

    public MethodParamPartsMapping getMethodParamPartsMappingByPartName(String partName) {
        MethodParamPartsMapping paramMapping = null;
        for (int i = 0; paramMapping == null && i < this.methodParamPartsMappings.size(); ++i) {
            MethodParamPartsMapping aux = (MethodParamPartsMapping)this.methodParamPartsMappings.get(i);
            if (!aux.getWsdlMessageMapping().getWsdlMessagePartName().equals(partName)) continue;
            paramMapping = aux;
        }
        return paramMapping;
    }

    public MethodParamPartsMapping getMethodParamPartsMappingByPosition(int pos) {
        MethodParamPartsMapping paramMapping = null;
        for (int i = 0; paramMapping == null && i < this.methodParamPartsMappings.size(); ++i) {
            MethodParamPartsMapping aux = (MethodParamPartsMapping)this.methodParamPartsMappings.get(i);
            if (aux.getParamPosition() != pos) continue;
            paramMapping = aux;
        }
        return paramMapping;
    }

    public void addMethodParamPartsMapping(MethodParamPartsMapping methodParamPartsMapping) {
        this.methodParamPartsMappings.add(methodParamPartsMapping);
    }

    public boolean isWrappedElement() {
        return this.wrappedElement;
    }

    public void setWrappedElement(boolean wrappedElement) {
        this.wrappedElement = wrappedElement;
    }

    public String getWsdlOperation() {
        return this.wsdlOperation;
    }

    public void setWsdlOperation(String wsdlOperation) {
        this.wsdlOperation = wsdlOperation;
    }

    public WsdlReturnValueMapping getWsdlReturnValueMapping() {
        return this.wsdlReturnValueMapping;
    }

    public void setWsdlReturnValueMapping(WsdlReturnValueMapping wsdlReturnValueMapping) {
        this.wsdlReturnValueMapping = wsdlReturnValueMapping;
    }

    public String serialize() {
        StringBuffer sb = new StringBuffer();
        sb.append("<service-endpoint-method-mapping><java-method-name>").append(this.javaMethodName).append("</java-method-name>");
        sb.append("<wsdl-operation>").append(this.wsdlOperation).append("</wsdl-operation>");
        if (this.wrappedElement) {
            sb.append("<wrapped-element/>");
        }
        Iterator iter = this.methodParamPartsMappings.iterator();
        while (iter != null && iter.hasNext()) {
            sb.append(((MethodParamPartsMapping)iter.next()).serialize());
        }
        if (this.wsdlReturnValueMapping != null) {
            sb.append(this.wsdlReturnValueMapping.serialize());
        }
        sb.append("</service-endpoint-method-mapping>");
        return sb.toString();
    }
}

