/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier.strategy;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.Message;
import org.gjt.lindfors.pattern.StrategyContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.verifier.Section;
import org.jboss.verifier.event.VerificationEvent;
import org.jboss.verifier.factory.VerificationEventFactory;
import org.jboss.verifier.strategy.VerificationContext;
import org.jboss.verifier.strategy.VerificationStrategy;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;

public abstract class AbstractVerifier
implements VerificationStrategy {
    static final Logger log = Logger.getLogger(AbstractVerifier.class);
    protected static final String EJB_OBJECT_INTERFACE = "javax.ejb.EJBObject";
    protected static final String EJB_HOME_INTERFACE = "javax.ejb.EJBHome";
    protected static final String EJB_LOCAL_OBJECT_INTERFACE = "javax.ejb.EJBLocalObject";
    protected static final String EJB_LOCAL_HOME_INTERFACE = "javax.ejb.EJBLocalHome";
    protected ClassLoader classloader = null;
    private VerificationEventFactory factory = null;
    private VerificationContext context = null;
    public static final String BEAN_MANAGED_TX = "Bean";
    public static final String CONTAINER_MANAGED_TX = "Container";
    public static final String STATEFUL_SESSION = "Stateful";
    public static final String STATELESS_SESSION = "Stateless";
    private static final String EJB_FIND_BY_PRIMARY_KEY = "ejbFindByPrimaryKey";
    protected static final String EJB_CREATE_METHOD = "ejbCreate";
    protected static final String EJB_REMOVE_METHOD = "ejbRemove";
    private static final String EJB_POST_CREATE_METHOD = "ejbPostCreate";
    protected static final String CREATE_METHOD = "create";
    protected static final String EJB_HOME_METHOD = "ejbHome";
    protected static final String EJB_SELECT_METHOD = "ejbSelect";
    private static final String FINALIZE_METHOD = "finalize";
    private static final String REMOVE_METHOD = "remove";
    private static final String GET_HOME_HANDLE_METHOD = "getHomeHandle";
    private static final String GET_EJB_METADATA_METHOD = "getEJBMetaData";

    public AbstractVerifier(VerificationContext context, VerificationEventFactory factory) {
        this.factory = factory;
        this.context = context;
        this.classloader = context.getClassLoader();
        if (this.classloader == null) {
            URL[] list = new URL[]{context.getJarLocation()};
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            this.classloader = new URLClassLoader(list, parent);
        }
    }

    public boolean isAssignableFrom(String className, Class assignableFromClass) {
        try {
            Class<?> clazz = this.classloader.loadClass(className);
            return clazz.isAssignableFrom(assignableFromClass);
        }
        catch (ClassNotFoundException e) {
            log.warn((java.lang.Object)("Failed to find class: " + className), (Throwable)e);
            return false;
        }
    }

    public boolean isAssignableFrom(Class clazz, String assignableFromClassName) {
        try {
            Class<?> assignableFromClass = this.classloader.loadClass(assignableFromClassName);
            return clazz.isAssignableFrom(assignableFromClass);
        }
        catch (ClassNotFoundException e) {
            log.warn((java.lang.Object)("Failed to find class: " + assignableFromClassName), (Throwable)e);
            return false;
        }
    }

    public abstract boolean isCreateMethod(Method var1);

    public abstract boolean isEjbCreateMethod(Method var1);

    public boolean hasLegalRMIIIOPArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (this.isRMIIIOPType(params[i])) continue;
            return false;
        }
        return true;
    }

    public boolean hasLegalRMIIIOPReturnType(Method method) {
        return this.isRMIIIOPType(method.getReturnType());
    }

    public boolean hasLegalRMIIIOPExceptionTypes(Method method) {
        for (Class<?> exception : Arrays.asList(method.getExceptionTypes())) {
            if (this.isRMIIDLExceptionType(exception)) continue;
            return false;
        }
        return true;
    }

    public boolean throwsRemoteException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        for (int i = 0; i < exception.length; ++i) {
            if (exception[i].equals(IOException.class) || exception[i].equals(Exception.class) || !this.isAssignableFrom(exception[i], "java.rmi.RemoteException")) continue;
            return true;
        }
        return false;
    }

    public boolean hasSingleArgument(Method method, Class argClass) {
        Class<?>[] params = method.getParameterTypes();
        return params.length == 1 && params[0].equals(argClass);
    }

    public boolean hasNoArguments(Method method) {
        Class<?>[] params = method.getParameterTypes();
        return params.length == 0;
    }

    public boolean throwsNoException(Method method) {
        boolean hasCheckedException = false;
        Class<?>[] exceptions = method.getExceptionTypes();
        for (int e = 0; e < exceptions.length; ++e) {
            Class<?> ex = exceptions[e];
            boolean isError = Error.class.isAssignableFrom(ex);
            boolean isRuntimeException = RuntimeException.class.isAssignableFrom(ex);
            boolean isRemoteException = RemoteException.class.isAssignableFrom(ex);
            if (isError || isRuntimeException || isRemoteException) continue;
            hasCheckedException = true;
        }
        return !hasCheckedException;
    }

    public boolean throwsCreateException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        for (int i = 0; i < exception.length; ++i) {
            if (!this.isAssignableFrom("javax.ejb.CreateException", exception[i])) continue;
            return true;
        }
        return false;
    }

    public boolean throwsFinderException(Method method) {
        Class<?>[] exception = method.getExceptionTypes();
        for (int i = 0; i < exception.length; ++i) {
            if (!this.isAssignableFrom("javax.ejb.FinderException", exception[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public boolean isStatic(Class c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public boolean isFinal(Class c) {
        return Modifier.isFinal(c.getModifiers());
    }

    public boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public boolean isPublic(Class c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public boolean isAllFieldsPublic(Class c) {
        try {
            Field[] list = c.getFields();
            for (int i = 0; i < list.length; ++i) {
                if (Modifier.isPublic(list[i].getModifiers())) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isAbstract(Class c) {
        return Modifier.isAbstract(c.getModifiers());
    }

    public boolean isAbstract(Method m) {
        return Modifier.isAbstract(m.getModifiers());
    }

    public boolean isSingleObjectFinder(EntityMetaData entity, Method finder) {
        return this.hasPrimaryKeyReturnType(entity, finder);
    }

    public boolean isMultiObjectFinder(Method f) {
        return Collection.class.isAssignableFrom(f.getReturnType()) || Enumeration.class.isAssignableFrom(f.getReturnType());
    }

    public boolean hasRemoteReturnType(BeanMetaData bean, Method m) {
        try {
            Class<?> clazz = this.classloader.loadClass(bean.getRemote());
            return m.getReturnType().isAssignableFrom(clazz);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasLocalReturnType(BeanMetaData bean, Method m) {
        try {
            Class<?> clazz = this.classloader.loadClass(bean.getLocal());
            return m.getReturnType().isAssignableFrom(clazz);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasVoidReturnType(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public boolean hasMessageDrivenBeanInterface(Class c) {
        return this.isAssignableFrom("javax.ejb.MessageDrivenBean", c);
    }

    public boolean hasMessageListenerInterface(Class c) {
        return this.isAssignableFrom("javax.jms.MessageListener", c);
    }

    public boolean hasSessionBeanInterface(Class c) {
        return this.isAssignableFrom("javax.ejb.SessionBean", c);
    }

    public boolean hasEntityBeanInterface(Class c) {
        return this.isAssignableFrom("javax.ejb.EntityBean", c);
    }

    public boolean hasEJBObjectInterface(Class c) {
        return this.isAssignableFrom(EJB_OBJECT_INTERFACE, c);
    }

    public boolean hasEJBLocalObjectInterface(Class c) {
        return this.isAssignableFrom(EJB_LOCAL_OBJECT_INTERFACE, c);
    }

    public boolean hasEJBHomeInterface(Class c) {
        return this.isAssignableFrom(EJB_HOME_INTERFACE, c);
    }

    public boolean hasEJBLocalHomeInterface(Class c) {
        return this.isAssignableFrom(EJB_LOCAL_HOME_INTERFACE, c);
    }

    public boolean hasSessionSynchronizationInterface(Class c) {
        return this.isAssignableFrom("javax.ejb.SessionSynchronization", c);
    }

    public boolean hasDefaultConstructor(Class c) {
        try {
            Constructor ctr = c.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public boolean hasFinalizer(Class c) {
        try {
            Method finalizer = c.getDeclaredMethod(FINALIZE_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public boolean hasFinderMethod(Class c) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!method[i].getName().startsWith("ejbFind")) continue;
            return true;
        }
        return false;
    }

    public boolean isFinderMethod(Method m) {
        return m.getName().startsWith("find");
    }

    public boolean isOnMessageMethod(Method m) {
        Class<?>[] paramTypes;
        return "onMessage".equals(m.getName()) && (paramTypes = m.getParameterTypes()).length == 1 && Message.class.equals(paramTypes[0]);
    }

    public boolean hasANonStaticField(Class c) {
        try {
            Field[] list = c.getFields();
            for (int i = 0; i < list.length; ++i) {
                if (Modifier.isStatic(list[i].getModifiers())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean hasOnMessageMethod(Class c) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isOnMessageMethod(method[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasCreateMethod(Class c) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isCreateMethod(method[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasEJBCreateMethod(Class c, boolean isSession) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isEjbCreateMethod(method[i]) || this.isStatic(method[i]) || this.isFinal(method[i]) || (!isSession || !this.hasVoidReturnType(method[i])) && isSession) continue;
            return true;
        }
        return false;
    }

    public boolean hasDefaultCreateMethod(Class home) {
        Method[] method = home.getMethods();
        for (int i = 0; i < method.length; ++i) {
            Class<?>[] params;
            if (!this.isCreateMethod(method[i]) || (params = method[i].getParameterTypes()).length != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasEJBFindByPrimaryKey(Class c) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!method[i].getName().equals(EJB_FIND_BY_PRIMARY_KEY)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrimaryKeyReturnType(EntityMetaData entity, Method m) {
        try {
            return m.getReturnType().isAssignableFrom(this.classloader.loadClass(entity.getPrimaryKeyClass()));
        }
        catch (ClassNotFoundException cnfe) {
            return m.getReturnType().getName().equals(entity.getPrimaryKeyClass());
        }
    }

    public Method getDefaultCreateMethod(Class c) {
        Method method = null;
        try {
            method = c.getMethod(CREATE_METHOD, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    public Method getEJBFindByPrimaryKey(Class c) {
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!method[i].getName().equals(EJB_FIND_BY_PRIMARY_KEY)) continue;
            return method[i];
        }
        return null;
    }

    public Iterator getEJBFindMethods(Class c) {
        LinkedList<Method> finders = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!method[i].getName().startsWith("ejbFind")) continue;
            finders.add(method[i]);
        }
        return finders.iterator();
    }

    public Iterator getFinderMethods(Class home) {
        LinkedList<Method> finders = new LinkedList<Method>();
        Method[] method = home.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!method[i].getName().startsWith("find")) continue;
            finders.add(method[i]);
        }
        return finders.iterator();
    }

    public Iterator getOnMessageMethods(Class c) {
        LinkedList<Method> onMessages = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isOnMessageMethod(method[i])) continue;
            onMessages.add(method[i]);
        }
        return onMessages.iterator();
    }

    public Iterator getEJBCreateMethods(Class c) {
        LinkedList<Method> ejbCreates = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isEjbCreateMethod(method[i])) continue;
            ejbCreates.add(method[i]);
        }
        return ejbCreates.iterator();
    }

    public Iterator getCreateMethods(Class c) {
        LinkedList<Method> creates = new LinkedList<Method>();
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isCreateMethod(method[i])) continue;
            creates.add(method[i]);
        }
        return creates.iterator();
    }

    public boolean hasMoreThanOneCreateMethods(Class c) {
        int count = 0;
        Method[] method = c.getMethods();
        for (int i = 0; i < method.length; ++i) {
            if (!this.isCreateMethod(method[i])) continue;
            ++count;
        }
        return count > 1;
    }

    public boolean hasMatchingExceptions(Method source, Method target) {
        Class<?>[] a = source.getExceptionTypes();
        Class<?>[] b = target.getExceptionTypes();
        Class<?> rteClass = null;
        Class<?> errorClass = null;
        try {
            rteClass = this.classloader.loadClass("java.lang.RuntimeException");
            errorClass = this.classloader.loadClass("java.lang.Error");
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        for (int i = 0; i < a.length; ++i) {
            if (rteClass.isAssignableFrom(a[i]) || errorClass.isAssignableFrom(a[i])) continue;
            boolean found = false;
            for (int j = 0; j < b.length; ++j) {
                if (!b[j].isAssignableFrom(a[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean hasMatchingMethod(Class bean, Method method) {
        try {
            bean.getMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean hasMatchingReturnType(Method a, Method b) {
        return a.getReturnType() == b.getReturnType();
    }

    public boolean hasMatchingEJBPostCreate(Class bean, Method create) {
        try {
            return bean.getMethod(this.getMatchingEJBPostCreateName(create.getName()), create.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean hasMatchingEJBCreate(Class bean, Method create) {
        try {
            return bean.getMethod(this.getMatchingEJBCreateName(create.getName()), create.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public Method getMatchingEJBPostCreate(Class bean, Method create) {
        try {
            return bean.getMethod(this.getMatchingEJBPostCreateName(create.getName()), create.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Method getMatchingEJBCreate(Class bean, Method create) {
        try {
            return bean.getMethod(this.getMatchingEJBCreateName(create.getName()), create.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean hasMatchingEJBFind(Class bean, Method finder) {
        try {
            String methodName = "ejbF" + finder.getName().substring(1);
            return bean.getMethod(methodName, finder.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public Method getMatchingEJBFind(Class bean, Method finder) {
        try {
            String methodName = "ejbF" + finder.getName().substring(1);
            return bean.getMethod(methodName, finder.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean hasMatchingEJBHome(Class bean, Method home) {
        try {
            return bean.getMethod(this.getMatchingEJBHomeName(home.getName()), home.getParameterTypes()) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    protected void fireSpecViolationEvent(BeanMetaData bean, Section section) {
        this.fireSpecViolationEvent(bean, null, section);
    }

    protected void fireSpecViolationEvent(BeanMetaData bean, Method method, Section section) {
        VerificationEvent event = this.factory.createSpecViolationEvent(this.context, section);
        event.setName(bean.getEjbName());
        event.setMethod(method);
        this.context.fireSpecViolation(event);
    }

    protected final void fireBeanVerifiedEvent(BeanMetaData bean) {
        this.fireBeanVerifiedEvent(bean, null);
    }

    protected final void fireBeanVerifiedEvent(BeanMetaData bean, String msg) {
        VerificationEvent event = this.factory.createBeanVerifiedEvent(this.context);
        event.setName(bean.getEjbName());
        if (msg != null) {
            event.setMessage(msg);
        }
        this.context.fireBeanChecked(event);
    }

    public void checkMessageBean(MessageDrivenMetaData bean) {
    }

    public StrategyContext getContext() {
        return this.context;
    }

    protected boolean isRMIIIOPType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return this.isRMIIIOPType(type.getComponentType());
        }
        if (Object.class.isAssignableFrom(type)) {
            return true;
        }
        if (IDLEntity.class.isAssignableFrom(type)) {
            return true;
        }
        if (this.isRMIIDLRemoteInterface(type)) {
            return true;
        }
        if (this.isRMIIDLExceptionType(type)) {
            return true;
        }
        return this.isRMIIDLValueType(type);
    }

    private boolean isRMIIDLRemoteInterface(Class type) {
        if (!Remote.class.isAssignableFrom(type)) {
            return false;
        }
        for (Method m : Arrays.asList(type.getMethods())) {
            if (!this.throwsRemoteException(m)) {
                return false;
            }
            for (Class<?> exception : Arrays.asList(m.getExceptionTypes())) {
                if (this.isRMIIDLExceptionType(exception)) continue;
                return false;
            }
        }
        for (Field f : Arrays.asList(type.getFields())) {
            if (f.getType().isPrimitive() || f.getType().equals(String.class)) continue;
            return false;
        }
        return true;
    }

    private boolean isRMIIDLExceptionType(Class type) {
        if (!Throwable.class.isAssignableFrom(type)) {
            return false;
        }
        if (Error.class.isAssignableFrom(type)) {
            return false;
        }
        return this.isRMIIDLValueType(type);
    }

    protected boolean isRMIIDLValueType(Class type) {
        if (Remote.class.isAssignableFrom(type)) {
            return false;
        }
        return type.getDeclaringClass() == null || this.isStatic(type) || this.isRMIIDLValueType(type.getDeclaringClass());
    }

    private String getMatchingEJBHomeName(String homeName) {
        return EJB_HOME_METHOD + homeName.substring(0, 1).toUpperCase() + homeName.substring(1);
    }

    private String getMatchingEJBCreateName(String createName) {
        return "ejb" + createName.substring(0, 1).toUpperCase() + createName.substring(1);
    }

    private String getMatchingEJBPostCreateName(String createName) {
        int createIdx = createName.indexOf("Create");
        return "ejbPost" + createName.substring(createIdx >= 0 ? createIdx : 0);
    }
}

