/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class ResourceRefMetaData
extends MetaData {
    private String refName;
    private String name;
    private String jndiName;
    private String resURL;
    private String type;
    private boolean containerAuth;
    private boolean isShareable;

    public String getRefName() {
        return this.refName;
    }

    public String getResourceName() {
        if (this.name == null) {
            this.name = this.refName;
        }
        return this.name;
    }

    public void setResourceName(String resName) {
        this.name = resName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getResURL() {
        return this.resURL;
    }

    public String getType() {
        return this.type;
    }

    public boolean isContainerAuth() {
        return this.containerAuth;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        this.refName = ResourceRefMetaData.getElementContent(ResourceRefMetaData.getUniqueChild(element, "res-ref-name"));
        this.type = ResourceRefMetaData.getElementContent(ResourceRefMetaData.getUniqueChild(element, "res-type"));
        String auth = ResourceRefMetaData.getElementContent(ResourceRefMetaData.getUniqueChild(element, "res-auth"));
        if (auth.equalsIgnoreCase("Container")) {
            this.containerAuth = true;
        } else if (auth.equals("Application") || auth.equals("SERVLET")) {
            this.containerAuth = false;
        } else {
            throw new DeploymentException("res-auth tag should be 'Container' or 'Application' or 'SERVLET'");
        }
        String sharing = ResourceRefMetaData.getElementContent(ResourceRefMetaData.getOptionalChild(element, "res-sharing-scope"), "Shareable");
        this.isShareable = sharing.equals("Shareable");
    }

    public void importJbossXml(Element element) throws DeploymentException {
        Element child = ResourceRefMetaData.getOptionalChild(element, "resource-name");
        if (child == null) {
            if (this.type.equals("java.net.URL")) {
                Element resUrl = ResourceRefMetaData.getOptionalChild(element, "res-url");
                if (resUrl != null) {
                    this.resURL = ResourceRefMetaData.getElementContent(resUrl);
                } else {
                    Element name = ResourceRefMetaData.getUniqueChild(element, "jndi-name");
                    this.jndiName = ResourceRefMetaData.getElementContent(name);
                }
            } else {
                this.jndiName = ResourceRefMetaData.getElementContent(ResourceRefMetaData.getUniqueChild(element, "jndi-name"));
            }
        } else {
            this.name = ResourceRefMetaData.getElementContent(child);
        }
    }
}

