/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.util.HashMap;
import javax.ejb.EJBException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCType;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCTypeComplexProperty;

public final class JDBCTypeComplex
implements JDBCType {
    private final JDBCTypeComplexProperty[] properties;
    private final String[] columnNames;
    private final Class[] javaTypes;
    private final int[] jdbcTypes;
    private final String[] sqlTypes;
    private final boolean[] notNull;
    private final JDBCResultSetReader[] resultSetReaders;
    private final JDBCParameterSetter[] paramSetters;
    private final Class fieldType;
    private final HashMap propertiesByName = new HashMap();

    public JDBCTypeComplex(JDBCTypeComplexProperty[] properties, Class fieldType) {
        this.properties = properties;
        this.fieldType = fieldType;
        int propNum = properties.length;
        this.columnNames = new String[propNum];
        this.javaTypes = new Class[propNum];
        this.jdbcTypes = new int[propNum];
        this.sqlTypes = new String[propNum];
        this.notNull = new boolean[propNum];
        this.resultSetReaders = new JDBCResultSetReader[propNum];
        this.paramSetters = new JDBCParameterSetter[propNum];
        for (int i = 0; i < properties.length; ++i) {
            JDBCTypeComplexProperty property = properties[i];
            this.columnNames[i] = property.getColumnName();
            this.javaTypes[i] = property.getJavaType();
            this.jdbcTypes[i] = property.getJDBCType();
            this.sqlTypes[i] = property.getSQLType();
            this.notNull[i] = property.isNotNull();
            this.resultSetReaders[i] = property.getResulSetReader();
            this.paramSetters[i] = property.getParameterSetter();
            this.propertiesByName.put(property.getPropertyName(), property);
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Class[] getJavaTypes() {
        return this.javaTypes;
    }

    public int[] getJDBCTypes() {
        return this.jdbcTypes;
    }

    public String[] getSQLTypes() {
        return this.sqlTypes;
    }

    public boolean[] getNotNull() {
        return this.notNull;
    }

    public boolean[] getAutoIncrement() {
        return new boolean[]{false};
    }

    public Object getColumnValue(int index, Object value) {
        return JDBCTypeComplex.getColumnValue(this.properties[index], value);
    }

    public Object setColumnValue(int index, Object value, Object columnValue) {
        return this.setColumnValue(this.properties[index], value, columnValue);
    }

    public JDBCResultSetReader[] getResultSetReaders() {
        return this.resultSetReaders;
    }

    public JDBCParameterSetter[] getParameterSetter() {
        return this.paramSetters;
    }

    public JDBCTypeComplexProperty[] getProperties() {
        return this.properties;
    }

    public JDBCTypeComplexProperty getProperty(String propertyName) {
        JDBCTypeComplexProperty prop = (JDBCTypeComplexProperty)this.propertiesByName.get(propertyName);
        if (prop == null) {
            throw new EJBException(this.fieldType.getName() + " does not have a property named " + propertyName);
        }
        return prop;
    }

    private static Object getColumnValue(JDBCTypeComplexProperty property, Object value) {
        try {
            return property.getColumnValue(value);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Error getting column value", e);
        }
    }

    private Object setColumnValue(JDBCTypeComplexProperty property, Object value, Object columnValue) {
        if (value == null && columnValue == null) {
            return null;
        }
        try {
            if (value == null) {
                value = this.fieldType.newInstance();
            }
            return property.setColumnValue(value, columnValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException("Error setting column value", e);
        }
    }
}

