/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ejb.FinderException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.jdbc.AliasManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCAbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCFunctionMappingMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCReadAheadMetaData;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCTypeMappingMetaData;

public final class JDBCFindByPrimaryKeyQuery
extends JDBCAbstractQueryCommand {
    private JDBCStoreManager manager;
    private boolean rowLocking;

    public JDBCFindByPrimaryKeyQuery(JDBCStoreManager manager, JDBCQueryMetaData q) throws DeploymentException {
        super(manager, q);
        this.manager = manager;
        this.rowLocking = manager.getMetaData().hasRowLocking();
        JDBCEntityBridge entity = (JDBCEntityBridge)manager.getEntityBridge();
        JDBCTypeMappingMetaData typeMapping = this.manager.getJDBCTypeFactory().getTypeMapping();
        AliasManager aliasManager = new AliasManager(typeMapping.getAliasHeaderPrefix(), typeMapping.getAliasHeaderSuffix(), typeMapping.getAliasMaxLength());
        String alias = aliasManager.getAlias(entity.getEntityName());
        StringBuffer select = new StringBuffer(200);
        SQLUtil.getColumnNamesClause(entity.getPrimaryKeyFields(), alias, select);
        StringBuffer from = new StringBuffer();
        from.append(entity.getQualifiedTableName()).append(' ').append(alias);
        JDBCReadAheadMetaData readAhead = q.getReadAhead();
        if (readAhead.isOnFind()) {
            this.setEagerLoadGroup(readAhead.getEagerLoadGroup());
            if (this.getEagerLoadMask() != null) {
                SQLUtil.appendColumnNamesClause(entity.getTableFields(), this.getEagerLoadMask(), alias, select);
                List onFindCMRList = JDBCAbstractQueryCommand.getLeftJoinCMRNodes(entity, entity.getQualifiedTableName(), readAhead.getLeftJoins());
                if (!onFindCMRList.isEmpty()) {
                    this.setOnFindCMRList(onFindCMRList);
                    JDBCAbstractQueryCommand.leftJoinCMRNodes(alias, onFindCMRList, aliasManager, from);
                    JDBCAbstractQueryCommand.appendLeftJoinCMRColumnNames(onFindCMRList, aliasManager, select);
                }
            }
        }
        StringBuffer where = new StringBuffer();
        SQLUtil.getWhereClause(entity.getPrimaryKeyFields(), alias, where);
        StringBuffer sql = new StringBuffer(300);
        if (this.rowLocking && readAhead.isOnFind() && this.getEagerLoadMask() != null) {
            JDBCFunctionMappingMetaData rowLockingTemplate = typeMapping.getRowLockingTemplate();
            rowLockingTemplate.getFunctionSql(new Object[]{select, from, where.length() == 0 ? null : where, null}, sql);
        } else {
            sql.append("SELECT ").append(select).append(" FROM ").append(from).append(" WHERE ").append(where);
        }
        this.setSQL(sql.toString());
        this.setParameterList(QueryParameter.createPrimaryKeyParameters(0, entity));
    }

    public Collection execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws FinderException {
        if (this.manager.getReadAheadCache().getPreloadDataMap(args[0], false) != null) {
            Object ejbObject = factory.getEntityEJBObject(args[0]);
            return Collections.singletonList(ejbObject);
        }
        return super.execute(finderMethod, args, ctx, factory);
    }
}

