/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.ToOne;
import org.hibernate.util.StringHelper;

public class ToOneMappedBySecondPass
implements SecondPass {
    private String mappedBy;
    private ToOne value;
    private Mappings mappings;
    private String ownerEntity;
    private String ownerProperty;

    public ToOneMappedBySecondPass(String mappedBy, ToOne value, String ownerEntity, String ownerProperty, Mappings mappings) {
        this.ownerEntity = ownerEntity;
        this.ownerProperty = ownerProperty;
        this.mappedBy = mappedBy;
        this.value = value;
        this.mappings = mappings;
    }

    public void doSecondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        Property property;
        PersistentClass otherSide = (PersistentClass)persistentClasses.get(this.value.getReferencedEntityName());
        try {
            if (otherSide == null) {
                throw new MappingException("Unable to find entity: " + this.value.getReferencedEntityName());
            }
            property = otherSide.getProperty(this.mappedBy);
        }
        catch (MappingException e) {
            throw new AnnotationException("Unknown mappedBy in: " + StringHelper.qualify((String)this.ownerEntity, (String)this.ownerProperty) + ", referenced property unknown: " + StringHelper.qualify((String)this.value.getReferencedEntityName(), (String)this.mappedBy));
        }
        if (!(property.getValue() instanceof OneToOne)) {
            if (property.getValue() instanceof ManyToOne) {
                this.value.setReferencedPropertyName(this.mappedBy);
                String propertyRef = this.value.getReferencedPropertyName();
                if (propertyRef != null) {
                    this.mappings.addUniquePropertyReference(this.value.getReferencedEntityName(), propertyRef);
                }
            } else {
                throw new AnnotationException("Referenced property not a (One|Many)ToOne: " + StringHelper.qualify((String)this.value.getReferencedEntityName(), (String)this.value.getReferencedPropertyName()) + " in mappedBy of " + StringHelper.qualify((String)this.ownerEntity, (String)this.ownerProperty));
            }
        }
    }
}

