/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;

public class FkSecondPass
implements SecondPass {
    private Value value;
    private Ejb3JoinColumn[] columns;
    private boolean unique;
    private ExtendedMappings mappings;
    private String path;

    FkSecondPass(Value value, Ejb3JoinColumn[] columns, boolean unique, String path, ExtendedMappings mappings) {
        this.mappings = mappings;
        this.value = value;
        this.columns = columns;
        this.unique = unique;
        this.path = path;
    }

    public void doSecondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        if (this.value instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)this.value;
            PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
            if (ref == null) {
                throw new AnnotationException("@OneToOne or @ManyToOne on " + this.path + " references an unknown entity: " + manyToOne.getReferencedEntityName());
            }
            BinderHelper.createSyntheticPropertyReference(this.columns, ref, null, (Value)manyToOne, false, this.mappings);
            TableBinder.bindFk(ref, null, this.columns, (SimpleValue)manyToOne, this.unique, this.mappings);
            if (!manyToOne.isIgnoreNotFound()) {
                manyToOne.createPropertyRefConstraints(persistentClasses);
            }
        } else {
            throw new AssertionFailure("FkSecondPass for a wrong value type: " + this.value.getClass().getName());
        }
    }
}

