/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfiguration
extends Configuration {
    private static Log log = LogFactory.getLog(AnnotationConfiguration.class);
    public static final String ARTEFACT = "hibernate.mapping.precedence";
    public static final String DEFAULT_PRECEDENCE = "hbm, class";
    private Map namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<String[]>> tableUniqueConstraints;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private List<Class> annotatedClasses;
    private Map<String, Class> annotatedClassEntities;
    private Map<String, Document> hbmEntities;
    private List<CacheHolder> caches;
    private List<Document> hbmDocuments;
    private String precedence = null;
    private boolean inSecondPass = false;

    public AnnotationConfiguration() {
    }

    public AnnotationConfiguration(SettingsFactory sf) {
        super(sf);
    }

    protected List<Class> orderAndFillHierarchy(List<Class> original) {
        ArrayList<Class> copy = new ArrayList<Class>(original);
        for (Class clazz : original) {
            for (Class superClass = clazz.getSuperclass(); superClass != Object.class && !copy.contains(superClass); superClass = superClass.getSuperclass()) {
                if (!superClass.isAnnotationPresent(Entity.class) && !superClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                copy.add(superClass);
            }
        }
        ArrayList<Class> workingCopy = new ArrayList<Class>(copy);
        ArrayList<Class> newList = new ArrayList<Class>(copy.size());
        while (workingCopy.size() > 0) {
            Class clazz = (Class)workingCopy.get(0);
            AnnotationConfiguration.orderHierarchy(workingCopy, newList, copy, clazz);
        }
        return newList;
    }

    private static void orderHierarchy(List<Class> copy, List<Class> newList, List<Class> original, Class clazz) {
        if (Object.class.equals((Object)clazz)) {
            return;
        }
        AnnotationConfiguration.orderHierarchy(copy, newList, original, clazz.getSuperclass());
        if (original.contains(clazz)) {
            if (!newList.contains(clazz)) {
                newList.add(clazz);
            }
            copy.remove(clazz);
        }
    }

    public AnnotationConfiguration addAnnotatedClass(Class persistentClass) throws MappingException {
        try {
            if (persistentClass.isAnnotationPresent(Entity.class)) {
                this.annotatedClassEntities.put(persistentClass.getName(), persistentClass);
            }
            this.annotatedClasses.add(persistentClass);
            return this;
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public AnnotationConfiguration addPackage(String packageName) throws MappingException {
        log.info((Object)("Mapping package " + packageName));
        try {
            AnnotationBinder.bindPackage(packageName, this.createExtendedMappings());
            return this;
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public ExtendedMappings createExtendedMappings() {
        return new ExtendedMappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.sqlResultSetMappings, this.imports, this.secondPasses, this.propertyReferences, this.namingStrategy, this.typeDefs, this.filterDefinitions, this.namedGenerators, this.joins, this.classTypes, this.extendsQueue, this.tableNameBinding, this.columnNameBindingPerTable, this.auxiliaryDatabaseObjects, this.generatorTables, this.tableUniqueConstraints, this.mappedByResolver, this.propertyRefResolver);
    }

    public void setCacheConcurrencyStrategy(String clazz, String concurrencyStrategy, String region, boolean cacheLazyProperty) throws MappingException {
        this.caches.add(new CacheHolder(clazz, concurrencyStrategy, region, true, cacheLazyProperty));
    }

    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) throws MappingException {
        this.caches.add(new CacheHolder(collectionRole, concurrencyStrategy, region, false, false));
    }

    protected void reset() {
        super.reset();
        this.namedGenerators = new HashMap();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.tableUniqueConstraints = new HashMap<Table, List<String[]>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.annotatedClasses = new ArrayList<Class>();
        this.caches = new ArrayList<CacheHolder>();
        this.hbmEntities = new HashMap<String, Document>();
        this.annotatedClassEntities = new HashMap<String, Class>();
        this.hbmDocuments = new ArrayList<Document>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
    }

    protected void secondPassCompile() throws MappingException {
        StringTokenizer precedences;
        log.debug((Object)"Execute first pass mapping processing");
        if (this.precedence == null) {
            this.precedence = this.getProperties().getProperty(ARTEFACT);
        }
        if (this.precedence == null) {
            this.precedence = DEFAULT_PRECEDENCE;
        }
        if (!(precedences = new StringTokenizer(this.precedence, ",; ", false)).hasMoreElements()) {
            throw new MappingException("hibernate.mapping.precedence cannot be empty: " + this.precedence);
        }
        while (precedences.hasMoreElements()) {
            String artifact = (String)precedences.nextElement();
            this.removeConflictedArtifact(artifact);
            this.processArtifactsOfType(artifact);
        }
        int cacheNbr = this.caches.size();
        for (int index = 0; index < cacheNbr; ++index) {
            CacheHolder cacheHolder = this.caches.get(index);
            if (cacheHolder.isClass) {
                super.setCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region, cacheHolder.cacheLazy);
                continue;
            }
            super.setCollectionCacheConcurrencyStrategy(cacheHolder.role, cacheHolder.usage, cacheHolder.region);
        }
        this.caches.clear();
        log.debug((Object)"processing manytoone fk mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            SecondPass sp = (SecondPass)iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            sp.doSecondPass(this.classes, Collections.EMPTY_MAP);
            iter.remove();
        }
        this.inSecondPass = true;
        super.secondPassCompile();
        this.inSecondPass = false;
        for (Map.Entry<Table, List<String[]>> entry : this.tableUniqueConstraints.entrySet()) {
            Table table = entry.getKey();
            List<String[]> uniqueConstraints = entry.getValue();
            int uniqueIndexPerTable = 0;
            for (String[] columnNames : uniqueConstraints) {
                String keyName = "key" + uniqueIndexPerTable++;
                this.buildUniqueKeyFromColumnNames(columnNames, table, keyName);
            }
        }
    }

    private void processArtifactsOfType(String artifact) {
        if ("hbm".equalsIgnoreCase(artifact)) {
            log.debug((Object)"Process hbm files");
            for (Document document : this.hbmDocuments) {
                super.add(document);
            }
            this.hbmDocuments.clear();
            this.hbmEntities.clear();
        } else if ("class".equalsIgnoreCase(artifact)) {
            log.debug((Object)"Process annotated classes");
            List<Class> orderedClasses = this.orderAndFillHierarchy(this.annotatedClasses);
            Map<Class, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses);
            ExtendedMappings mappings = this.createExtendedMappings();
            for (Class clazz : orderedClasses) {
                AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, mappings);
            }
            this.annotatedClasses.clear();
            this.annotatedClassEntities.clear();
        } else {
            log.warn((Object)("Unknown artifact: " + artifact));
        }
    }

    private void removeConflictedArtifact(String artifact) {
        block3: {
            block2: {
                if (!"hbm".equalsIgnoreCase(artifact)) break block2;
                for (String entity : this.hbmEntities.keySet()) {
                    if (!this.annotatedClassEntities.containsKey(entity)) continue;
                    this.annotatedClasses.remove(this.annotatedClassEntities.get(entity));
                    this.annotatedClassEntities.remove(entity);
                }
                break block3;
            }
            if (!"class".equalsIgnoreCase(artifact)) break block3;
            for (String entity : this.annotatedClassEntities.keySet()) {
                if (!this.hbmEntities.containsKey(entity)) continue;
                this.hbmDocuments.remove(this.hbmEntities.get(entity));
                this.hbmEntities.remove(entity);
            }
        }
    }

    private void buildUniqueKeyFromColumnNames(String[] columnNames, Table table, String keyName) {
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        ExtendedMappings mappings = this.createExtendedMappings();
        for (int index = 0; index < size; ++index) {
            columns[index] = new Column(mappings.getPhysicalColumnName(columnNames[index], table));
            unbound.add(columns[index]);
        }
        for (Column column : columns) {
            if (!table.containsColumn(column)) continue;
            UniqueKey uc = table.getOrCreateUniqueKey(keyName);
            uc.addColumn(table.getColumn(column));
            unbound.remove(column);
        }
        if (unbound.size() > 0) {
            StringBuilder sb = new StringBuilder("Unable to create unique key constraint (");
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": ");
            for (Column column : unbound) {
                sb.append(column.getName()).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found");
            throw new AnnotationException(sb.toString());
        }
    }

    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pckg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            log.debug((Object)(name + "<-" + rsrc));
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            log.debug((Object)(name + "<-" + jar));
            this.addJar(new File(jar.getValue()));
        } else if (file != null) {
            log.debug((Object)(name + "<-" + file));
            this.addFile(file.getValue());
        } else if (pckg != null) {
            log.debug((Object)(name + "<-" + pckg));
            this.addPackage(pckg.getValue());
        } else if (clazz != null) {
            log.debug((Object)(name + "<-" + clazz));
            Class loadedClass = null;
            try {
                loadedClass = ReflectHelper.classForName((String)clazz.getValue());
            }
            catch (ClassNotFoundException cnf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", (Throwable)cnf);
            }
            catch (NoClassDefFoundError ncdf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", (Throwable)ncdf);
            }
            this.addAnnotatedClass(loadedClass);
        } else {
            throw new MappingException("<mapping> element in configuration specifies no attributes");
        }
    }

    protected void add(Document doc) throws MappingException {
        if (this.inSecondPass) {
            super.add(doc);
        } else {
            Element hmNode = doc.getRootElement();
            Attribute packNode = hmNode.attribute("package");
            String defaultPackage = packNode != null ? packNode.getValue() : "";
            HashSet entityNames = new HashSet();
            AnnotationConfiguration.findClassNames(defaultPackage, hmNode, entityNames);
            for (String entity : entityNames) {
                this.hbmEntities.put(entity, doc);
            }
            this.hbmDocuments.add(doc);
        }
    }

    private static void findClassNames(String defaultPackage, Element startNode, Set names) {
        Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
        JoinedIterator classIterator = new JoinedIterator(classes);
        while (classIterator.hasNext()) {
            Element element = (Element)classIterator.next();
            String entityName = element.attributeValue("entity-name");
            if (entityName == null) {
                entityName = AnnotationConfiguration.getClassName(element.attribute("name"), defaultPackage);
            }
            names.add(entityName);
            AnnotationConfiguration.findClassNames(defaultPackage, element, names);
        }
    }

    private static String getClassName(Attribute name, String defaultPackage) {
        if (name == null) {
            return null;
        }
        String unqualifiedName = name.getValue();
        if (unqualifiedName == null) {
            return null;
        }
        if (unqualifiedName.indexOf(46) < 0 && defaultPackage != null) {
            return defaultPackage + '.' + unqualifiedName;
        }
        return unqualifiedName;
    }

    public void setPrecedence(String precedence) {
        this.precedence = precedence;
    }

    private class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String role, String usage, String region, boolean isClass, boolean cacheLazy) {
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.isClass = isClass;
            this.cacheLazy = cacheLazy;
        }
    }
}

