/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.TypeHintContext;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class DefaultConverterManager
implements ConverterManager {
    private Map extraTypeInfoMap = new HashMap();
    private static final Logger log;
    private Map converterTypes = new HashMap();
    private Map converters = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.impl.DefaultConverterManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void addConverterType(String id, Class clazz) {
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("uk.ltd.getahead.dwr.Converter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("uk.ltd.getahead.dwr.Converter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.ConverterNotAssignable", clazz, clazz3.getName()));
        }
        try {
            clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.ConverterNotInstantiatable", clazz.getName(), ex.toString()));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(Messages.getString("DefaultConverterManager.ConverterNotAccessable", clazz.getName(), ex.toString()));
        }
        this.converterTypes.put(id, clazz);
    }

    public void addConverter(String match, String type, Map params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class clazz = (Class)this.converterTypes.get(type);
        if (clazz == null) {
            log.info("Type '" + match + "' is not convertable due to missing converter '" + type + "'. This is only an problem if you wanted to use it.");
            return;
        }
        Converter converter = (Converter)clazz.newInstance();
        converter.setConverterManager(this);
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            try {
                LocalUtil.setProperty(converter, key, value);
            }
            catch (NoSuchMethodException ex) {
                if (key.equals("converter") || key.equals("match")) continue;
                log.debug("No property '" + key + "' on " + converter.getClass().getName());
            }
            catch (InvocationTargetException ex) {
                log.warn("Error setting " + key + "=" + value + " on " + converter.getClass().getName(), ex.getTargetException());
            }
            catch (Exception ex) {
                log.warn("Error setting " + key + "=" + value + " on " + converter.getClass().getName(), ex);
            }
        }
        this.addConverter(match, converter);
    }

    public void addConverter(String match, Converter converter) throws IllegalArgumentException {
        Converter other = (Converter)this.converters.get(match);
        if (other != null) {
            log.warn("Clash of converters for " + match + ". Using " + converter.getClass().getName() + " in place of " + other.getClass().getName());
        }
        this.converters.put(match, converter);
    }

    public boolean isConvertable(Class paramType) {
        return this.getConverter(paramType) != null;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx, TypeHintContext incc) throws ConversionException {
        Object converted = inctx.getConverted(iv, paramType);
        if (converted == null) {
            Converter converter = this.getConverter(paramType);
            if (converter == null) {
                throw new ConversionException(Messages.getString("DefaultConverterManager.MissingConverter", paramType.getName()));
            }
            if (iv.isNull()) {
                return null;
            }
            inctx.pushContext(incc);
            converted = converter.convertInbound(paramType, iv, inctx);
            inctx.popContext();
        }
        return converted;
    }

    public OutboundVariable convertOutbound(Object object, OutboundContext converted) throws ConversionException {
        if (object == null) {
            String varName = converted.getNextVariableName();
            return new OutboundVariable("var " + varName + "=null;", varName);
        }
        OutboundVariable ov = converted.get(object);
        if (ov != null) {
            return new OutboundVariable("", ov.getAssignCode());
        }
        ov = new OutboundVariable();
        String varName = converted.getNextVariableName();
        ov.setAssignCode(varName);
        converted.put(object, ov);
        Converter converter = this.getConverter(object);
        if (converter == null) {
            log.error(Messages.getString("DefaultConverterManager.MissingConverter", object.getClass().getName()));
            return new OutboundVariable("var " + varName + "=null;", varName);
        }
        ov.setInitCode(converter.convertOutbound(object, ov.getAssignCode(), converted));
        return ov;
    }

    public void setExtraTypeInfo(TypeHintContext thc, Class type) {
        this.extraTypeInfoMap.put(thc, type);
    }

    public Class getExtraTypeInfo(TypeHintContext thc) {
        Class type = (Class)this.extraTypeInfoMap.get(thc);
        if (type == null) {
            log.warn("Missing type info for " + thc + ". Assuming this is a map with String keys. Please add to <signatures> in dwr.xml");
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            type = clazz;
            if (log.isDebugEnabled()) {
                log.debug("Known extra type info:");
                Iterator it = this.extraTypeInfoMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Class temp = (Class)entry.getValue();
                    log.debug("  " + entry.getKey() + " = " + temp.getName());
                }
            }
        } else {
            log.debug("Using extra type info for " + thc + " of " + type);
        }
        return type;
    }

    public void setConverters(Map converters) {
        this.converters = converters;
    }

    private Converter getConverter(Object object) {
        if (object == null) {
            return this.getConverter(Void.TYPE);
        }
        return this.getConverter(object.getClass());
    }

    private Converter getConverter(Class paramType) {
        block7: {
            Converter converter = this.getConverterAssignableFrom(paramType);
            if (converter != null) {
                return converter;
            }
            String lookup = paramType.getName();
            if (lookup.startsWith("$Proxy") && (converter = (Converter)this.converters.get("$Proxy*")) != null) {
                return converter;
            }
            while (true) {
                if ((converter = (Converter)this.converters.get(String.valueOf(lookup) + ".*")) != null) {
                    return converter;
                }
                converter = (Converter)this.converters.get(String.valueOf(lookup) + '*');
                if (converter != null) {
                    return converter;
                }
                if (lookup.length() == 0) break block7;
                int lastdot = lookup.lastIndexOf(46);
                if (lastdot != -1) {
                    lookup = lookup.substring(0, lastdot);
                    continue;
                }
                int arrayMarkers = 0;
                while (lookup.charAt(arrayMarkers) == '[') {
                    ++arrayMarkers;
                }
                if (arrayMarkers == 0) break block7;
                converter = (Converter)this.converters.get(lookup = lookup.substring(arrayMarkers - 1, arrayMarkers + 1));
                if (converter != null) break;
            }
            return converter;
        }
        return null;
    }

    private Converter getConverterAssignableFrom(Class paramType) {
        if (paramType == null) {
            return null;
        }
        String lookup = paramType.getName();
        Converter converter = (Converter)this.converters.get(lookup);
        if (converter != null) {
            return converter;
        }
        Class<?>[] interfaces = paramType.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            converter = this.getConverterAssignableFrom(interfaces[i]);
            if (converter != null) {
                this.converters.put(lookup, converter);
                return converter;
            }
            ++i;
        }
        converter = this.getConverterAssignableFrom(paramType.getSuperclass());
        if (converter != null) {
            this.converters.put(lookup, converter);
        }
        return converter;
    }
}

