/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.service;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.ejb.TimerService;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.annotation.ejb.Management;
import org.jboss.annotation.ejb.Service;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.SessionContainer;
import org.jboss.ejb3.ThreadLocalENCFactory;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.service.ServiceBeanContext;
import org.jboss.ejb3.service.ServiceMBeanDelegate;
import org.jboss.logging.Logger;

public class ServiceContainer
extends SessionContainer {
    ServiceMBeanDelegate delegate;
    Object singleton;
    boolean injected;
    BeanContext beanContext;
    MBeanServer mbeanServer;
    ObjectName delegateObjectName;
    private static final Logger log = Logger.getLogger(ServiceContainer.class);

    public ServiceContainer(MBeanServer server, ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
        this.beanContextClass = ServiceBeanContext.class;
        this.mbeanServer = server;
    }

    public Object getSingleton() {
        return this.singleton;
    }

    public void start() throws Exception {
        super.start();
        try {
            this.singleton = super.construct();
            this.registerManagementInterface();
            this.resolveInterceptorInjectors();
        }
        catch (Exception e) {
            this.stop();
        }
    }

    public void stop() throws Exception {
        super.stop();
        if (this.delegate != null) {
            this.getDeployment().getKernelAbstraction().uninstallMBean(this.delegateObjectName);
        }
        this.injected = false;
    }

    public void initializePool() throws Exception {
        this.resolveInjectors();
    }

    public TimerService getTimerService() {
        throw new RuntimeException("TimerService not implemented for container");
    }

    public void invokePostConstruct(BeanContext beanContext) {
    }

    public void invokePreDestroy(BeanContext beanContext) {
    }

    public void invokeInit(Object bean) {
    }

    public Object localInvoke(Method method, Object[] args) throws Throwable {
        return this.localInvoke(method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classloader);
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Interceptor[] aspects = info.interceptors;
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            nextInvocation = this.populateInvocation(nextInvocation);
            if (provider != null) {
                nextInvocation.getMetaData().addMetaData((Object)"ASYNCH", (Object)"INVOKE_ASYNCH", (Object)"YES", PayloadKey.AS_IS);
                nextInvocation.getMetaData().addMetaData((Object)"ASYNCH", (Object)"FUTURE_HOLDER", (Object)provider, PayloadKey.AS_IS);
            }
            Object object = nextInvocation.invokeNext();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        EJBContainerInvocation newSi = null;
        try {
            InvocationResponse response;
            Thread.currentThread().setContextClassLoader(this.classloader);
            MethodInvocation si = (MethodInvocation)invocation;
            MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call");
            }
            Interceptor[] aspects = info.interceptors;
            newSi = new EJBContainerInvocation(info, aspects);
            newSi.setArguments(si.getArguments());
            newSi.setMetaData(si.getMetaData());
            newSi.setAdvisor((Advisor)this);
            newSi = this.populateInvocation(newSi);
            InvocationResponse invocationResponse = response = SessionContainer.marshallResponse(invocation, newSi.invokeNext(), newSi.getResponseContextInfo());
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EJBContainerInvocation populateInvocation(EJBContainerInvocation invocation) {
        try {
            if (this.beanContext == null) {
                Object object = this.singleton;
                synchronized (object) {
                    if (this.beanContext == null) {
                        this.beanContext = (BeanContext)this.beanContextClass.newInstance();
                        this.beanContext.setContainer(this);
                        this.beanContext.initialiseInterceptorInstances();
                        this.beanContext.setInstance(this.singleton);
                    }
                }
                if (!this.injected) {
                    this.injectDependencies(this.beanContext);
                }
            }
            invocation.setTargetObject(this.singleton);
            invocation.setBeanContext(this.beanContext);
            return invocation;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void injectDependencies(BeanContext ctx) {
        if (!this.injected) {
            if (this.injectors != null) {
                try {
                    ThreadLocalENCFactory.push(this.enc);
                    for (int i = 0; i < this.injectors.length; ++i) {
                        this.injectors[i].inject(ctx);
                    }
                }
                finally {
                    ThreadLocalENCFactory.pop();
                }
            }
            this.injected = true;
        }
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        return this.delegate.getAttribute(attribute);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.delegate.setAttribute(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        return this.delegate.getAttributes(attributes);
    }

    public AttributeList setAttributes(AttributeList attributes) {
        return this.delegate.setAttributes(attributes);
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return this.delegate.invoke(actionName, params, signature);
    }

    public MBeanInfo getMBeanInfo() {
        return this.delegate.getMBeanInfo();
    }

    private void registerManagementInterface() {
        try {
            Management annotation = (Management)this.resolveAnnotation(Management.class);
            Class<?> intf = null;
            if (annotation != null) {
                intf = annotation.value();
            }
            if (intf == null) {
                Class<?>[] interfaces = this.getBeanClass().getInterfaces();
                int interfaceIndex = 0;
                while (intf == null && interfaceIndex < interfaces.length) {
                    if (interfaces[interfaceIndex].getAnnotation(Management.class) != null) {
                        intf = interfaces[interfaceIndex];
                        continue;
                    }
                    ++interfaceIndex;
                }
            }
            if (intf != null) {
                if (this.mbeanServer == null) {
                    throw new RuntimeException("There is a @Management interface on " + this.ejbName + " but the MBeanServer has not been initialized for it");
                }
                Service service = (Service)this.resolveAnnotation(Service.class);
                String objname = service.objectName();
                this.delegateObjectName = objname == null || objname.equals("") ? new ObjectName(this.getObjectName().getCanonicalName() + ",type=ManagementInterface") : new ObjectName(service.objectName());
                this.delegate = new ServiceMBeanDelegate(this.mbeanServer, this, intf, this.delegateObjectName);
                this.getDeployment().getKernelAbstraction().installMBean(this.delegateObjectName, this.getDependencyPolicy(), this.delegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Problem registering @Management interface for @Service " + this.getBeanClass(), e);
        }
    }
}

