/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.entity.InjectedEntityManager;
import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitInfoImpl;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitDeployment {
    private static final Logger log = Logger.getLogger(PersistenceUnitDeployment.class);
    protected InitialContext initialContext;
    protected DeploymentUnit di;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected ManagedEntityManagerFactory managedFactory;
    protected EntityManagerFactory actualFactory;
    protected URL persistenceXmlUrl;
    protected PersistenceMetadata xml;
    protected String kernelName;
    protected Ejb3Deployment deployment;
    protected boolean scoped;

    public PersistenceUnitDeployment(InitialContext initialContext, Ejb3Deployment deployment, List<String> explicitEntityClasses, URL persistenceXmlUrl, PersistenceMetadata metadata, String ear, String jar, boolean isScoped) {
        this.scoped = isScoped;
        this.deployment = deployment;
        this.initialContext = initialContext;
        this.di = deployment.getDeploymentUnit();
        this.explicitEntityClasses = explicitEntityClasses;
        this.persistenceXmlUrl = persistenceXmlUrl;
        this.xml = metadata;
        this.kernelName = "persistence.units:";
        String name = this.getEntityManagerName();
        if (name == null || name.equals("")) {
            throw new RuntimeException("Empty string is not allowed for a persistence unit.  Fix your persistence.xml file");
        }
        if (ear != null) {
            this.kernelName = this.kernelName + "ear=" + ear + ".ear,";
        }
        if (isScoped) {
            this.kernelName = this.kernelName + "jar=" + jar + ".jar,";
        }
        this.kernelName = this.kernelName + "unitName=" + name;
    }

    public static String getDefaultKernelName(String unitName) {
        int hashIndex = unitName.indexOf(35);
        if (hashIndex != -1) {
            String relativePath = unitName.substring(3, hashIndex);
            String name = unitName.substring(hashIndex + 1);
            return "persistence.units:jar=" + relativePath + "," + "unitName=" + name;
        }
        return "persistence.units:unitName=" + unitName;
    }

    public boolean isScoped() {
        return this.scoped;
    }

    public Ejb3Deployment getDeployment() {
        return this.deployment;
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    public EntityManagerFactory getActualFactory() {
        return this.actualFactory;
    }

    public PersistenceMetadata getXml() {
        return this.xml;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public String getEntityManagerName() {
        return this.xml.getName() == null ? "" : this.xml.getName();
    }

    public ManagedEntityManagerFactory getManagedFactory() {
        return this.managedFactory;
    }

    public void addDependencies(DependencyPolicy policy) {
        Properties props = this.getXml().getProps();
        if (!props.containsKey("jboss.no.implicit.datasource.dependency")) {
            String ds;
            if (this.getXml().getJtaDatasource() != null) {
                ds = this.getXml().getJtaDatasource();
                policy.addDatasource(ds);
            }
            if (this.getXml().getNonJtaDatasource() != null) {
                ds = this.getXml().getNonJtaDatasource();
                policy.addDatasource(ds);
            }
        }
        for (Object prop : props.keySet()) {
            String property = (String)prop;
            if (!property.startsWith("jboss.depends")) continue;
            policy.addDependency(props.getProperty(property));
        }
    }

    public void start() throws Exception {
        String entityManagerFactoryJndiName;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.di.getDefaultPersistenceProperties());
        props.put("hibernate.jacc.ctx.id", this.getJaccContextId());
        PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl();
        pi.setClassLoader(this.di.getClassLoader());
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        pi.setJarFiles(jarFiles);
        pi.setPersistenceProviderClassName(HibernatePersistence.class.getName());
        log.debug((Object)"Found persistence.xml file in EJB3 jar");
        props.putAll((Map<?, ?>)this.xml.getProps());
        pi.setManagedClassnames(this.xml.getClasses());
        pi.setPersistenceUnitName(this.xml.getName());
        pi.setMappingFileNames(this.xml.getMappingFiles());
        pi.setExcludeUnlistedClasses(this.xml.getExcludeUnlistedClasses());
        pi.setPersistenceUnitRootUrl(this.di.getUrl());
        PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.JTA;
        if ("RESOURCE_LOCAL".equals(this.xml.getTransactionType())) {
            transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        pi.setTransactionType(transactionType);
        for (String jar : this.xml.getJarFiles()) {
            URL url = null;
            try {
                url = new URL(jar);
            }
            catch (MalformedURLException e) {
                if (jar.startsWith("..")) {
                    if (this.di.getUrl() == null) {
                        throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
                    }
                    String base = this.di.getUrl().toString();
                    jar = jar.replaceAll("\\.\\./", "+");
                    int idx = jar.lastIndexOf(43);
                    jar = jar.substring(idx + 1);
                    for (int i = 0; i < idx + 1; ++i) {
                        int slash = base.lastIndexOf(47);
                        base = base.substring(0, slash + 1);
                    }
                    url = new URL(base + jar.substring(idx));
                }
                File fp = new File(jar);
                url = fp.toURL();
            }
            log.debug((Object)("adding JarFile URL: " + url.toString()));
            jarFiles.add(url);
        }
        if (this.xml.getProvider() != null) {
            pi.setPersistenceProviderClassName(this.xml.getProvider());
        }
        if (this.explicitEntityClasses.size() > 0) {
            List<String> classes = pi.getManagedClassNames();
            if (classes == null) {
                classes = this.explicitEntityClasses;
            } else {
                classes.addAll(this.explicitEntityClasses);
            }
            pi.setManagedClassnames(classes);
        }
        if (this.xml.getJtaDatasource() != null) {
            pi.setJtaDataSource((DataSource)this.initialContext.lookup(this.xml.getJtaDatasource()));
        } else if (transactionType == PersistenceUnitTransactionType.JTA) {
            throw new RuntimeException("You have not defined a jta-data-source for a JTA enabled persistence context named: " + this.xml.getName());
        }
        if (this.xml.getNonJtaDatasource() != null) {
            pi.setNonJtaDataSource((DataSource)this.initialContext.lookup(this.xml.getNonJtaDatasource()));
        } else if (transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            throw new RuntimeException("You have not defined a non-jta-data-source for a RESOURCE_LOCAL enabled persistence context named: " + this.xml.getName());
        }
        pi.setProperties(props);
        if (pi.getPersistenceUnitName() == null) {
            throw new RuntimeException("you must specify a name in persistence.xml");
        }
        Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(pi.getPersistenceProviderClassName());
        PersistenceProvider pp = (PersistenceProvider)providerClass.newInstance();
        this.actualFactory = pp.createContainerEntityManagerFactory((PersistenceUnitInfo)pi);
        this.managedFactory = new ManagedEntityManagerFactory(this.actualFactory, this.kernelName);
        String entityManagerJndiName = (String)props.get("jboss.entity.manager.jndi.name");
        if (entityManagerJndiName != null) {
            InjectedEntityManager injectedManager = new InjectedEntityManager(this.managedFactory);
            NonSerializableFactory.bind(this.initialContext, entityManagerJndiName, injectedManager);
        }
        if ((entityManagerFactoryJndiName = (String)props.get("jboss.entity.manager.factory.jndi.name")) != null) {
            InjectedEntityManagerFactory injectedFactory = new InjectedEntityManagerFactory(this.managedFactory);
            NonSerializableFactory.bind(this.initialContext, entityManagerFactoryJndiName, injectedFactory);
        }
    }

    public void stop() throws Exception {
        String entityManagerFactoryJndiName;
        String entityManagerJndiName = (String)this.xml.getProps().get("jboss.entity.manager.jndi.name");
        if (entityManagerJndiName != null) {
            NonSerializableFactory.unbind(this.initialContext, entityManagerJndiName);
        }
        if ((entityManagerFactoryJndiName = (String)this.xml.getProps().get("jboss.entity.manager.factory.jndi.name")) != null) {
            NonSerializableFactory.unbind(this.initialContext, entityManagerFactoryJndiName);
        }
        this.managedFactory.destroy();
    }
}

