/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ejb.Local;
import javax.ejb.LocalHome;
import javax.ejb.Remote;
import javax.ejb.RemoteHome;
import javax.ejb.SessionSynchronization;
import javax.ejb.TimedObject;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.aop.Advisor;
import org.jboss.ejb.LocalImpl;
import org.jboss.ejb.RemoteImpl;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EAR;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.SessionContainer;
import org.jboss.logging.Logger;

public class ProxyFactoryHelper {
    private static final Logger log = Logger.getLogger(ProxyFactoryHelper.class);

    public static Context getProxyFactoryContext(Context ctx) throws NamingException {
        try {
            return (Context)ctx.lookup("proxyFactory");
        }
        catch (NameNotFoundException e) {
            return ctx.createSubcontext("proxyFactory");
        }
    }

    public static Class[] getLocalInterfaces(Container container) {
        Class beanClass = container.getBeanClass();
        Local li = (Local)((EJBContainer)container).resolveAnnotation(Local.class);
        Class[] ri = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (li == null && ri == null && (beanClass.getInterfaces() == null || beanClass.getInterfaces().length == 0)) {
            throw new RuntimeException("bean class has no local or remote interfaces defined and does not implement at least one business interface");
        }
        if (li == null) {
            Class[] intfs = beanClass.getInterfaces();
            ArrayList locals = new ArrayList();
            for (Class<?> clazz : intfs) {
                if (!clazz.isAnnotationPresent(Local.class)) continue;
                locals.add(clazz);
            }
            if (locals.size() > 0) {
                intfs = locals.toArray(new Class[locals.size()]);
                li = new LocalImpl(intfs);
                ((Advisor)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
                return li.value();
            }
        }
        if (li == null) {
            if (ri == null) {
                ArrayList interfaces = new ArrayList(Arrays.asList(beanClass.getInterfaces()));
                interfaces.remove(Serializable.class);
                interfaces.remove(Externalizable.class);
                interfaces.remove(SessionSynchronization.class);
                interfaces.remove(TimedObject.class);
                if (interfaces.size() == 0) {
                    throw new RuntimeException("bean class has no local or remote interfaces defined and does not implement at least one business interface");
                }
                if (interfaces.size() > 1) {
                    throw new RuntimeException("deployer cannot determine default local interface as there are too many implemented interfaces and no @Remote or @Local defined for " + beanClass.getName());
                }
                Class[] rtn = new Class[]{interfaces.get(0)};
                li = new LocalImpl(rtn);
                ((EJBContainer)container).getAnnotations().addClassAnnotation(Local.class, (Object)li);
                return rtn;
            }
            return null;
        }
        return li.value();
    }

    public static Class getLocalHomeInterface(Container container) {
        Class beanClass = container.getBeanClass();
        LocalHome li = (LocalHome)((EJBContainer)container).resolveAnnotation(LocalHome.class);
        if (li != null) {
            return li.value();
        }
        return null;
    }

    public static Class getRemoteHomeInterface(Container container) {
        Class beanClass = container.getBeanClass();
        RemoteHome li = (RemoteHome)((EJBContainer)container).resolveAnnotation(RemoteHome.class);
        if (li != null) {
            return li.value();
        }
        return null;
    }

    public static String getJndiName(Container container, Class businessInterface) {
        Class localHome;
        Class remoteHome;
        if (!(container instanceof SessionContainer)) {
            return null;
        }
        Advisor advisor = (Advisor)container;
        Class[] remotes = ProxyFactoryHelper.getRemoteInterfaces(container);
        if (remotes != null) {
            for (Class clazz : remotes) {
                if (!clazz.getName().equals(businessInterface.getName())) continue;
                RemoteBindings bindings = (RemoteBindings)advisor.resolveAnnotation(RemoteBindings.class);
                if (bindings == null) {
                    RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
                    if (binding == null) {
                        throw new RuntimeException("RemoteBindings should not be null: " + container.getEjbName());
                    }
                    return ProxyFactoryHelper.getRemoteJndiName(container, binding);
                }
                return ProxyFactoryHelper.getRemoteJndiName(container, bindings.value()[0]);
            }
        }
        if ((remoteHome = ProxyFactoryHelper.getRemoteHomeInterface(container)) != null && businessInterface.getName().equals(remoteHome.getName())) {
            return ProxyFactoryHelper.getRemoteJndiName(container) + "Home";
        }
        Class[] locals = ProxyFactoryHelper.getLocalInterfaces(container);
        if (locals != null) {
            for (Class clazz : locals) {
                if (!clazz.getName().equals(businessInterface.getName())) continue;
                return ProxyFactoryHelper.getLocalJndiName(container);
            }
        }
        if ((localHome = ProxyFactoryHelper.getLocalHomeInterface(container)) != null && businessInterface.getName().equals(localHome.getName())) {
            return ProxyFactoryHelper.getLocalJndiName(container) + "Home";
        }
        return null;
    }

    public static String getLocalJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        LocalBinding localBinding = (LocalBinding)advisor.resolveAnnotation(LocalBinding.class);
        if (localBinding == null) {
            String name = container.getEjbName() + "/local";
            EAR ear = ((EJBContainer)container).getDeployment().getEar();
            if (ear != null) {
                return ear.getBaseName() + "/" + name;
            }
            return name;
        }
        return localBinding.jndiBinding();
    }

    public static Class[] getRemoteInterfaces(Container container) {
        Remote ri = (Remote)((Advisor)container).resolveAnnotation(Remote.class);
        if (ri == null) {
            Class beanClass = container.getBeanClass();
            Class[] intfs = beanClass.getInterfaces();
            ArrayList remotes = new ArrayList();
            for (Class<?> clazz : intfs) {
                if (!clazz.isAnnotationPresent(Remote.class)) continue;
                remotes.add(clazz);
            }
            if (remotes.size() > 0) {
                intfs = remotes.toArray(new Class[remotes.size()]);
                ri = new RemoteImpl(intfs);
                ((Advisor)container).getAnnotations().addClassAnnotation(Remote.class, (Object)ri);
                return ri.value();
            }
            return null;
        }
        return ri.value();
    }

    public static String getRemoteJndiName(Container container) {
        Advisor advisor = (Advisor)container;
        RemoteBinding binding = (RemoteBinding)advisor.resolveAnnotation(RemoteBinding.class);
        return ProxyFactoryHelper.getRemoteJndiName(container, binding);
    }

    public static String getRemoteJndiName(Container container, RemoteBinding binding) {
        String jndiName = null;
        jndiName = binding == null || binding.jndiBinding() == null || binding.jndiBinding().equals("") ? ProxyFactoryHelper.getDefaultRemoteJndiName(container) : binding.jndiBinding();
        return jndiName;
    }

    public static String getDefaultRemoteJndiName(Container container) {
        String name = container.getEjbName() + "/remote";
        EAR ear = ((EJBContainer)container).getDeployment().getEar();
        if (ear != null) {
            return ear.getBaseName() + "/" + name;
        }
        return name;
    }
}

