/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.AbstractMarshaller;
import org.jboss.xb.binding.AttributesImpl;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.Content;
import org.jboss.xb.binding.ContentWriter;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectLocalMarshaller;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.metadata.marshalling.FieldBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XercesXsMarshaller
extends AbstractMarshaller {
    private static final Logger log = Logger.getLogger((Class)XercesXsMarshaller.class);
    private AbstractMarshaller.Stack stack = new AbstractMarshaller.StackImpl();
    private GenericObjectModelProvider provider;
    private Content content = new Content();
    private final Map prefixByUri = new HashMap();
    private Object root;
    private boolean supportNil = true;
    private QName rootTypeQName;
    private SchemaBindingResolver schemaResolver;
    private XSModel model;
    private boolean ignoreUnresolvedWildcard;
    private XSAttributeUse currentAttribute;
    private XSTypeDefinition currentElementType;
    private String simpleContentProperty = "value";
    private Map field2WildcardMap = Collections.EMPTY_MAP;
    private MarshallingContext ctx = new MarshallingContext(){
        private ContentHandler ch;

        public FieldBinding getFieldBinding() {
            throw new UnsupportedOperationException("getFieldBinding is not implemented.");
        }

        public boolean isAttributeRequired() {
            if (XercesXsMarshaller.this.currentAttribute == null) {
                throw new JBossXBRuntimeException("There is no current attribute!");
            }
            return XercesXsMarshaller.this.currentAttribute.getRequired();
        }

        public boolean isTypeComplex() {
            if (XercesXsMarshaller.this.currentElementType == null) {
                throw new JBossXBRuntimeException("There is no current element!");
            }
            return XercesXsMarshaller.this.currentElementType.getTypeCategory() == 15;
        }

        public String getSimpleContentProperty() {
            return XercesXsMarshaller.this.simpleContentProperty;
        }

        public ContentHandler getContentHandler() {
            if (this.ch == null) {
                this.ch = new ContentHandlerAdaptor();
            }
            return this.ch;
        }
    };

    public void mapFieldToWildcard(Class cls, String field, ObjectLocalMarshaller marshaller) {
        FieldToWildcardMapping mapping = new FieldToWildcardMapping(cls, field, marshaller);
        switch (this.field2WildcardMap.size()) {
            case 0: {
                this.field2WildcardMap = Collections.singletonMap(cls, mapping);
                break;
            }
            case 1: {
                this.field2WildcardMap = new HashMap(this.field2WildcardMap);
            }
            default: {
                this.field2WildcardMap.put(cls, mapping);
            }
        }
    }

    public String getSimpleContentProperty() {
        return this.simpleContentProperty;
    }

    public void setSimpleContentProperty(String simpleContentProperty) {
        this.simpleContentProperty = simpleContentProperty;
    }

    public boolean isIgnoreUnresolvedWildcard() {
        return this.ignoreUnresolvedWildcard;
    }

    public void setIgnoreUnresolvedWildcard(boolean ignoreUnresolvedWildcard) {
        this.ignoreUnresolvedWildcard = ignoreUnresolvedWildcard;
    }

    public SchemaBindingResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void setSchemaResolver(SchemaBindingResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public QName getRootTypeQName() {
        return this.rootTypeQName;
    }

    public void setRootTypeQName(QName rootTypeQName) {
        this.rootTypeQName = rootTypeQName;
    }

    public boolean isSupportNil() {
        return this.supportNil;
    }

    public void setSupportNil(boolean supportNil) {
        this.supportNil = supportNil;
    }

    public void declareNamespace(String prefix, String uri) {
        if (prefix == null) {
            return;
        }
        this.prefixByUri.put(uri, prefix);
    }

    public void addAttribute(String prefix, String localName, String type, String value) {
    }

    public void marshal(Reader xsdReader, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException, ParserConfigurationException {
        XSModel model = Util.loadSchema(xsdReader, null, this.schemaResolver);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(String xsdURL, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        XSModel model = Util.loadSchema(xsdURL, this.schemaResolver);
        this.marshallInternal(provider, root, model, writer);
    }

    public void marshal(XSModel model, ObjectModelProvider provider, Object root, Writer writer) throws IOException, SAXException {
        this.marshallInternal(provider, root, model, writer);
    }

    private void marshallInternal(ObjectModelProvider provider, Object root, XSModel model, Writer writer) throws IOException, SAXException {
        if (model == null) {
            throw new JBossXBRuntimeException("XSModel is not available!");
        }
        this.model = model;
        this.provider = provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider);
        this.root = root;
        this.content.startDocument();
        if (this.rootTypeQName != null) {
            if (this.rootQNames.isEmpty()) {
                throw new JBossXBRuntimeException("If type name (" + this.rootTypeQName + ") for the root element is specified then the name for the root element is required!");
            }
            QName rootQName = (QName)this.rootQNames.get(0);
            XSTypeDefinition type = model.getTypeDefinition(this.rootTypeQName.getLocalPart(), this.rootTypeQName.getNamespaceURI());
            if (type == null) {
                throw new JBossXBRuntimeException("Global type definition is not found: " + this.rootTypeQName);
            }
            if (XercesXsMarshaller.isArrayWrapper(type)) {
                Object o = provider.getRoot(root, null, rootQName.getNamespaceURI(), rootQName.getLocalPart());
                this.stack.push(o);
                this.marshalComplexType(rootQName.getNamespaceURI(), rootQName.getLocalPart(), (XSComplexTypeDefinition)type, true);
                this.stack.pop();
            } else {
                Object o = provider.getRoot(root, null, rootQName.getNamespaceURI(), rootQName.getLocalPart());
                this.stack.push(o);
                this.marshalElement(rootQName.getNamespaceURI(), rootQName.getLocalPart(), type, false, true, true);
                this.stack.pop();
            }
        } else if (this.rootQNames.isEmpty()) {
            XSNamedMap components = model.getComponents((short)2);
            if (components.getLength() == 0) {
                throw new JBossXBRuntimeException("The schema doesn't contain global element declarations.");
            }
            for (int i = 0; i < components.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)components.item(i);
                Object o = provider.getRoot(root, null, element.getNamespace(), element.getName());
                this.stack.push(o);
                this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), true, true);
                this.stack.pop();
            }
        } else {
            for (int i = 0; i < this.rootQNames.size(); ++i) {
                QName qName = (QName)this.rootQNames.get(i);
                XSElementDeclaration element = model.getElementDeclaration(qName.getLocalPart(), qName.getNamespaceURI());
                if (element == null) {
                    XSNamedMap components = model.getComponents((short)2);
                    String roots = "";
                    for (int j = 0; j < components.getLength(); ++j) {
                        XSObject xsObject = components.item(j);
                        if (j > 0) {
                            roots = roots + ", ";
                        }
                        roots = roots + "{" + xsObject.getNamespace() + "}" + xsObject.getName();
                    }
                    throw new IllegalStateException("Root element not found: " + qName + " among " + roots);
                }
                Object o = provider.getRoot(root, null, element.getNamespace(), element.getName());
                this.stack.push(o);
                this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), element.getNillable(), true, true);
                this.stack.pop();
            }
        }
        this.content.endDocument();
        this.writeXmlVersion(writer);
        ContentWriter contentWriter = new ContentWriter(writer, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
        this.content.handleContent(contentWriter);
        if (log.isTraceEnabled()) {
            StringWriter traceWriter = new StringWriter();
            contentWriter = new ContentWriter(traceWriter, this.propertyIsTrueOrNotSet("org.jboss.xml.binding.marshalling.indent"));
            this.content.handleContent(contentWriter);
            log.trace((Object)("marshalled:\n" + traceWriter.getBuffer().toString()));
        }
    }

    private boolean marshalElement(String elementNs, String elementLocal, XSTypeDefinition type, boolean optional, boolean nillable, boolean declareNs) {
        boolean trace;
        Object value = this.stack.peek();
        boolean result = value != null || value == null && (optional || nillable);
        boolean bl = trace = log.isTraceEnabled() && result;
        if (trace) {
            String prefix = (String)this.prefixByUri.get(elementNs);
            log.trace((Object)("started element ns=" + elementNs + ", local=" + elementLocal + ", prefix=" + prefix));
        }
        if (value != null) {
            this.marshalElementType(elementNs, elementLocal, type, declareNs, nillable);
        } else if (nillable) {
            this.writeNillable(elementNs, elementLocal, nillable);
        }
        if (trace) {
            log.trace((Object)("finished element ns=" + elementNs + ", local=" + elementLocal));
        }
        return result;
    }

    private void marshalElementType(String elementNs, String elementLocal, XSTypeDefinition type, boolean declareNs, boolean nillable) {
        switch (type.getTypeCategory()) {
            case 16: {
                this.marshalSimpleType(elementNs, elementLocal, (XSSimpleTypeDefinition)type, declareNs, nillable);
                break;
            }
            case 15: {
                this.marshalComplexType(elementNs, elementLocal, (XSComplexTypeDefinition)type, declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type category: " + type.getTypeCategory());
            }
        }
    }

    private void marshalSimpleType(String elementUri, String elementLocal, XSSimpleTypeDefinition type, boolean declareNs, boolean nillable) {
        Object value = this.stack.peek();
        if (value != null) {
            boolean genPrefix;
            String prefix = (String)this.prefixByUri.get(elementUri);
            boolean bl = genPrefix = prefix == null && elementUri != null && elementUri.length() > 0;
            if (genPrefix) {
                prefix = "ns_" + elementLocal;
            }
            AttributesImpl attrs = null;
            String typeName = type.getName();
            if ("QName".equals(typeName) || "NOTATION".equals(typeName) || type.getItemType() != null && ("QName".equals(type.getItemType().getName()) || "NOTATION".equals(type.getItemType().getName()))) {
                attrs = new AttributesImpl(5);
            }
            String marshalled = this.marshalCharacters(elementUri, prefix, type, value, attrs);
            if (declareNs && !this.prefixByUri.isEmpty()) {
                if (attrs == null) {
                    attrs = new AttributesImpl(this.prefixByUri.size());
                }
                this.declareNs(attrs);
            }
            if (genPrefix) {
                if (attrs == null) {
                    attrs = new AttributesImpl(1);
                }
                attrs.add(null, prefix, "xmlns:" + prefix, null, elementUri);
            }
            String qName = XercesXsMarshaller.createQName(prefix, elementLocal);
            this.content.startElement(elementUri, elementLocal, qName, attrs);
            this.content.characters(marshalled.toCharArray(), 0, marshalled.length());
            this.content.endElement(elementUri, elementLocal, qName);
        } else {
            this.writeNillable(elementUri, elementLocal, nillable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshalComplexType(String elementNsUri, String elementLocalName, XSComplexTypeDefinition type, boolean declareNs) {
        Object value;
        String prefix;
        boolean genPrefix;
        AttributesImpl attrs;
        Object o = this.stack.peek();
        XSParticle particle = type.getParticle();
        XSObjectList attributeUses = type.getAttributeUses();
        int attrsTotal = declareNs ? this.prefixByUri.size() + attributeUses.getLength() : attributeUses.getLength();
        AttributesImpl attributesImpl = attrs = attrsTotal > 0 ? new AttributesImpl(attrsTotal) : null;
        if (declareNs && !this.prefixByUri.isEmpty()) {
            this.declareNs(attrs);
        }
        boolean bl = genPrefix = (prefix = (String)this.prefixByUri.get(elementNsUri)) == null && elementNsUri != null && elementNsUri.length() > 0;
        if (genPrefix) {
            prefix = "ns_" + elementLocalName;
            this.prefixByUri.put(elementNsUri, prefix);
            if (attrs == null) {
                attrs = new AttributesImpl(1);
            }
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNsUri);
        }
        for (int i = 0; i < attributeUses.getLength(); ++i) {
            String attrLocal;
            this.currentAttribute = (XSAttributeUse)attributeUses.item(i);
            XSAttributeDeclaration attrDec = this.currentAttribute.getAttrDeclaration();
            String attrNs = attrDec.getNamespace();
            Object attrValue = this.provider.getAttributeValue(o, this.ctx, attrNs, attrLocal = attrDec.getName());
            if (attrValue == null) continue;
            if (attrs == null) {
                attrs = new AttributesImpl(5);
            }
            String attrPrefix = null;
            if (attrNs != null && (attrPrefix = (String)this.prefixByUri.get(attrNs)) == null && attrNs != null && attrNs.length() > 0) {
                attrPrefix = "ns_" + attrLocal;
                attrs.add(null, attrPrefix, "xmlns:" + attrPrefix, null, attrNs);
            }
            String qName = attrPrefix == null || attrPrefix.length() == 0 ? attrLocal : attrPrefix + ":" + attrLocal;
            XSSimpleTypeDefinition attrType = attrDec.getTypeDefinition();
            if (attrType.getItemType() != null) {
                List<Object> list;
                XSSimpleTypeDefinition itemType = attrType.getItemType();
                if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getNamespace())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
                if (attrValue instanceof List) {
                    list = (List<Object>)attrValue;
                } else {
                    if (!attrValue.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + attrValue);
                    list = Arrays.asList((Object[])attrValue);
                }
                if (Constants.QNAME_QNAME.getLocalPart().equals(itemType.getName())) {
                    for (int listInd = 0; listInd < list.size(); ++listInd) {
                        String itemPrefix;
                        QName item = (QName)list.get(listInd);
                        String itemNs = item.getNamespaceURI();
                        if (itemNs == null || itemNs.length() <= 0) continue;
                        if (itemNs.equals(elementNsUri)) {
                            itemPrefix = prefix;
                        } else {
                            itemPrefix = (String)this.prefixByUri.get(itemNs);
                            if (itemPrefix == null) {
                                itemPrefix = attrLocal + listInd;
                                this.declareNs(attrs, itemPrefix, itemNs);
                            }
                        }
                        item = new QName(item.getNamespaceURI(), item.getLocalPart(), itemPrefix);
                        list.set(listInd, item);
                    }
                }
                attrValue = SimpleTypeBindings.marshalList(itemType.getName(), list, null);
            } else {
                String item;
                attrValue = attrType.getLexicalPattern().item(0) != null && attrType.derivedFrom("http://www.w3.org/2001/XMLSchema", Constants.QNAME_BOOLEAN.getLocalPart(), (short)2) ? ((item = attrType.getLexicalPattern().item(0)).indexOf(48) != -1 && item.indexOf(49) != -1 ? ((Boolean)attrValue != false ? "1" : "0") : ((Boolean)attrValue != false ? "true" : "false")) : attrValue.toString();
            }
            attrs.add(attrNs, attrLocal, qName, attrDec.getTypeDefinition().getName(), attrValue.toString());
        }
        this.currentAttribute = null;
        String characters = null;
        if (type.getSimpleType() != null && (value = this.getSimpleContentValue(elementNsUri, elementLocalName, (XSTypeDefinition)type)) != null) {
            XSSimpleTypeDefinition simpleType = type.getSimpleType();
            String typeName = simpleType.getName();
            if (attrs == null && ("QName".equals(typeName) || "NOTATION".equals(typeName) || simpleType.getItemType() != null && ("QName".equals(simpleType.getItemType().getName()) || "NOTATION".equals(simpleType.getItemType().getName())))) {
                attrs = new AttributesImpl(5);
            }
            characters = this.marshalCharacters(elementNsUri, prefix, simpleType, value, attrs);
        }
        String qName = XercesXsMarshaller.createQName(prefix, elementLocalName);
        this.content.startElement(elementNsUri, elementLocalName, qName, attrs);
        if (particle != null) {
            this.marshalParticle(particle, false);
        }
        if (characters != null) {
            this.content.characters(characters.toCharArray(), 0, characters.length());
        }
        this.content.endElement(elementNsUri, elementLocalName, qName);
        if (!genPrefix) return;
        this.prefixByUri.remove(elementNsUri);
    }

    private boolean marshalParticle(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSTerm term = particle.getTerm();
        switch (term.getType()) {
            case 7: {
                Iterator i;
                Object o = this.stack.peek();
                Iterator iterator = i = o != null && XercesXsMarshaller.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        this.stack.push(value);
                        marshalled = this.marshalModelGroup(particle, declareNs);
                        this.stack.pop();
                    }
                    break;
                }
                marshalled = this.marshalModelGroup(particle, declareNs);
                break;
            }
            case 9: {
                Iterator i;
                Object o = this.stack.peek();
                boolean popWildcardValue = false;
                ObjectLocalMarshaller marshaller = null;
                FieldToWildcardMapping mapping = (FieldToWildcardMapping)this.field2WildcardMap.get(o.getClass());
                if (mapping != null) {
                    marshaller = mapping.marshaller;
                    if (mapping.getter != null) {
                        try {
                            o = mapping.getter.invoke(o, null);
                        }
                        catch (Exception e) {
                            throw new JBossXBRuntimeException("Failed to invoke getter " + mapping.getter.getName() + " on " + o.getClass() + " to get wildcard value: " + e.getMessage());
                        }
                    }
                    try {
                        o = mapping.field.get(o);
                    }
                    catch (Exception e) {
                        throw new JBossXBRuntimeException("Failed to invoke get on field " + mapping.field.getName() + " in " + o.getClass() + " to get wildcard value: " + e.getMessage());
                    }
                    this.stack.push(o);
                    popWildcardValue = true;
                }
                Iterator iterator = i = o != null && XercesXsMarshaller.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        marshalled = this.marshalWildcardOccurence(particle, marshaller, value, declareNs);
                    }
                } else {
                    marshalled = this.marshalWildcardOccurence(particle, marshaller, o, declareNs);
                }
                if (!popWildcardValue) break;
                this.stack.pop();
                break;
            }
            case 2: {
                Iterator i;
                XSElementDeclaration element = (XSElementDeclaration)term;
                Object o = this.getElementValue(element.getNamespace(), element.getName(), element.getTypeDefinition());
                Iterator iterator = i = o != null && XercesXsMarshaller.isRepeatable(particle) ? this.getIterator(o) : null;
                if (i != null) {
                    marshalled = true;
                    while (i.hasNext() && marshalled) {
                        Object value = i.next();
                        this.stack.push(value);
                        marshalled = this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), particle.getMinOccurs() == 0, element.getNillable(), declareNs);
                        this.stack.pop();
                    }
                    break;
                }
                this.stack.push(o);
                marshalled = this.marshalElement(element.getNamespace(), element.getName(), element.getTypeDefinition(), particle.getMinOccurs() == 0, element.getNillable(), declareNs);
                this.stack.pop();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected term type: " + term.getType());
            }
        }
        return marshalled;
    }

    private boolean marshalWildcardOccurence(XSParticle particle, ObjectLocalMarshaller marshaller, Object value, boolean declareNs) {
        boolean marshalled = true;
        if (marshaller != null) {
            marshaller.marshal(this.ctx, value);
        } else {
            this.stack.push(value);
            marshalled = this.marshalWildcard(particle, declareNs);
            this.stack.pop();
        }
        return marshalled;
    }

    private boolean marshalWildcard(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSWildcard wildcard = (XSWildcard)particle.getTerm();
        Object o = this.stack.peek();
        AbstractMarshaller.ClassMapping mapping = this.getClassMapping(o.getClass());
        if (mapping == null) {
            QName autoType = SimpleTypeBindings.typeQName(o.getClass());
            if (autoType != null) {
                String marshalled2 = SimpleTypeBindings.marshal(autoType.getLocalPart(), o, null);
                this.content.characters(marshalled2.toCharArray(), 0, marshalled2.length());
                return true;
            }
            if (this.ignoreUnresolvedWildcard) {
                log.warn((Object)("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o));
                return true;
            }
            throw new IllegalStateException("Failed to marshal wildcard. Class mapping not found for " + o.getClass() + "@" + o.hashCode() + ": " + o);
        }
        GenericObjectModelProvider parentProvider = this.provider;
        Object parentRoot = this.root;
        AbstractMarshaller.Stack parentStack = this.stack;
        XSModel parentModel = this.model;
        this.root = o;
        this.stack = new AbstractMarshaller.StackImpl();
        XSModel xSModel = this.model = mapping.schemaUrl == null ? this.model : Util.loadSchema(mapping.schemaUrl, this.schemaResolver);
        if (mapping.provider != null) {
            this.provider = mapping.provider;
        }
        if (mapping.elementName != null) {
            XSElementDeclaration elDec = this.model.getElementDeclaration(mapping.elementName.getLocalPart(), mapping.elementName.getNamespaceURI());
            if (elDec == null) {
                throw new JBossXBRuntimeException("Element " + mapping.elementName + " is not declared in the schema.");
            }
            Object elementValue = this.provider.getRoot(this.root, null, elDec.getNamespace(), elDec.getName());
            this.stack.push(elementValue);
            marshalled = this.marshalElement(elDec.getNamespace(), elDec.getName(), elDec.getTypeDefinition(), particle.getMinOccurs() == 0, elDec.getNillable(), declareNs);
            this.stack.pop();
        } else if (mapping.typeName != null) {
            XSTypeDefinition typeDef = this.model.getTypeDefinition(mapping.typeName.getLocalPart(), mapping.typeName.getNamespaceURI());
            if (typeDef == null) {
                ArrayList<QName> typeNames = new ArrayList<QName>();
                XSNamedMap types = this.model.getComponents((short)3);
                for (int i = 0; i < types.getLength(); ++i) {
                    XSObject type = types.item(i);
                    if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) continue;
                    typeNames.add(new QName(type.getNamespace(), type.getName()));
                }
                throw new JBossXBRuntimeException("Type " + mapping.typeName + " is not defined in the schema." + " Defined types are: " + typeNames);
            }
            Object elementValue = this.provider.getRoot(this.root, null, wildcard.getNamespace(), wildcard.getName());
            this.stack.push(elementValue);
            marshalled = this.marshalElement(wildcard.getNamespace(), wildcard.getName(), typeDef, particle.getMinOccurs() == 0, false, declareNs);
            this.stack.pop();
        } else {
            throw new JBossXBRuntimeException("Class mapping for " + mapping.cls + " is associated with neither global element name nor global type name.");
        }
        this.root = parentRoot;
        this.provider = parentProvider;
        this.stack = parentStack;
        this.model = parentModel;
        return marshalled;
    }

    private boolean marshalModelGroup(XSParticle particle, boolean declareNs) {
        boolean marshalled;
        XSModelGroup modelGroup = (XSModelGroup)particle.getTerm();
        switch (modelGroup.getCompositor()) {
            case 3: {
                marshalled = this.marshalModelGroupAll(modelGroup.getParticles(), declareNs);
                break;
            }
            case 2: {
                marshalled = this.marshalModelGroupChoice(modelGroup.getParticles(), declareNs);
                break;
            }
            case 1: {
                marshalled = this.marshalModelGroupSequence(modelGroup.getParticles(), declareNs);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected compsitor: " + modelGroup.getCompositor());
            }
        }
        return marshalled;
    }

    private boolean marshalModelGroupAll(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled |= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    private boolean marshalModelGroupChoice(XSObjectList particles, boolean declareNs) {
        boolean marshalled = false;
        Content mainContent = this.content;
        for (int i = 0; i < particles.getLength() && !marshalled; ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            this.content = new Content();
            marshalled = this.marshalParticle(particle, declareNs);
        }
        if (marshalled) {
            mainContent.append(this.content);
        }
        this.content = mainContent;
        return marshalled;
    }

    private boolean marshalModelGroupSequence(XSObjectList particles, boolean declareNs) {
        boolean marshalled = true;
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            marshalled &= this.marshalParticle(particle, declareNs);
        }
        return marshalled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String marshalCharacters(String elementUri, String elementPrefix, XSSimpleTypeDefinition type, Object value, AttributesImpl attrs) {
        Method getValue;
        if (type.getItemType() != null) {
            List list;
            XSSimpleTypeDefinition itemType = type.getItemType();
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemType.getNamespace())) throw new JBossXBRuntimeException("Marshalling of list types with item types not from http://www.w3.org/2001/XMLSchema is not supported.");
            if (value instanceof List) {
                list = (List)value;
                return SimpleTypeBindings.marshalList(itemType.getName(), list, null);
            } else {
                if (!value.getClass().isArray()) throw new JBossXBRuntimeException("Expected value for list type is an array or " + List.class.getName() + " but got: " + value);
                list = XercesXsMarshaller.asList(value);
            }
            return SimpleTypeBindings.marshalList(itemType.getName(), list, null);
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespace())) {
            String typeName = type.getName();
            if (!"QName".equals(typeName)) {
                if (!"NOTATION".equals(typeName)) return SimpleTypeBindings.marshal(typeName, value, null);
            }
            QName qName = (QName)value;
            String prefixValue = qName.getPrefix();
            if ((elementUri != null && !qName.getNamespaceURI().equals(elementUri) || elementUri == null && qName.getNamespaceURI().length() > 0) && (prefixValue.equals(elementPrefix) || prefixValue.length() == 0 && elementPrefix == null)) {
                prefixValue = prefixValue + 'x';
                qName = new QName(qName.getNamespaceURI(), qName.getLocalPart(), prefixValue);
            }
            this.declareNs(attrs, prefixValue, qName.getNamespaceURI());
            value = qName;
            return SimpleTypeBindings.marshal(typeName, value, null);
        }
        if (type.getLexicalPattern().item(0) != null && type.derivedFrom("http://www.w3.org/2001/XMLSchema", Constants.QNAME_BOOLEAN.getLocalPart(), (short)2)) {
            String item = type.getLexicalPattern().item(0);
            if (item.indexOf(48) != -1 && item.indexOf(49) != -1) {
                if ((Boolean)value == false) return "0";
                return "1";
            }
            if ((Boolean)value == false) return "false";
            return "true";
        }
        StringList lexicalEnumeration = type.getLexicalEnumeration();
        if (lexicalEnumeration == null) return this.marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
        if (lexicalEnumeration.getLength() <= 0) return this.marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
        try {
            getValue = value.getClass().getMethod("value", null);
        }
        catch (NoSuchMethodException e) {
            try {
                getValue = value.getClass().getMethod("getValue", null);
            }
            catch (NoSuchMethodException e1) {
                ArrayList<String> values = new ArrayList<String>(lexicalEnumeration.getLength());
                int i = 0;
                while (i < lexicalEnumeration.getLength()) {
                    values.add(lexicalEnumeration.item(i));
                    ++i;
                }
                throw new JBossXBRuntimeException("Failed to find neither value() nor getValue() in " + value.getClass() + " which is bound to enumeration type (" + type.getNamespace() + ", " + type.getName() + "): " + values);
            }
        }
        try {
            value = getValue.invoke(value, null);
            return this.marshalCharacters(elementUri, elementPrefix, (XSSimpleTypeDefinition)type.getBaseType(), value, attrs);
        }
        catch (Exception e) {
            throw new JBossXBRuntimeException("Failed to invoke getValue() on " + value + " to get the enumeration value", e);
        }
    }

    private void declareNs(AttributesImpl attrs, String prefix, String ns) {
        String prefixStr;
        String string = prefixStr = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
        if (attrs != null) {
            attrs.add(null, prefix, prefixStr, null, ns);
        } else {
            log.warn((Object)("Cannot add namespace declaration: " + prefixStr + "='" + ns + "'"));
        }
    }

    private Object getElementValue(String elementNs, String elementLocal, XSTypeDefinition type) {
        Object value;
        Object peeked;
        Object object = peeked = this.stack.isEmpty() ? this.root : this.stack.peek();
        if (peeked == null) {
            value = null;
        } else if (peeked instanceof Collection || peeked.getClass().isArray()) {
            value = peeked;
        } else {
            XSTypeDefinition parentType = this.currentElementType;
            this.currentElementType = type;
            value = this.provider.getChildren(peeked, this.ctx, elementNs, elementLocal);
            if (value == null) {
                value = this.provider.getElementValue(peeked, this.ctx, elementNs, elementLocal);
            }
            this.currentElementType = parentType;
        }
        return value;
    }

    private Object getSimpleContentValue(String elementNs, String elementLocal, XSTypeDefinition type) {
        Object value;
        Object peeked;
        Object object = peeked = this.stack.isEmpty() ? this.root : this.stack.peek();
        if (peeked == null) {
            value = null;
        } else {
            XSTypeDefinition parentType = this.currentElementType;
            this.currentElementType = type;
            value = this.provider.getElementValue(peeked, this.ctx, elementNs, elementLocal);
            this.currentElementType = parentType;
        }
        return value;
    }

    private void writeNillable(String elementNs, String elementLocal, boolean nillable) {
        AttributesImpl attrs;
        if (!this.supportNil) {
            return;
        }
        if (!nillable) {
            throw new JBossXBRuntimeException("Failed to marshal " + new QName(elementNs, elementLocal) + ": Java value is null but the element is not nillable.");
        }
        String prefix = (String)this.prefixByUri.get(elementNs);
        if (prefix == null && elementNs != null && elementNs.length() > 0) {
            prefix = "ns_" + elementLocal;
            attrs = new AttributesImpl(2);
            attrs.add(null, prefix, "xmlns:" + prefix, null, elementNs);
        } else {
            attrs = new AttributesImpl(1);
        }
        String xsiPrefix = (String)this.prefixByUri.get("http://www.w3.org/2001/XMLSchema-instance");
        if (xsiPrefix == null) {
            xsiPrefix = "xsi";
            attrs.add(null, xsiPrefix, "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
        }
        String nilQName = xsiPrefix + ":nil";
        attrs.add("http://www.w3.org/2001/XMLSchema-instance", "nil", nilQName, null, "1");
        String qName = XercesXsMarshaller.createQName(prefix, elementLocal);
        this.content.startElement(elementNs, elementLocal, qName, attrs);
        this.content.endElement(elementNs, elementLocal, qName);
    }

    private void declareNs(AttributesImpl attrs) {
        Iterator i = this.prefixByUri.entrySet().iterator();
        while (i.hasNext()) {
            String localName;
            Map.Entry entry = i.next();
            attrs.add(null, localName, (localName = (String)entry.getValue()) == null || localName.length() == 0 ? "xmlns" : "xmlns:" + localName, null, (String)entry.getKey());
        }
    }

    private static String createQName(String prefix, String local) {
        return prefix == null || prefix.length() == 0 ? local : prefix + ':' + local;
    }

    private static boolean isArrayWrapper(XSTypeDefinition type) {
        XSComplexTypeDefinition cType;
        XSParticle particle;
        boolean is = false;
        if (15 == type.getTypeCategory() && (particle = (cType = (XSComplexTypeDefinition)type).getParticle()) != null) {
            is = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
        }
        return is;
    }

    private Iterator getIterator(Object value) {
        Iterator i = null;
        if (value instanceof Collection) {
            i = ((Collection)value).iterator();
        } else if (value.getClass().isArray()) {
            final Object arr = value;
            i = new Iterator(){
                private int curInd = 0;
                private int length = Array.getLength(arr);

                public boolean hasNext() {
                    return this.curInd < this.length;
                }

                public Object next() {
                    return Array.get(arr, this.curInd++);
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove is not implemented.");
                }
            };
        } else if (value instanceof Iterator) {
            i = (Iterator)value;
        }
        return i;
    }

    private static boolean isRepeatable(XSParticle particle) {
        return particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1 || particle.getMinOccurs() > 1;
    }

    private static final List asList(final Object arr) {
        return new AbstractList(){
            private final Object array;
            {
                this.array = arr;
            }

            public Object get(int index) {
                return Array.get(this.array, index);
            }

            public int size() {
                return Array.getLength(this.array);
            }
        };
    }

    private class ContentHandlerAdaptor
    implements ContentHandler {
        private ContentHandlerAdaptor() {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            XercesXsMarshaller.this.content.startPrefixMapping(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            XercesXsMarshaller.this.content.endPrefixMapping(prefix);
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            XercesXsMarshaller.this.content.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            XercesXsMarshaller.this.content.endElement(uri, localName, qName);
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            XercesXsMarshaller.this.content.characters(ch, start, length);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void skippedEntity(String name) throws SAXException {
        }
    }

    private class FieldToWildcardMapping {
        public final Class cls;
        public final String fieldName;
        public final ObjectLocalMarshaller marshaller;
        public final Method getter;
        public final Field field;

        public FieldToWildcardMapping(Class cls, String field, ObjectLocalMarshaller marshaller) {
            this.cls = cls;
            this.fieldName = field;
            this.marshaller = marshaller;
            if (log.isTraceEnabled()) {
                log.trace((Object)("new FieldToWildcardMapping: [cls=" + cls.getName() + ",field=" + field + "]"));
            }
            Method localGetter = null;
            Field localField = null;
            try {
                localGetter = Classes.getAttributeGetter((Class)cls, (String)field);
            }
            catch (NoSuchMethodException e) {
                try {
                    localField = cls.getField(field);
                }
                catch (NoSuchFieldException e1) {
                    throw new JBossXBRuntimeException("Neither getter nor field where found for " + field + " in " + cls);
                }
            }
            this.getter = localGetter;
            this.field = localField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldToWildcardMapping)) {
                return false;
            }
            FieldToWildcardMapping fieldToWildcardMapping = (FieldToWildcardMapping)o;
            if (!this.cls.equals(fieldToWildcardMapping.cls)) {
                return false;
            }
            return this.fieldName.equals(fieldToWildcardMapping.fieldName);
        }

        public int hashCode() {
            int result = this.cls.hashCode();
            result = 29 * result + this.fieldName.hashCode();
            return result;
        }
    }
}

