/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ejb;

import java.io.Serializable;
import javax.ejb.AroundInvoke;
import javax.ejb.InvocationContext;
import org.jboss.logging.Logger;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.interceptors.SeamInvocationContext;

public class SeamInterceptor
implements Serializable {
    private static final Logger log = Logger.getLogger(SeamInterceptor.class);

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Component component = this.getSeamComponent(invocation.getBean());
        if (this.isProcessInterceptors(component)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("intercepted: " + invocation.getMethod().getName()));
            }
            return new SeamInvocationContext(invocation, component).proceed();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("not intercepted: " + invocation.getMethod().getName()));
        }
        return invocation.proceed();
    }

    private boolean isProcessInterceptors(Component component) {
        return component != null && component.getInterceptionType().isActive();
    }

    private Component getSeamComponent(Object bean) {
        String componentName = Seam.getComponentName(bean.getClass());
        return Component.forName(componentName);
    }
}

