/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Locale;
import java.util.MissingResourceException;
import org.jboss.logging.Logger;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="resourceBundle")
@Startup
public class ResourceBundle {
    private static final Logger log = Logger.getLogger(ResourceBundle.class);
    private String bundleName = "messages";
    private String language;
    private java.util.ResourceBundle bundle;

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    @Create
    public void loadBundle() {
        try {
            this.bundle = this.language == null ? java.util.ResourceBundle.getBundle(this.bundleName, Locale.getDefault(), Thread.currentThread().getContextClassLoader()) : java.util.ResourceBundle.getBundle(this.bundleName, new Locale(this.language), Thread.currentThread().getContextClassLoader());
            log.info((Object)("loaded resource bundle: " + this.bundleName));
        }
        catch (MissingResourceException mre) {
            log.info((Object)("resource bundle missing: " + this.bundleName));
        }
    }

    @Unwrap
    public java.util.ResourceBundle getBundle() {
        return this.bundle;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public static java.util.ResourceBundle instance() {
        return (java.util.ResourceBundle)Component.getInstance(Seam.getComponentName(ResourceBundle.class), true);
    }
}

