/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.FacesContext;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.logging.Logger;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.pages")
public class Pages {
    private static final Logger log = Logger.getLogger(Pages.class);
    private Map<String, String> descriptionByViewId = new HashMap<String, String>();
    private Map<String, Integer> timeoutsByViewId = new HashMap<String, Integer>();

    @Create
    public void initialize() throws DocumentException {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/pages.xml");
        if (stream == null) {
            log.info((Object)"no pages.xml file found");
        } else {
            log.info((Object)"reading pages.xml");
            SAXReader saxReader = new SAXReader();
            saxReader.setMergeAdjacentText(true);
            Document doc = saxReader.read(stream);
            List elements = doc.getRootElement().elements("page");
            for (Element page : elements) {
                String viewId = page.attributeValue("view-id");
                this.descriptionByViewId.put(viewId, page.getTextTrim());
                String timeoutString = page.attributeValue("timeout");
                if (timeoutString == null) continue;
                this.timeoutsByViewId.put(viewId, Integer.parseInt(timeoutString));
            }
        }
    }

    public boolean hasDescription(String viewId) {
        return this.descriptionByViewId.containsKey(viewId);
    }

    public String getDescription(String viewId) {
        FacesContext context = FacesContext.getCurrentInstance();
        String description = this.descriptionByViewId.get(viewId);
        StringTokenizer tokens = new StringTokenizer(description, "#{}", true);
        StringBuilder builder = new StringBuilder(description.length());
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if ("#".equals(tok)) {
                tokens.nextToken();
                String expression = "#{" + tokens.nextToken() + "}";
                tokens.nextToken();
                try {
                    Object value = context.getApplication().createValueBinding(expression).getValue(context);
                    if (value == null) continue;
                    builder.append(value);
                }
                catch (Exception e) {
                    log.warn((Object)("exception evaluating description: " + description), (Throwable)e);
                }
                continue;
            }
            builder.append(tok);
        }
        return builder.toString();
    }

    public Integer getTimeout(String viewId) {
        return this.timeoutsByViewId.get(viewId);
    }

    public static Pages instance() {
        return (Pages)Component.getInstance(Pages.class, ScopeType.APPLICATION, true);
    }
}

