/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="conversation")
@Intercept(value=InterceptionType.NEVER)
public class Conversation
implements Serializable {
    private Integer timeout;
    String description;
    String viewId;

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getId() {
        return Manager.instance().getCurrentConversationId();
    }

    public String getDescription() {
        return this.description == null ? Manager.instance().getCurrentConversationDescription() : this.description;
    }

    public String getViewId() {
        return this.viewId == null ? Manager.instance().getCurrentConversationViewId() : this.viewId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setViewId(String outcome) {
        this.viewId = outcome;
    }

    public static Conversation instance() {
        if (!Contexts.isConversationContextActive()) {
            throw new IllegalStateException("No active conversation context");
        }
        return (Conversation)Component.getInstance(Conversation.class, ScopeType.CONVERSATION, true);
    }

    void flush() {
        if (this.description != null || this.viewId != null) {
            Manager manager = Manager.instance();
            if (!manager.isLongRunningConversation()) {
                throw new IllegalStateException("only long-running conversation outcomes are switchable");
            }
            if (this.description != null) {
                manager.setCurrentConversationDescription(this.description);
            }
            if (this.viewId != null) {
                manager.setCurrentConversationViewId(this.viewId);
            }
            if (this.timeout != null) {
                manager.setCurrentConversationTimeout(this.timeout);
            }
            this.description = null;
            this.viewId = null;
        }
    }

    public String redirect() {
        Manager manager = Manager.instance();
        String viewId = manager.getCurrentConversationViewId();
        if (viewId != null) {
            manager.redirect(viewId);
            return "org.jboss.seam.switch";
        }
        return null;
    }

    public void leave() {
        Manager.instance().leaveConversation();
    }
}

