/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;

public class WebRequestContext
implements Context {
    private ServletRequest request;

    public ScopeType getType() {
        return ScopeType.EVENT;
    }

    WebRequestContext(ServletRequest request) {
        this.request = request;
    }

    private String getKey(String name) {
        return this.getPrefix() + name;
    }

    private String getPrefix() {
        return ScopeType.EVENT.getPrefix() + '$';
    }

    public Object get(String name) {
        return this.request.getAttribute(this.getKey(name));
    }

    public void set(String name, Object value) {
        this.request.setAttribute(this.getKey(name), value);
    }

    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    public void remove(String name) {
        this.request.removeAttribute(this.getKey(name));
    }

    public String[] getNames() {
        Enumeration names = this.request.getAttributeNames();
        ArrayList<String> results = new ArrayList<String>();
        String prefix = this.getPrefix();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith(prefix)) continue;
            results.add(name.substring(prefix.length()));
        }
        return results.toArray(new String[0]);
    }

    public Object get(Class clazz) {
        return this.get(Seam.getComponentName(clazz));
    }

    public void flush() {
    }
}

