/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.BusinessProcessContext;
import org.jboss.seam.contexts.ClientConversationContext;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.EventContext;
import org.jboss.seam.contexts.FacesApplicationContext;
import org.jboss.seam.contexts.PageContext;
import org.jboss.seam.contexts.ServerConversationContext;
import org.jboss.seam.contexts.Session;
import org.jboss.seam.contexts.WebApplicationContext;
import org.jboss.seam.contexts.WebSessionContext;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;

public class Lifecycle {
    private static final Logger log = Logger.getLogger(Lifecycle.class);
    private static ThreadLocal<PhaseId> phaseId = new ThreadLocal();
    private static ThreadLocal<ServletRequest> servletRequest = new ThreadLocal();
    private static ThreadLocal<Boolean> destroying = new ThreadLocal();
    private static ThreadLocal<Boolean> exception = new ThreadLocal();

    public static void beginRequest(ExternalContext externalContext) {
        log.debug((Object)">>> Begin web request");
        Contexts.eventContext.set(new EventContext());
        Contexts.sessionContext.set(new WebSessionContext(Session.getSession(externalContext, true)));
        Contexts.applicationContext.set(new FacesApplicationContext(externalContext));
        Contexts.conversationContext.set(null);
    }

    public static void beginRequest(ServletContext servletContext, HttpSession session) {
        log.debug((Object)">>> Begin web request");
        Contexts.eventContext.set(new EventContext());
        Contexts.sessionContext.set(new WebSessionContext(Session.getSession(session)));
        Contexts.applicationContext.set(new WebApplicationContext(servletContext));
        Contexts.conversationContext.set(null);
    }

    public static void beginInitialization(ServletContext servletContext) {
        WebApplicationContext context = new WebApplicationContext(servletContext);
        Contexts.applicationContext.set(context);
    }

    public static void endInitialization() {
        Context context = Contexts.getApplicationContext();
        for (String name : context.getNames()) {
            Component component;
            Object object = context.get(name);
            if (!(object instanceof Component) || !(component = (Component)object).isStartup()) continue;
            Lifecycle.startup(component);
        }
        Contexts.applicationContext.set(null);
    }

    private static void startup(Component component) {
        if (component.isStartup()) {
            for (String dependency : component.getDependencies()) {
                Component dependentComponent = Component.forName(dependency);
                if (dependentComponent == null) continue;
                Lifecycle.startup(dependentComponent);
            }
        }
        Component.getInstance(component.getName(), true);
    }

    public static void endApplication(ServletContext servletContext) {
        log.debug((Object)"Undeploying, destroying application context");
        WebApplicationContext tempApplicationContext = new WebApplicationContext(servletContext);
        Contexts.applicationContext.set(tempApplicationContext);
        Contexts.destroy(tempApplicationContext);
        Contexts.applicationContext.set(null);
        Contexts.eventContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.conversationContext.set(null);
    }

    public static void endSession(ServletContext servletContext, Session session) {
        log.debug((Object)"End of session, destroying contexts");
        WebApplicationContext tempAppContext = new WebApplicationContext(servletContext);
        Contexts.applicationContext.set(tempAppContext);
        EventContext tempEventContext = new EventContext();
        Contexts.eventContext.set(tempEventContext);
        WebSessionContext tempSessionContext = new WebSessionContext(session);
        Contexts.sessionContext.set(tempSessionContext);
        Set<String> conversationIds = Manager.instance().getSessionConversationIds();
        log.debug((Object)("destroying conversation contexts: " + conversationIds));
        for (String conversationId : conversationIds) {
            Contexts.destroy(new ServerConversationContext(session, conversationId));
        }
        log.debug((Object)"destroying session context");
        Contexts.destroy(tempSessionContext);
        Contexts.sessionContext.set(null);
        Contexts.destroy(tempEventContext);
        Contexts.eventContext.set(null);
        Contexts.conversationContext.set(null);
        Contexts.applicationContext.set(null);
    }

    public static void flushClientConversation() {
        if (Contexts.isConversationContextActive() && !Seam.isSessionInvalid() && Init.instance().isClientSideConversations()) {
            log.debug((Object)"flushing client-side conversation context");
            Contexts.getConversationContext().flush();
        }
    }

    public static void flushPage() {
        if (Contexts.isPageContextActive()) {
            Contexts.getPageContext().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(ExternalContext externalContext) {
        log.debug((Object)"After render response, destroying contexts");
        try {
            Lifecycle.flushAndDestroyContexts();
            if (Seam.isSessionInvalid()) {
                Session.getSession(externalContext, true).invalidate();
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
        }
        log.debug((Object)"<<< End web request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest() {
        log.debug((Object)"After request, destroying contexts");
        try {
            Lifecycle.flushAndDestroyContexts();
        }
        finally {
            Lifecycle.clearThreadlocals();
        }
        log.debug((Object)"<<< End web request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endRequest(HttpSession session) {
        log.debug((Object)"After request, destroying contexts");
        try {
            Lifecycle.flushAndDestroyContexts();
            if (Seam.isSessionInvalid()) {
                Session.getSession(session).invalidate();
            }
        }
        finally {
            Lifecycle.clearThreadlocals();
        }
        log.debug((Object)"<<< End web request");
    }

    private static void clearThreadlocals() {
        Contexts.eventContext.set(null);
        Contexts.pageContext.set(null);
        Contexts.sessionContext.set(null);
        Contexts.conversationContext.set(null);
        Contexts.businessProcessContext.set(null);
        Contexts.applicationContext.set(null);
    }

    private static void flushAndDestroyContexts() {
        if (Contexts.isBusinessProcessContextActive()) {
            log.debug((Object)"flushing business process context");
            Contexts.getBusinessProcessContext().flush();
        }
        if (Contexts.isEventContextActive()) {
            log.debug((Object)"destroying event context");
            Contexts.destroy(Contexts.getEventContext());
        }
        if (Contexts.isConversationContextActive()) {
            if (!Manager.instance().isLongRunningConversation()) {
                log.debug((Object)"destroying conversation context");
                Contexts.destroy(Contexts.getConversationContext());
            }
            if (!Seam.isSessionInvalid() && !Init.instance().isClientSideConversations()) {
                log.debug((Object)"flushing server-side conversation context");
                Contexts.getConversationContext().flush();
            }
        }
    }

    public static void resumePage() {
        Contexts.pageContext.set(new PageContext());
    }

    public static void resumeConversation(ExternalContext externalContext) {
        Init init = (Init)Component.getInstance(Init.class, false);
        Context conversationContext = init.isClientSideConversations() ? new ClientConversationContext() : new ServerConversationContext(Session.getSession(externalContext, true));
        Contexts.conversationContext.set(conversationContext);
        Contexts.businessProcessContext.set(new BusinessProcessContext());
    }

    public static void resumeConversation(HttpSession session) {
        ServerConversationContext conversationContext = new ServerConversationContext(Session.getSession(session));
        Contexts.conversationContext.set(conversationContext);
    }

    public static PhaseId getPhaseId() {
        return phaseId.get();
    }

    public static void setPhaseId(PhaseId phase) {
        phaseId.set(phase);
    }

    public static ServletRequest getServletRequest() {
        return servletRequest.get();
    }

    public static void setServletRequest(ServletRequest servletRequest) {
        Lifecycle.servletRequest.set(servletRequest);
    }

    public static void startDestroying() {
        destroying.set(true);
    }

    public static void stopDestroying() {
        destroying.set(false);
    }

    public static boolean isDestroying() {
        Boolean value = destroying.get();
        return value != null && value != false;
    }

    public static boolean isException() {
        Boolean value = exception.get();
        return value != null && value != false;
    }

    public static void setException(boolean ex) {
        exception.set(ex);
    }
}

