/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import javax.ejb.Stateful;
import javax.ejb.Stateless;
import javax.persistence.Entity;
import org.jboss.seam.ComponentType;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Role;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seam {
    private static final String SESSION_INVALID = "org.jboss.seam.sessionInvalid";

    public static ScopeType getComponentScope(Class<?> clazz) {
        return clazz.isAnnotationPresent(Scope.class) ? clazz.getAnnotation(Scope.class).value() : Seam.getComponentType(clazz).getDefaultScope();
    }

    public static ScopeType getComponentRoleScope(Class clazz, Role role) {
        return role.scope() == null ? Seam.getComponentType(clazz).getDefaultScope() : role.scope();
    }

    public static ComponentType getComponentType(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Stateful.class)) {
            return ComponentType.STATEFUL_SESSION_BEAN;
        }
        if (clazz.isAnnotationPresent(Stateless.class)) {
            return ComponentType.STATELESS_SESSION_BEAN;
        }
        if (clazz.isAnnotationPresent(Entity.class)) {
            return ComponentType.ENTITY_BEAN;
        }
        return ComponentType.JAVA_BEAN;
    }

    public static String getComponentName(Class<?> clazz) {
        Name name = clazz.getAnnotation(Name.class);
        return name == null ? null : name.value();
    }

    public static String getEjbName(Class<?> clazz) {
        switch (Seam.getComponentType(clazz)) {
            case ENTITY_BEAN: 
            case JAVA_BEAN: {
                return null;
            }
            case STATEFUL_SESSION_BEAN: {
                Stateful stateful = clazz.getAnnotation(Stateful.class);
                return stateful.name().equals("") ? Seam.unqualifyClassName(clazz) : stateful.name();
            }
            case STATELESS_SESSION_BEAN: {
                Stateless stateless = clazz.getAnnotation(Stateless.class);
                return stateless.name().equals("") ? Seam.unqualifyClassName(clazz) : stateless.name();
            }
        }
        throw new IllegalArgumentException();
    }

    private static String unqualifyClassName(Class<?> clazz) {
        return Strings.unqualify(Strings.unqualify(clazz.getName()), '$');
    }

    public static InterceptionType getInterceptionType(Class<?> clazz) {
        if (Seam.getComponentType(clazz) == ComponentType.ENTITY_BEAN) {
            return InterceptionType.NEVER;
        }
        if (clazz.isAnnotationPresent(Intercept.class)) {
            return clazz.getAnnotation(Intercept.class).value();
        }
        return InterceptionType.AFTER_RESTORE_VIEW;
    }

    public static void invalidateSession() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Contexts.getSessionContext().set(SESSION_INVALID, true);
    }

    public static boolean isSessionInvalid() {
        if (!Contexts.isSessionContextActive()) {
            throw new IllegalStateException("No active session context");
        }
        Boolean isSessionInvalid = (Boolean)Contexts.getSessionContext().get(SESSION_INVALID);
        return isSessionInvalid != null && isSessionInvalid != false;
    }
}

