/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.serialization.SerializationStreamFactory;
import org.jboss.remoting.transport.socket.NewClientSocketWrapper;

public class NewServerSocketWrapper
extends NewClientSocketWrapper {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$socket$ServerSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ServerSocketWrapper = NewServerSocketWrapper.class$("org.jboss.remoting.transport.socket.ServerSocketWrapper")) : class$org$jboss$remoting$transport$socket$ServerSocketWrapper));
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerSocketWrapper;

    public NewServerSocketWrapper(Socket socket) throws Exception {
        super(socket);
    }

    public NewServerSocketWrapper(Socket socket, Map metadata) throws Exception {
        super(socket, metadata);
    }

    protected InputStream createInputStream(String serializationType, Socket socket) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(socket.getInputStream());
        return SerializationStreamFactory.getManagerInstance(serializationType).createRegularInput(bin);
    }

    protected OutputStream createOutputStream(String serializationType, Socket socket) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream());
        return SerializationStreamFactory.getManagerInstance(serializationType).createOutput(bout);
    }

    public void checkConnection() throws IOException {
        byte ACK = 0;
        long startWait = System.currentTimeMillis();
        try {
            ACK = (byte)this.getInputStream(null).read();
        }
        catch (EOFException eof) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("socket timeout is set to : " + this.getTimeout()));
                log.trace((Object)("EOFException waiting on ACK in readByte(). Time waited was " + (System.currentTimeMillis() - startWait)));
            }
            throw eof;
        }
        catch (IOException e) {
            log.trace((Object)"IOException when reading in ACK", (Throwable)e);
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("***acknowledge read byte" + Thread.currentThread()));
        }
        OutputStream out = this.getOutputStream(null);
        out.write(ACK);
        out.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

