/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import javax.net.SocketFactory;

public class RemotingRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private SocketFactory socketFactory;
    private String hostName;
    private static int defaultHashCode = "RemotingRMISocketFactory".hashCode();

    public RemotingRMIClientSocketFactory() {
    }

    public RemotingRMIClientSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public RemotingRMIClientSocketFactory(String hostName) {
        this.hostName = hostName;
    }

    public RemotingRMIClientSocketFactory(SocketFactory socketFactory, String hostName) {
        this.hostName = hostName;
        this.socketFactory = socketFactory;
    }

    public Socket createSocket(String host, int port) throws IOException {
        String effectiveHost;
        String string = effectiveHost = this.hostName != null ? this.hostName : host;
        if (this.socketFactory != null) {
            return this.socketFactory.createSocket(effectiveHost, port);
        }
        return new Socket(effectiveHost, port);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RemotingRMIClientSocketFactory)) {
            return false;
        }
        RemotingRMIClientSocketFactory sf = (RemotingRMIClientSocketFactory)o;
        if (this.socketFactory != null) {
            if (sf.socketFactory == null || !this.socketFactory.equals(sf.socketFactory)) {
                return false;
            }
            if (this.hostName != null) {
                return sf.hostName != null && this.hostName.equals(sf.hostName);
            }
            return sf.hostName == null;
        }
        if (sf.socketFactory != null) {
            return false;
        }
        if (this.hostName != null) {
            return sf.hostName != null && this.hostName.equals(sf.hostName);
        }
        return sf.hostName == null;
    }

    public int hashCode() {
        if (this.socketFactory != null) {
            if (this.hostName != null) {
                return this.socketFactory.hashCode() * this.hostName.hashCode();
            }
            return this.socketFactory.hashCode();
        }
        if (this.hostName != null) {
            return this.hostName.hashCode();
        }
        return defaultHashCode;
    }
}

