/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.app.server;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.detection.multicast.MulticastDetector;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.samples.app.server.SeismicHandler;
import org.jboss.remoting.transport.Connector;

public class SeismicServer {
    private String cityName;
    private String transport = "socket";
    private String host = "localhost";
    private MBeanServer mbeanServer;
    private Connector connector;

    public SeismicServer(String city) {
        this.cityName = city;
        this.mbeanServer = MBeanServerFactory.createMBeanServer();
        String locatorURI = this.transport + "://" + this.host;
        try {
            NetworkRegistry registry = NetworkRegistry.getInstance();
            this.mbeanServer.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));
            MulticastDetector detector = new MulticastDetector();
            this.mbeanServer.registerMBean(detector, new ObjectName("remoting:type=MulticastDetector"));
            detector.start();
            this.connector = new Connector();
            this.mbeanServer.registerMBean(this.connector, new ObjectName("remoting:type=Connector,transport=" + this.transport));
            this.connector.setInvokerLocator(locatorURI);
            this.connector.create();
            SeismicHandler handler = new SeismicHandler();
            this.connector.addInvocationHandler(this.cityName, handler);
            this.connector.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Need to start the seismic server with name of the city to monitor.");
        }
        SeismicServer server = new SeismicServer(args[0]);
    }
}

