/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.svc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.logging.LoggingService;
import org.jbpm.msg.MessageService;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.security.AuthenticationService;
import org.jbpm.security.AuthorizationService;
import org.jbpm.svc.JbpmServiceException;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.save.CascadeSaveOperation;
import org.jbpm.svc.save.CheckUnpersistableVariablesOperation;
import org.jbpm.svc.save.HibernateSaveOperation;
import org.jbpm.svc.save.SaveLogsOperation;
import org.jbpm.svc.save.SaveOperation;

public class Services
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVICENAME_AUTHENTICATION = "authentication";
    public static final String SERVICENAME_AUTHORIZATION = "authorization";
    public static final String SERVICENAME_LOGGING = "logging";
    public static final String SERVICENAME_MESSAGE = "message";
    public static final String SERVICENAME_PERSISTENCE = "persistence";
    public static final String SERVICENAME_SCHEDULER = "scheduler";
    static final List defaultSaveOperations = new ArrayList();
    Map serviceFactories = null;
    Map services = null;
    List serviceNames = null;
    List saveOperations = null;
    private static Log log;

    public static Service getCurrentService(String name) {
        return Services.getCurrentService(name, true);
    }

    public static Service getCurrentService(String name, boolean isRequired) {
        Service service = null;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null) {
            service = jbpmContext.getServices().getService(name);
        }
        if (isRequired && service == null) {
            throw new JbpmServiceException("service '" + name + "' unavailable");
        }
        return service;
    }

    public Services(Map serviceFactories) {
        this(serviceFactories, new ArrayList(serviceFactories.keySet()), null);
    }

    public Services(Map serviceFactories, List serviceNames, List saveOperations) {
        this.serviceFactories = serviceFactories;
        this.serviceNames = serviceNames;
        this.saveOperations = saveOperations != null ? saveOperations : defaultSaveOperations;
    }

    public void setSaveOperations(List saveOperations) {
        this.saveOperations = saveOperations;
    }

    public Map getServiceFactories() {
        if (this.serviceFactories == null) {
            this.serviceFactories = new HashMap();
        }
        return this.serviceFactories;
    }

    public ServiceFactory getServiceFactory(String name) {
        return (ServiceFactory)this.getServiceFactories().get(name);
    }

    public boolean hasService(String name) {
        boolean hasService = false;
        if (this.services != null) {
            hasService = this.services.containsKey(name);
        }
        return hasService;
    }

    public Service getService(String name) {
        ServiceFactory serviceFactory;
        Service service;
        if (this.services == null) {
            this.services = new HashMap();
        }
        if ((service = (Service)this.services.get(name)) == null && (serviceFactory = this.getServiceFactory(name)) != null) {
            service = serviceFactory.openService();
            this.services.put(name, service);
        }
        return service;
    }

    public void save(ProcessInstance processInstance, JbpmContext jbpmContext) {
        Iterator iter = this.saveOperations.iterator();
        if (log.isDebugEnabled()) {
            if (this.saveOperations == defaultSaveOperations) {
                log.debug((Object)"executing default save operations");
            } else {
                log.debug((Object)"executing custom save operations");
            }
        }
        while (iter.hasNext()) {
            SaveOperation saveOperation = (SaveOperation)iter.next();
            saveOperation.save(processInstance, jbpmContext);
        }
    }

    public AuthenticationService getAuthenticationService() {
        return (AuthenticationService)this.getService(SERVICENAME_AUTHENTICATION);
    }

    public AuthorizationService getAuthorizationService() {
        return (AuthorizationService)this.getService(SERVICENAME_AUTHORIZATION);
    }

    public LoggingService getLoggingService() {
        return (LoggingService)this.getService(SERVICENAME_LOGGING);
    }

    public MessageService getMessageService() {
        return (MessageService)this.getService(SERVICENAME_MESSAGE);
    }

    public PersistenceService getPersistenceService() {
        return (PersistenceService)((Object)this.getService(SERVICENAME_PERSISTENCE));
    }

    public SchedulerService getSchedulerService() {
        return (SchedulerService)this.getService(SERVICENAME_SCHEDULER);
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.services.put(SERVICENAME_AUTHENTICATION, authenticationService);
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.services.put(SERVICENAME_AUTHORIZATION, authorizationService);
    }

    public void setLoggingService(LoggingService loggingService) {
        this.services.put(SERVICENAME_LOGGING, loggingService);
    }

    public void setMessageService(MessageService messageService) {
        this.services.put(SERVICENAME_MESSAGE, messageService);
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.services.put(SERVICENAME_PERSISTENCE, persistenceService);
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.services.put(SERVICENAME_SCHEDULER, schedulerService);
    }

    public void close() {
        if (this.services != null) {
            HashMap<String, Throwable> closeExceptions = new HashMap<String, Throwable>();
            Throwable firstException = null;
            Iterator iter = this.serviceNames.iterator();
            while (iter.hasNext()) {
                String serviceName = (String)iter.next();
                Service service = (Service)this.services.get(serviceName);
                if (service == null) continue;
                try {
                    log.debug((Object)("closing service '" + serviceName + "': " + service));
                    service.close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    log.error((Object)("problem closing service '" + serviceName + "'"), t);
                    closeExceptions.put(serviceName, t);
                    if (firstException != null) continue;
                    firstException = t;
                }
            }
            if (!closeExceptions.isEmpty()) {
                throw new JbpmException("problem closing services " + closeExceptions, firstException);
            }
        }
    }

    public static void assignId(Object object) {
        Services services;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null && (services = jbpmContext.getServices()).hasService(SERVICENAME_PERSISTENCE)) {
            PersistenceService persistenceService = services.getPersistenceService();
            persistenceService.assignId(object);
        }
    }

    static {
        defaultSaveOperations.add(new CheckUnpersistableVariablesOperation());
        defaultSaveOperations.add(new HibernateSaveOperation());
        defaultSaveOperations.add(new SaveLogsOperation());
        defaultSaveOperations.add(new CascadeSaveOperation());
        log = LogFactory.getLog((Class)Services.class);
    }
}

