/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.Converter;
import org.jbpm.util.ClassLoaderUtil;

public class Converters {
    static HashMap convertersByClassNames = null;
    static HashMap convertersByDatabaseId = null;
    static HashMap convertersIds = null;

    public static Converter getConverterByClassName(String className) {
        Converters.initConvertionMaps();
        Converter converter = (Converter)convertersByClassNames.get(className);
        if (converter == null) {
            throw new JbpmException("converter '" + className + "' is not declared in jbpm.converter.properties");
        }
        return converter;
    }

    public static Converter getConverterByDatabaseId(String converterDatabaseId) {
        Converters.initConvertionMaps();
        return (Converter)convertersByDatabaseId.get(converterDatabaseId);
    }

    public static String getConverterId(Converter converter) {
        Converters.initConvertionMaps();
        return (String)convertersIds.get(converter);
    }

    static synchronized void initConvertionMaps() {
        if (convertersByClassNames == null) {
            String resource = JbpmConfiguration.Configs.getString("resource.converter");
            Properties converterProperties = ClassLoaderUtil.getProperties(resource);
            convertersByClassNames = new HashMap();
            convertersByDatabaseId = new HashMap();
            convertersIds = new HashMap();
            Iterator<Object> iter = converterProperties.keySet().iterator();
            while (iter.hasNext()) {
                String converterDatabaseId = (String)iter.next();
                if (converterDatabaseId.length() != 1) {
                    throw new RuntimeException("converter-ids must be of length 1 (to be stored in a char)");
                }
                if (convertersByDatabaseId.containsKey(converterDatabaseId)) {
                    throw new RuntimeException("duplicate converter id : '" + converterDatabaseId + "'");
                }
                String converterClassName = converterProperties.getProperty(converterDatabaseId);
                try {
                    Class converterClass = ClassLoaderUtil.loadClass(converterClassName);
                    Converter converter = (Converter)converterClass.newInstance();
                    convertersByClassNames.put(converterClassName, converter);
                    convertersByDatabaseId.put(converterDatabaseId, converter);
                    convertersIds.put(converter, converterDatabaseId);
                }
                catch (Exception e) {
                    throw new RuntimeException("couldn't instantiate converter '" + converterClassName + "'");
                }
            }
        }
    }
}

