/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.MessagingSession;
import org.jbpm.db.SchedulerSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.security.authentication.DefaultAuthenticationService;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class JbpmContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_JBPM_CONTEXT_NAME = "default.jbpm.context";
    static ThreadLocal currentContextsStack = new ThreadLocal();
    ObjectFactory objectFactory = null;
    Services services = null;
    List autoSaveProcessInstances = null;
    JbpmConfiguration jbpmConfiguration = null;
    private static Log log = LogFactory.getLog((Class)JbpmContext.class);

    static void reset() {
        currentContextsStack = new ThreadLocal();
    }

    public JbpmContext(Services services, ObjectFactory objectFactory) {
        log.debug((Object)"creating JbpmContext");
        this.services = services;
        this.objectFactory = objectFactory;
        this.pushThisContextOnTheStack();
    }

    public void close() {
        log.debug((Object)"closing JbpmContext");
        if (this.services != null) {
            this.autoSave();
            this.services.close();
        }
        this.popThisContextFromTheStack();
    }

    public static JbpmContext getCurrentJbpmContext() {
        JbpmContext currentJbpmContext = null;
        Stack stack = JbpmContext.getStack();
        if (!stack.isEmpty()) {
            currentJbpmContext = (JbpmContext)stack.peek();
        }
        return currentJbpmContext;
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        this.getGraphSession().deployProcessDefinition(processDefinition);
    }

    public List getTaskList() {
        String actorId = this.getActorId();
        return this.getTaskMgmtSession().findTaskInstances(actorId);
    }

    public List getTaskList(String actorId) {
        return this.getTaskMgmtSession().findTaskInstances(actorId);
    }

    public List getGroupTaskList(List actorIds) {
        return this.getTaskMgmtSession().findPooledTaskInstances(actorIds);
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        return this.getTaskMgmtSession().loadTaskInstance(taskInstanceId);
    }

    public TaskInstance loadTaskInstanceForUpdate(long taskInstanceId) {
        TaskInstance taskInstance = this.getTaskMgmtSession().loadTaskInstance(taskInstanceId);
        this.addAutoSaveTaskInstance(taskInstance);
        return taskInstance;
    }

    public Token loadToken(long tokenId) {
        return this.getGraphSession().loadToken(tokenId);
    }

    public Token loadTokenForUpdate(long tokenId) {
        Token token = this.getGraphSession().loadToken(tokenId);
        this.addAutoSaveToken(token);
        return token;
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        return this.getGraphSession().loadProcessInstance(processInstanceId);
    }

    public ProcessInstance loadProcessInstanceForUpdate(long processInstanceId) {
        ProcessInstance processInstance = this.getGraphSession().loadProcessInstance(processInstanceId);
        this.addAutoSaveProcessInstance(processInstance);
        return processInstance;
    }

    public ProcessInstance newProcessInstance(String processDefinitionName) {
        ProcessDefinition processDefinition = this.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        return new ProcessInstance(processDefinition);
    }

    public ProcessInstance newProcessInstanceForUpdate(String processDefinitionName) {
        ProcessDefinition processDefinition = this.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        this.addAutoSaveProcessInstance(processInstance);
        return processInstance;
    }

    public void save(ProcessInstance processInstance) {
        if (this.services != null) {
            this.services.save(processInstance, this);
        }
    }

    public void save(Token token) {
        this.save(token.getProcessInstance());
    }

    public void save(TaskInstance taskInstance) {
        this.save(taskInstance.getTaskMgmtInstance().getProcessInstance());
    }

    public void setRollbackOnly() {
        if (this.services != null) {
            this.services.getPersistenceService().setRollbackOnly();
        }
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceFactory getServiceFactory(String name) {
        return this.services.getServiceFactory(name);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public SessionFactory getSessionFactory() {
        DbPersistenceService persistenceService = (DbPersistenceService)this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService.getSessionFactory();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return;
        }
        persistenceService.setSessionFactory(sessionFactory);
    }

    public Session getSession() {
        DbPersistenceService persistenceService = (DbPersistenceService)this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService.getSession();
    }

    public void setSession(Session session) {
        DbPersistenceService persistenceService = (DbPersistenceService)this.getPersistenceService();
        if (persistenceService == null) {
            return;
        }
        persistenceService.setSession(session);
    }

    public Connection getConnection() {
        DbPersistenceService persistenceService = (DbPersistenceService)this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService.getConnection();
    }

    public void setConnection(Connection connection) {
        DbPersistenceService persistenceService = (DbPersistenceService)this.getPersistenceService();
        if (persistenceService == null) {
            return;
        }
        persistenceService.setConnection(connection);
    }

    public ContextSession getContextSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService.getContextSession();
    }

    public LoggingSession getLoggingSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService != null ? persistenceService.getLoggingSession() : null;
    }

    public MessagingSession getMessagingSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService != null ? persistenceService.getMessagingSession() : null;
    }

    public SchedulerSession getSchedulerSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService != null ? persistenceService.getSchedulerSession() : null;
    }

    public GraphSession getGraphSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService != null ? persistenceService.getGraphSession() : null;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService == null) {
            return null;
        }
        return persistenceService != null ? persistenceService.getTaskMgmtSession() : null;
    }

    public String getActorId() {
        return this.services.getAuthenticationService().getActorId();
    }

    public void setActorId(String actorId) {
        DefaultAuthenticationService authenticationService;
        DefaultAuthenticationService defaultAuthenticationService = authenticationService = (DefaultAuthenticationService)this.services.getAuthenticationService();
        defaultAuthenticationService.setActorId(actorId);
    }

    void addAutoSaveProcessInstance(ProcessInstance processInstance) {
        if (this.autoSaveProcessInstances == null) {
            this.autoSaveProcessInstances = new ArrayList();
        }
        this.autoSaveProcessInstances.add(processInstance);
    }

    void addAutoSaveToken(Token token) {
        this.addAutoSaveProcessInstance(token.getProcessInstance());
    }

    void addAutoSaveTaskInstance(TaskInstance taskInstance) {
        this.addAutoSaveProcessInstance(taskInstance.getTaskMgmtInstance().getProcessInstance());
    }

    void autoSave() {
        if (this.autoSaveProcessInstances != null) {
            Iterator iter = this.autoSaveProcessInstances.iterator();
            while (iter.hasNext()) {
                ProcessInstance processInstance = (ProcessInstance)iter.next();
                this.save(processInstance);
                iter.remove();
            }
        }
    }

    static Stack getStack() {
        Stack stack = (Stack)currentContextsStack.get();
        if (stack == null) {
            stack = new Stack();
            currentContextsStack.set(stack);
        }
        return stack;
    }

    void pushThisContextOnTheStack() {
        Stack stack = JbpmContext.getStack();
        stack.push(this);
    }

    void popThisContextFromTheStack() {
        Stack stack = JbpmContext.getStack();
        if (stack.isEmpty()) {
            throw new RuntimeException("closed JbpmContext more then once... check your try-finally's around JbpmContexts blocks");
        }
        JbpmContext popped = (JbpmContext)stack.pop();
        if (this != popped) {
            throw new RuntimeException("closed JbpmContext in different order then they were created... check your try-finally's around JbpmContexts blocks");
        }
    }

    PersistenceService getPersistenceService() {
        if (this.services == null) {
            return null;
        }
        return this.services.getPersistenceService();
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }
}

