/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.view.faces;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.view.faces.CallbacksFactory;
import org.apache.shale.view.faces.ExceptionHandlerFactory;
import org.apache.shale.view.faces.ViewControllerCallbacks;

public class ViewPhaseListener
implements PhaseListener {
    private static final Log log = LogFactory.getLog((Class)ViewPhaseListener.class);
    public static final String PHASE_ID = "org.apache.shale.view.PHASE_ID";
    private ViewControllerCallbacks viewControllerCallbacks = null;

    public void afterPhase(PhaseEvent event) {
        PhaseId phaseId;
        if (log.isTraceEnabled()) {
            log.trace((Object)("afterPhase(" + event.getFacesContext() + "," + event.getPhaseId() + ")"));
        }
        if (PhaseId.RESTORE_VIEW.equals(phaseId = event.getPhaseId())) {
            this.afterRestoreView(event);
        } else if (PhaseId.RENDER_RESPONSE.equals(phaseId) || event.getFacesContext().getResponseComplete()) {
            this.afterRenderResponse(event);
        }
        event.getFacesContext().getExternalContext().getRequestMap().remove(PHASE_ID);
    }

    public void beforePhase(PhaseEvent event) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("beforePhase(" + event.getFacesContext() + "," + event.getPhaseId() + ")"));
        }
        PhaseId phaseId = event.getPhaseId();
        event.getFacesContext().getExternalContext().getRequestMap().put(PHASE_ID, phaseId);
        if (PhaseId.RENDER_RESPONSE.equals(phaseId)) {
            this.beforeRenderResponse(event);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    private void afterRenderResponse(PhaseEvent event) {
        Map map = event.getFacesContext().getExternalContext().getRequestMap();
        List list = (List)map.get("org.apache.shale.view.VIEWS_INITIALIZED");
        if (list == null) {
            return;
        }
        Iterator vcs = list.iterator();
        while (vcs.hasNext()) {
            Object vc = vcs.next();
        }
        map.remove("org.apache.shale.view.VIEWS_INITIALIZED");
    }

    private void afterRestoreView(PhaseEvent event) {
        Map map = event.getFacesContext().getExternalContext().getRequestMap();
        List list = (List)map.get("org.apache.shale.view.VIEWS_INITIALIZED");
        if (list == null) {
            return;
        }
        if (!event.getFacesContext().getExternalContext().getRequestMap().containsKey("org.apache.shale.view.VIEW_POSTBACK")) {
            return;
        }
        Iterator vcs = list.iterator();
        while (vcs.hasNext()) {
            Object vc = vcs.next();
            try {
                this.viewControllerCallbacks(event.getFacesContext()).preprocess(vc);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void beforeRenderResponse(PhaseEvent event) {
        Map map = event.getFacesContext().getExternalContext().getRequestMap();
        String viewName = (String)map.get("org.apache.shale.view.VIEW_NAME_RENDERED");
        if (viewName == null) {
            return;
        }
        Object vc = map.get(viewName);
        if (vc == null) {
            return;
        }
        try {
            this.viewControllerCallbacks(event.getFacesContext()).prerender(vc);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        map.remove("org.apache.shale.view.VIEW_NAME_RENDERED");
    }

    private ViewControllerCallbacks viewControllerCallbacks(FacesContext context) {
        if (this.viewControllerCallbacks == null) {
            this.viewControllerCallbacks = (ViewControllerCallbacks)context.getExternalContext().getApplicationMap().get("org.apache.shale.view.VIEW_CALLBACKS");
            if (this.viewControllerCallbacks == null) {
                this.viewControllerCallbacks = CallbacksFactory.getInstance().getViewControllerCallbacks();
                context.getExternalContext().getApplicationMap().put("org.apache.shale.view.VIEW_CALLBACKS", this.viewControllerCallbacks);
            }
        }
        return this.viewControllerCallbacks;
    }

    private void handleException(Exception exception) {
        ExceptionHandlerFactory.getInstance().getExceptionHandler().handleException(exception);
    }
}

