/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.crosstable;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;

public class UIColumns
extends UIData {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.Columns";
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    private static final int PROCESS_DECODES = 1;
    private static final int PROCESS_VALIDATORS = 2;
    private static final int PROCESS_UPDATES = 3;
    private boolean _isValidChilds = true;
    private Map _cellStates = new HashMap();
    private Object _initialDescendantComponentState = null;
    private int _colIndex = -1;
    private UIData _parentUIData;
    private Map _dataModelMap = new HashMap();
    private static final DataModel EMPTY_DATA_MODEL = new DataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IndexOutOfBoundsException("Index < 0 : " + i);
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " UnsupportedOperationException");
        }
    };

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this._colIndex;
    }

    public void setRowIndex(int colIndex) {
        if (colIndex < -1) {
            throw new IllegalArgumentException("colIndex is less than -1");
        }
        if (this._colIndex == colIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._colIndex == -1) {
            if (this._initialDescendantComponentState == null) {
                this._initialDescendantComponentState = this.saveDescendantComponentStates(this.getFacetsAndChildren());
            }
        } else {
            this._cellStates.put(this.getClientId(facesContext), this.saveDescendantComponentStates(this.getFacetsAndChildren()));
        }
        this._colIndex = colIndex;
        DataModel dataModel = this.getDataModel();
        dataModel.setRowIndex(colIndex);
        String var = this.getVar();
        if (colIndex == -1) {
            if (var != null) {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        } else if (var != null) {
            if (this.isRowAvailable()) {
                Object rowData = dataModel.getRowData();
                facesContext.getExternalContext().getRequestMap().put(var, rowData);
            } else {
                facesContext.getExternalContext().getRequestMap().remove(var);
            }
        }
        if (this._colIndex == -1) {
            this.restoreDescendantComponentStates(this.getFacetsAndChildren(), this._initialDescendantComponentState);
        } else {
            Object rowState = this._cellStates.get(this.getClientId(facesContext));
            if (rowState == null) {
                this.restoreDescendantComponentStates(this.getFacetsAndChildren(), this._initialDescendantComponentState);
            } else {
                this.restoreDescendantComponentStates(this.getFacetsAndChildren(), rowState);
            }
        }
    }

    protected void restoreDescendantComponentStates(Iterator childIterator, Object state) {
        Iterator descendantStateIterator = null;
        while (childIterator.hasNext()) {
            if (descendantStateIterator == null && state != null) {
                descendantStateIterator = ((Collection)state).iterator();
            }
            UIComponent component = (UIComponent)childIterator.next();
            component.setId(component.getId());
            if (component.isTransient()) continue;
            Object childState = null;
            Object descendantState = null;
            if (descendantStateIterator != null && descendantStateIterator.hasNext()) {
                Object[] object = (Object[])descendantStateIterator.next();
                childState = object[0];
                descendantState = object[1];
            }
            if (component instanceof EditableValueHolder) {
                ((EditableValueHolderState)childState).restoreState((EditableValueHolder)component);
            }
            this.restoreDescendantComponentStates(component.getFacetsAndChildren(), descendantState);
        }
    }

    protected Object saveDescendantComponentStates(Iterator childIterator) {
        ArrayList<Object[]> childStates = null;
        while (childIterator.hasNext()) {
            UIComponent child;
            if (childStates == null) {
                childStates = new ArrayList<Object[]>();
            }
            if ((child = (UIComponent)childIterator.next()).isTransient()) continue;
            Object descendantState = this.saveDescendantComponentStates(child.getFacetsAndChildren());
            EditableValueHolderState state = null;
            if (child instanceof EditableValueHolder) {
                state = new EditableValueHolderState((EditableValueHolder)child);
            }
            childStates.add(new Object[]{state, descendantState});
        }
        return childStates;
    }

    public void setValue(Object value) {
        super.setValue(value);
        this._dataModelMap.clear();
        this._cellStates.clear();
        this._isValidChilds = true;
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (name.equals("value")) {
            this._dataModelMap.clear();
        } else if (name.equals("var") || name.equals("rowIndex")) {
            throw new IllegalArgumentException("name " + name);
        }
        super.setValueBinding(name, binding);
    }

    protected DataModel getDataModel() {
        String clientID = this.getParentUIData().getParent().getClientId(this.getFacesContext());
        DataModel dataModel = (DataModel)this._dataModelMap.get(clientID);
        if (dataModel == null) {
            dataModel = this.createDataModel();
            this._dataModelMap.put(clientID, dataModel);
        }
        return dataModel;
    }

    protected void setDataModel(DataModel dataModel) {
        this._dataModelMap.put(this.getParentUIData().getParent().getClientId(this.getFacesContext()), dataModel);
    }

    protected DataModel createDataModel() {
        Object value = this.getValue();
        if (value == null) {
            return EMPTY_DATA_MODEL;
        }
        if (value instanceof DataModel) {
            return (DataModel)value;
        }
        if (value instanceof List) {
            return new ListDataModel((List)value);
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(value.getClass())) {
            return new ArrayDataModel((Object[])value);
        }
        if (value instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)value);
        }
        if (value instanceof Result) {
            return new ResultDataModel((Result)value);
        }
        return new ScalarDataModel(value);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processColumnsFacets(context, 1);
        this.processRows(context, 1);
        this.setRowIndex(-1);
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    private void processColumnsFacets(FacesContext context, int processAction) {
        int first = this.getFirst();
        int cols = this.getRows();
        int last = cols == 0 ? this.getRowCount() : first + cols;
        for (int colIndex = first; colIndex < last; ++colIndex) {
            this.setRowIndex(colIndex);
            if (!this.isRowAvailable()) continue;
            Iterator facetsIter = this.getFacets().values().iterator();
            while (facetsIter.hasNext()) {
                UIComponent facet = (UIComponent)facetsIter.next();
                this.process(context, facet, processAction);
            }
        }
        this.setRowIndex(-1);
    }

    private void processRows(FacesContext context, int processAction) {
        UIData parentUIData = this.getParentUIData();
        int first = parentUIData.getFirst();
        int rows = parentUIData.getRows();
        int last = rows == 0 ? parentUIData.getRowCount() : first + rows;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            parentUIData.setRowIndex(rowIndex);
            if (!parentUIData.isRowAvailable()) continue;
            this.processColumns(context, processAction);
        }
    }

    private UIData getParentUIData() {
        if (this._parentUIData == null) {
            UIComponent parent = this.getParent();
            if (!(parent instanceof UIData)) {
                throw new IllegalStateException("UIColumns component must be a child of a UIData component");
            }
            this._parentUIData = (UIData)parent;
        }
        return this._parentUIData;
    }

    private void processColumns(FacesContext context, int processAction) {
        int first = this.getFirst();
        int cols = this.getRows();
        int last = cols == 0 ? this.getRowCount() : first + cols;
        for (int colIndex = first; colIndex < last; ++colIndex) {
            this.setRowIndex(colIndex);
            if (!this.isRowAvailable()) continue;
            Iterator columnChildIter = this.getChildren().iterator();
            while (columnChildIter.hasNext()) {
                UIComponent columnChild = (UIComponent)columnChildIter.next();
                this.process(context, columnChild, processAction);
            }
        }
        this.setRowIndex(-1);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processColumnsFacets(context, 2);
        this.processRows(context, 2);
        this.setRowIndex(-1);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.setRowIndex(-1);
        this.processColumnsFacets(context, 3);
        this.processRows(context, 3);
        this.setRowIndex(-1);
        if (context.getRenderResponse()) {
            this._isValidChilds = false;
        }
    }

    private void process(FacesContext context, UIComponent component, int processAction) {
        switch (processAction) {
            case 1: {
                component.processDecodes(context);
                break;
            }
            case 2: {
                component.processValidators(context);
                break;
            }
            case 3: {
                component.processUpdates(context);
            }
        }
    }

    public void encodeTableBegin(FacesContext context) {
        if (this._isValidChilds) {
            this._dataModelMap.clear();
            this._cellStates.clear();
            this._initialDescendantComponentState = null;
        }
    }

    public void encodeTableEnd(FacesContext context) {
        this.setRowIndex(-1);
    }

    private class EditableValueHolderState {
        private final Object _value;
        private final boolean _localValueSet;
        private final boolean _valid;
        private final Object _submittedValue;

        public EditableValueHolderState(EditableValueHolder evh) {
            this._value = evh.getLocalValue();
            this._localValueSet = evh.isLocalValueSet();
            this._valid = evh.isValid();
            this._submittedValue = evh.getSubmittedValue();
        }

        public void restoreState(EditableValueHolder evh) {
            evh.setValue(this._value);
            evh.setLocalValueSet(this._localValueSet);
            evh.setValid(this._valid);
            evh.setSubmittedValue(this._submittedValue);
        }
    }
}

