/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remote;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.impl.ContextBase;
import org.apache.shale.remote.ContextAttributes;
import org.apache.shale.remote.RemoteContext;
import org.apache.shale.remote.RequestAttributes;
import org.apache.shale.remote.SessionAttributes;

public class ServletRemoteContext
extends ContextBase
implements RemoteContext {
    private static final int BYTES_BUFFER_SIZE = 1024;
    private static final int CHARS_BUFFER_SIZE = 2048;
    private ServletContext context = null;
    private Map contextAttributes = null;
    private HttpServletRequest request = null;
    private Map requestAttributes = null;
    private HttpServletResponse response = null;
    private Map sessionAttributes = null;
    private int responseContentLength = 0;

    public ServletRemoteContext(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        this.context = context;
        this.request = request;
        this.response = response;
    }

    public Map getContextAttributes() {
        if (this.contextAttributes == null) {
            this.contextAttributes = new ContextAttributes(this.context);
        }
        return this.contextAttributes;
    }

    public Map getRequestAttributes() {
        if (this.requestAttributes == null) {
            this.requestAttributes = new RequestAttributes(this.request);
        }
        return this.requestAttributes;
    }

    public int getRequestContentLength() {
        return this.request.getContentLength();
    }

    public String getRequestContentType() {
        return this.request.getContentType();
    }

    public String getRequestEncoding() {
        return this.request.getCharacterEncoding();
    }

    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public Map getRequestParameters() {
        return this.request.getParameterMap();
    }

    public Reader getRequestReader() throws IOException {
        return new BufferedReader(this.request.getReader(), 2048);
    }

    public InputStream getRequestStream() throws IOException {
        return new BufferedInputStream((InputStream)this.request.getInputStream(), 1024);
    }

    public int getResponseContentLength() {
        return this.responseContentLength;
    }

    public void setResponseContentLength(int contentLength) {
        this.responseContentLength = contentLength;
        this.response.setContentLength(contentLength);
    }

    public String getResponseContentType() {
        return this.response.getContentType();
    }

    public void setResponseContentType(String contentType) {
        this.response.setContentType(contentType);
    }

    public String getResponseEncoding() {
        return this.response.getCharacterEncoding();
    }

    public void setResponseEncoding(String encoding) {
        this.response.setCharacterEncoding(encoding);
    }

    public OutputStream getResponseStream() throws IOException {
        return new BufferedOutputStream((OutputStream)this.response.getOutputStream(), 1024);
    }

    public Writer getResponseWriter() throws IOException {
        return new BufferedWriter(this.response.getWriter(), 2048);
    }

    public Map getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = new SessionAttributes(this.request.getSession());
        }
        return this.sessionAttributes;
    }
}

