/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.faces;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.VariableResolver;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ShaleVariableResolver
extends VariableResolver {
    private VariableResolver original = null;
    private static final String JNDI_VARIABLE_NAME = "jndi";
    private static final String TIGER_DELEGATE = "org.apache.shale.tiger.faces.VariableResolverImpl";
    private static final Class[] VARIABLE_RESOLVER_ARGS = new Class[]{VariableResolver.class};

    public ShaleVariableResolver(VariableResolver original) {
        VariableResolver delegate = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(TIGER_DELEGATE);
            Constructor<?> constructor = clazz.getConstructor(VARIABLE_RESOLVER_ARGS);
            delegate = (VariableResolver)constructor.newInstance(original);
        }
        catch (ClassNotFoundException e) {
            delegate = null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new FacesException(cause);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        this.original = delegate != null ? delegate : original;
    }

    public Object resolveVariable(FacesContext context, String name) throws EvaluationException {
        if (JNDI_VARIABLE_NAME.equals(name)) {
            try {
                InitialContext ic = new InitialContext();
                return (Context)ic.lookup("java:comp/env");
            }
            catch (NamingException e) {
                throw new EvaluationException((Throwable)e);
            }
        }
        return this.original.resolveVariable(context, name);
    }
}

