/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.dialog.faces;

import java.util.Map;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.dialog.ActionState;
import org.apache.shale.dialog.Dialog;
import org.apache.shale.dialog.EndState;
import org.apache.shale.dialog.State;
import org.apache.shale.dialog.Status;
import org.apache.shale.dialog.SubdialogState;
import org.apache.shale.dialog.Transition;
import org.apache.shale.dialog.ViewState;
import org.apache.shale.dialog.impl.StatusImpl;
import org.apache.shale.util.Messages;

public final class DialogNavigationHandler
extends NavigationHandler {
    private static final Object[] PARAMETERS;
    public static final String PREFIX = "dialog:";
    public static final Class[] SIGNATURE;
    private static final Messages messages;
    private NavigationHandler handler = null;
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String statusKey = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DialogNavigationHandler(NavigationHandler handler) {
        this.handler = handler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        Status status;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("handleNavigation(viewId=" + context.getViewRoot().getViewId() + ",fromAction=" + fromAction + ",outcome=" + outcome + ")"));
        }
        if ((status = this.getStatus(context, false)) == null) {
            if (outcome != null && outcome.startsWith(PREFIX)) {
                this.start(context, outcome.substring(PREFIX.length()));
            } else {
                this.handler.handleNavigation(context, fromAction, outcome);
            }
            return;
        }
        Status.Position position = status.peek();
        if (position == null) {
            if (outcome != null && outcome.startsWith(PREFIX)) {
                this.start(context, outcome.substring(PREFIX.length()));
            } else {
                this.handler.handleNavigation(context, fromAction, outcome);
            }
            return;
        }
        Dialog dialog = this.getDialog(context, position.getDialogName());
        if (dialog == null) {
            throw new IllegalArgumentException(messages.getMessage("dialog.noDialog", new Object[]{position.getDialogName()}));
        }
        State state = dialog.findState(position.getStateName());
        if (state == null) {
            throw new IllegalArgumentException(messages.getMessage("dialog.noState", new Object[]{position.getStateName(), position.getDialogName()}));
        }
        this.postprocess(context, status, state, outcome);
    }

    private void action(FacesContext context, Status status, ActionState state) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && status == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("action(state=" + state + ")"));
        }
        MethodBinding mb = context.getApplication().createMethodBinding(state.getMethod(), SIGNATURE);
        String outcome = (String)mb.invoke(context, PARAMETERS);
        State nextState = this.transition(status, state, outcome);
        this.preprocess(context, status, nextState, outcome);
    }

    private Dialog getDialog(FacesContext context, String dialogName) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dialogName == null) {
            throw new AssertionError();
        }
        Map map = (Map)context.getExternalContext().getApplicationMap().get("org.apache.shale.dialog.DIALOGS");
        if (map == null) {
            throw new IllegalStateException(messages.getMessage("dialog.unconfigured"));
        }
        return (Dialog)map.get(dialogName);
    }

    private Status getStatus(FacesContext context, boolean create) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        Map map = context.getExternalContext().getSessionMap();
        String key = this.getStatusKey(context);
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        Status status = (Status)map.get(key);
        if (create && status == null) {
            status = new StatusImpl();
            map.put(key, status);
        }
        return status;
    }

    private String getStatusKey(FacesContext context) {
        if (this.statusKey == null) {
            this.statusKey = context.getExternalContext().getInitParameter("org.apache.shale.dialog.STATUS");
            if (this.statusKey == null) {
                this.statusKey = "dialog";
            }
        }
        return this.statusKey;
    }

    private void postprocess(FacesContext context, Status status, State state, String outcome) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("preprocess(state=" + state + ",outcome=" + outcome + ")"));
        }
        if (!(state instanceof ViewState)) {
            throw new IllegalArgumentException(messages.getMessage("dialog.noPostProcess", new Object[]{state.getName(), state.getClass().getName()}));
        }
        State nextState = this.transition(status, state, outcome);
        this.preprocess(context, status, nextState, outcome);
    }

    private void preprocess(FacesContext context, Status status, State state, String outcome) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && status == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("preprocess(state=" + state + ",outcome=" + outcome + ")"));
        }
        if (state instanceof ActionState) {
            this.action(context, status, (ActionState)state);
        } else if (state instanceof EndState) {
            Status.Position position;
            String viewId = ((EndState)state).getViewId();
            if (viewId != null) {
                this.render(context, viewId);
            }
            if ((position = status.pop()) != null) {
                Dialog dialog = this.getDialog(context, position.getDialogName());
                if (dialog == null) {
                    throw new IllegalArgumentException(position.getDialogName());
                }
                state = dialog.findState(position.getStateName());
                if (state == null) {
                    throw new IllegalArgumentException(dialog.getStart());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("-->resume(state=" + state + ",outcome=" + outcome + ")"));
                }
                State nextState = this.transition(status, state, outcome);
                this.preprocess(context, status, nextState, outcome);
            }
        } else if (state instanceof SubdialogState) {
            this.start(context, ((SubdialogState)state).getDialogName());
        } else if (state instanceof ViewState) {
            this.render(context, ((ViewState)state).getViewId());
        } else {
            throw new IllegalArgumentException(messages.getMessage("dialog.noPreProcess", new Object[]{state.getName(), state.getClass().getName()}));
        }
    }

    private void render(FacesContext context, String viewId) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("render(viewId=" + viewId + ")"));
        }
        if (viewId == null) {
            return;
        }
        ViewHandler vh = context.getApplication().getViewHandler();
        UIViewRoot view = vh.createView(context, viewId);
        view.setViewId(viewId);
        context.setViewRoot(view);
    }

    private void start(FacesContext context, String dialogName) {
        Dialog dialog;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("start(dialogName=" + dialogName + ")"));
        }
        if ((dialog = this.getDialog(context, dialogName)) == null) {
            throw new IllegalArgumentException(dialogName);
        }
        State state = dialog.findState(dialog.getStart());
        if (state == null) {
            throw new IllegalArgumentException(dialog.getStart());
        }
        Status status = this.getStatus(context, true);
        if (!$assertionsDisabled && status == null) {
            throw new AssertionError();
        }
        status.push(new Status.Position(dialog.getName(), state.getName()));
        this.preprocess(context, status, state, dialogName);
    }

    private State transition(Status status, State state, String outcome) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("transition(state=" + state + ",outcome=" + outcome + ")"));
        }
        if (state instanceof ViewState && outcome == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"  --> Stay in current state");
            }
            return state;
        }
        Transition transition = state.findTransition(outcome);
        if (transition == null) {
            transition = state.getDialog().findTransition(outcome);
        }
        if (transition == null) {
            throw new IllegalArgumentException(messages.getMessage("dialog.noTransition", new Object[]{outcome, state.getName(), state.getDialog().getName()}));
        }
        State nextState = state.getDialog().findState(transition.getTarget());
        if (nextState == null) {
            throw new IllegalArgumentException(messages.getMessage("dialog.noNextState", new Object[]{outcome, state.getName(), state.getDialog().getName(), transition.getTarget()}));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("-->nextState=" + nextState));
        }
        status.transition(nextState.getName());
        return nextState;
    }

    static {
        $assertionsDisabled = !DialogNavigationHandler.class.desiredAssertionStatus();
        PARAMETERS = new Object[0];
        SIGNATURE = new Class[0];
        messages = new Messages("org.apache.shale.resources.Bundle");
    }
}

