/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.shale.validator.CommonsValidator;

public class ValidatorScript
extends UIComponentBase {
    private String functionName;
    private Map validators = new LinkedHashMap();

    public String getRendererType() {
        return null;
    }

    public String getFamily() {
        return null;
    }

    public String getFunctionName() {
        if (this.functionName != null) {
            return this.functionName;
        }
        ValueBinding _vb = this.getValueBinding("functionName");
        if (_vb != null) {
            return (String)_vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.functionName = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.functionName};
        return values;
    }

    private void addValidator(String type, String id, CommonsValidator v) {
        LinkedHashMap<String, CommonsValidator> map = (LinkedHashMap<String, CommonsValidator>)this.validators.get(type);
        if (map == null) {
            map = new LinkedHashMap<String, CommonsValidator>();
            this.validators.put(type, map);
        }
        if (id != null) {
            map.put(id, v);
        }
    }

    private void findCommonsValidators(UIComponent c, FacesContext context) {
        if (c instanceof EditableValueHolder) {
            EditableValueHolder h = (EditableValueHolder)c;
            Validator[] vs = h.getValidators();
            for (int i = 0; i < vs.length; ++i) {
                if (!(vs[i] instanceof CommonsValidator)) continue;
                CommonsValidator v = (CommonsValidator)vs[i];
                if (Boolean.TRUE.equals(v.getClient())) {
                    String id = c.getClientId(context);
                    this.addValidator(v.getType(), id, v);
                    ValidatorAction action = v.getValidatorAction();
                    List list = action.getDependencyList();
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        String type = (String)iter.next();
                        this.addValidator(type, id, v);
                    }
                }
                if (!Boolean.TRUE.equals(v.getServer()) || !"required".equals(v.getType())) continue;
                h.setRequired(true);
            }
        }
        Iterator childrenIterator = c.getFacetsAndChildren();
        while (childrenIterator.hasNext()) {
            UIComponent child = (UIComponent)childrenIterator.next();
            this.findCommonsValidators(child, context);
        }
        childrenIterator = null;
    }

    private void writeScriptStart(ResponseWriter writer) throws IOException {
        writer.startElement("script", (UIComponent)this);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeAttribute("language", (Object)"Javascript1.1", null);
        writer.write("\n<!--\n");
    }

    private void writeScriptEnd(ResponseWriter writer) throws IOException {
        writer.write("\n-->\n");
        writer.endElement("script");
    }

    private static String getJavaScriptFunctionName(ValidatorAction action) {
        StringTokenizer tokenizer = new StringTokenizer(action.getJavascript(), " \n\r\t(");
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }

    private void writeValidationFunctions(ResponseWriter writer, FacesContext context) throws IOException {
        ValidatorAction a;
        String type;
        writer.write("var bCancel = false;\n");
        writer.write("function ");
        writer.write(this.getAttributes().get("functionName").toString());
        writer.write("(form) { return bCancel || true\n");
        Iterator iter = this.validators.keySet().iterator();
        while (iter.hasNext()) {
            type = (String)iter.next();
            a = CommonsValidator.getValidatorAction(type);
            writer.write("&& ");
            writer.write(ValidatorScript.getJavaScriptFunctionName(a));
            writer.write("(form)\n");
        }
        writer.write(";}\n");
        iter = this.validators.keySet().iterator();
        while (iter.hasNext()) {
            type = (String)iter.next();
            a = CommonsValidator.getValidatorAction(type);
            writer.write("function ");
            String callback = a.getJsFunctionName();
            if (callback == null) {
                callback = type;
            }
            writer.write(callback);
            writer.write("() { \n");
            Map map = (Map)this.validators.get(type);
            Iterator iter2 = map.keySet().iterator();
            int k = 0;
            while (iter2.hasNext()) {
                String id = (String)iter2.next();
                CommonsValidator v = (CommonsValidator)map.get(id);
                writer.write("this[" + k + "] = ");
                ++k;
                this.writeJavaScriptParams(writer, context, id, v);
                writer.write(";\n");
            }
            writer.write("}\n");
        }
        this.addValidator("integer", null, null);
        this.addValidator("required", null, null);
        iter = this.validators.keySet().iterator();
        while (iter.hasNext()) {
            type = (String)iter.next();
            a = CommonsValidator.getValidatorAction(type);
            writer.write(a.getJavascript());
            writer.write("\n");
        }
    }

    public void writeJavaScriptParams(ResponseWriter writer, FacesContext context, String id, CommonsValidator v) throws IOException {
        writer.write("new Array(\"");
        writer.write(id);
        writer.write("\", \"");
        writer.write(v.getErrorMessage(v.getArg(), context));
        writer.write("\", new Function(\"x\", \"return {");
        String[] names = v.getParamNames();
        Object[] params = v.getParams();
        for (int i = 0; i < names.length; ++i) {
            if (i > 0) {
                writer.write(",");
            }
            writer.write(names[i]);
            writer.write(":");
            if (names[i].equals("mask")) {
                writer.write("/");
            } else {
                writer.write("'");
            }
            writer.write(params[i].toString());
            if (names[i].equals("mask")) {
                writer.write("/");
                continue;
            }
            writer.write("'");
        }
        writer.write("}[x];\"))");
    }

    public void encodeBegin(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.validators.clear();
        this.findCommonsValidators((UIComponent)context.getViewRoot(), context);
        this.writeScriptStart(writer);
        this.writeValidationFunctions(writer, context);
        this.writeScriptEnd(writer);
    }
}

