/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel.schema;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceBinding;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.advice.ScopedInterceptorFactory;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aspects.kernel.DelegatingAspectFactory;
import org.jboss.aspects.kernel.GenericKernelAspectFactory;
import org.jboss.aspects.kernel.KernelAspectFactory;
import org.jboss.aspects.kernel.SimpleAspectFactory;
import org.jboss.aspects.kernel.schema.DeploymentInfo;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingInitializer;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.xml.sax.Attributes;

public class AspectSchemaBindingInitalizer
implements SchemaBindingInitializer {
    public static final String SCHEMA_NAME = "/aop-deployer_1_1.xsd";
    public static final String AOP_DEPLOYER_NS = "urn:jboss:aop-deployer";
    public static final QName aopTypeQName = new QName("urn:jboss:aop-deployer", "aopType");
    public static final QName domainTypeQName = new QName("urn:jboss:aop-deployer", "domainType");
    public static final QName domainQName = new QName("urn:jboss:aop-deployer", "domain");
    public static final QName classQName = new QName("urn:jboss:aop-deployer", "class");
    public static final QName constructionQName = new QName("urn:jboss:aop-deployer", "construction");
    public static final QName factoryQName = new QName("urn:jboss:aop-deployer", "factory");
    public static final QName interceptorQName = new QName("urn:jboss:aop-deployer", "interceptor");
    public static final QName interceptorRefQName = new QName("urn:jboss:aop-deployer", "interceptor-ref");
    public static final QName interceptorTypeQName = new QName("urn:jboss:aop-deployer", "interceptorType");
    public static final QName interceptorRefTypeQName = new QName("urn:jboss:aop-deployer", "interceptorRefType");
    public static final QName introductionQName = new QName("urn:jboss:aop-deployer", "introduction");
    public static final QName introductionTypeQName = new QName("urn:jboss:aop-deployer", "introductionType");
    public static final QName interfacesQName = new QName("urn:jboss:aop-deployer", "interfaces");
    public static final QName metadataLoaderQName = new QName("urn:jboss:aop-deployer", "metadata-loader");
    public static final QName metadataLoaderTypeQName = new QName("urn:jboss:aop-deployer", "metadataLoaderType");
    public static final QName metadataQName = new QName("urn:jboss:aop-deployer", "metadata");
    public static final QName metadataTypeQName = new QName("urn:jboss:aop-deployer", "metadataType");
    public static final QName mixinTypeQName = new QName("urn:jboss:aop-deployer", "mixinType");
    public static final QName mixinQName = new QName("urn:jboss:aop-deployer", "mixin");
    public static final QName stackQName = new QName("urn:jboss:aop-deployer", "stack");
    public static final QName stackTypeQName = new QName("urn:jboss:aop-deployer", "stackType");
    public static final QName aspectQName = new QName("urn:jboss:aop-deployer", "aspect");
    public static final QName aspectTypeQName = new QName("urn:jboss:aop-deployer", "aspectType");
    public static final QName pointcutQName = new QName("urn:jboss:aop-deployer", "pointcut");
    public static final QName pointcutTypeQName = new QName("urn:jboss:aop-deployer", "pointcutType");
    public static final QName pluggablePointcutQName = new QName("urn:jboss:aop-deployer", "pluggable-pointcut");
    public static final QName pluggablePointcutTypeQName = new QName("urn:jboss:aop-deployer", "pluggablePointcutType");
    public static final QName bindQName = new QName("urn:jboss:aop-deployer", "bind");
    public static final QName bindTypeQName = new QName("urn:jboss:aop-deployer", "bindType");
    public static final QName prepareQName = new QName("urn:jboss:aop-deployer", "prepare");
    public static final QName prepareTypeQName = new QName("urn:jboss:aop-deployer", "prepareType");
    public static final QName cflowStackQName = new QName("urn:jboss:aop-deployer", "cflow-stack");
    public static final QName cflowStackTypeQName = new QName("urn:jboss:aop-deployer", "cflowStackType");
    public static final QName dynamicCflowQName = new QName("urn:jboss:aop-deployer", "dynamic-cflow");
    public static final QName dynamicCflowTypeQName = new QName("urn:jboss:aop-deployer", "dynamicCflowType");
    public static final QName annotationQName = new QName("urn:jboss:aop-deployer", "annotation");
    public static final QName annotationTypeQName = new QName("urn:jboss:aop-deployer", "annotationType");
    public static final QName annotationIntroductionQName = new QName("urn:jboss:aop-deployer", "annotation-introduction");
    public static final QName annotationIntroductionTypeQName = new QName("urn:jboss:aop-deployer", "annotationIntroductionType");
    public static final QName typedefQName = new QName("urn:jboss:aop-deployer", "typedef");
    public static final QName typedefTypeQName = new QName("urn:jboss:aop-deployer", "typedefType");

    public synchronized SchemaBinding init(SchemaBinding schema) {
        this.createAopType(schema);
        this.createDomainType(schema);
        this.createInterceptorType(schema);
        this.createIntroductionType(schema);
        this.createMetadataLoaderType(schema);
        this.createMetadataType(schema);
        this.createStackType(schema);
        this.createAspectType(schema);
        this.createPointcutType(schema);
        this.createPluggablePointcutType(schema);
        this.createBindType(schema);
        this.createPrepareType(schema);
        this.createCflowStackType(schema);
        this.createDynamicCflowType(schema);
        this.createAnnotationType(schema);
        this.createAnnotationIntroductionType(schema);
        this.createTypedefType(schema);
        return schema;
    }

    public void createAopType(SchemaBinding binding) {
        TypeBinding aopType = binding.getType(aopTypeQName);
        aopType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return DeploymentInfo.getDeployment().getCurrentManager();
            }
        });
        aopType.pushInterceptor(aspectQName, (ElementInterceptor)new AspectElementInterceptor());
        aopType.pushInterceptor(interceptorQName, (ElementInterceptor)new InterceptorElementInterceptor());
    }

    public void createInterceptorType(SchemaBinding binding) {
        TypeBinding interceptorType = binding.getType(interceptorTypeQName);
        interceptorType.setHandler((ParticleHandler)new AspectElementHandler());
        interceptorType.pushInterceptor(classQName, (ElementInterceptor)new AspectConfigElementInterceptor());
        interceptorType.pushInterceptor(factoryQName, (ElementInterceptor)new AspectFactoryElementInterceptor());
    }

    public void createAspectType(SchemaBinding binding) {
        TypeBinding interceptorType = binding.getType(aspectTypeQName);
        interceptorType.setHandler((ParticleHandler)new AspectElementHandler());
        interceptorType.pushInterceptor(classQName, (ElementInterceptor)new AspectConfigElementInterceptor());
        interceptorType.pushInterceptor(factoryQName, (ElementInterceptor)new AspectFactoryElementInterceptor());
    }

    public void createBindType(SchemaBinding binding) {
        TypeBinding bindType = binding.getType(bindTypeQName);
        bindType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new AdviceBinding();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                AdviceBinding binding = (AdviceBinding)o;
                String name = null;
                String pointcut = null;
                String cflow = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if ("name".equals(localName)) {
                        name = attrs.getValue(i);
                        continue;
                    }
                    if ("pointcut".equals(localName)) {
                        pointcut = attrs.getValue(i);
                        continue;
                    }
                    if (!"cflow".equals(localName)) continue;
                    cflow = attrs.getValue(i);
                }
                if ("".equals(name)) {
                    name = null;
                }
                if ("".equals(pointcut)) {
                    pointcut = null;
                }
                if ("".equals(cflow)) {
                    cflow = null;
                }
                if (name == null) {
                    name = DeploymentInfo.getDeployment().generateName();
                }
                binding.setName(name);
                try {
                    binding.setPointcutExpression(pointcut);
                    binding.setCFlowExpression(cflow);
                }
                catch (ParseException e) {
                    new RuntimeException(e);
                }
                DeploymentInfo.getDeployment().getCurrentManager().addPointcut(binding.getPointcut());
                DeploymentInfo.getDeployment().getCurrentManager().addBinding(binding);
            }
        });
        this.createAdvices(binding, bindType);
    }

    protected void createAdvices(SchemaBinding binding, TypeBinding bind) {
        TypeBinding interceptorRefType = binding.getType(interceptorRefTypeQName);
        interceptorRefType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new ObjectHolder();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                ObjectHolder holder = (ObjectHolder)o;
                String name = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if (!"name".equals(localName)) continue;
                    name = attrs.getValue(i);
                }
                holder.obj = DeploymentInfo.getDeployment().getCurrentManager().getInterceptorFactory(name);
            }
        });
        bind.pushInterceptor(interceptorRefQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName name) {
                AdviceBinding type = (AdviceBinding)parent;
                ObjectHolder holder = (ObjectHolder)child;
                type.addInterceptorFactory((InterceptorFactory)holder.obj);
            }
        });
    }

    public void createDomainType(SchemaBinding binding) {
    }

    public void createIntroductionType(SchemaBinding binding) {
        TypeBinding introductionType = binding.getType(introductionTypeQName);
        introductionType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new InterfaceIntroduction();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                InterfaceIntroduction introduction = (InterfaceIntroduction)o;
                introduction.setMixins(new ArrayList());
                String name = null;
                String classExpr = null;
                String exp = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if ("name".equals(localName)) {
                        name = attrs.getValue(i);
                        continue;
                    }
                    if ("class".equals(localName)) {
                        classExpr = attrs.getValue(i);
                        continue;
                    }
                    if (!"expr".equals(localName)) continue;
                    exp = attrs.getValue(i);
                }
                if ("".equals(name)) {
                    name = null;
                }
                if ("".equals(classExpr)) {
                    classExpr = null;
                }
                if ("".equals(exp)) {
                    exp = null;
                }
                if (name == null) {
                    name = DeploymentInfo.getDeployment().generateName();
                }
                introduction.setName(name);
                if (classExpr != null) {
                    introduction.setClassExpression(classExpr);
                } else if (exp != null) {
                    introduction.setTypeExpression(exp);
                }
                DeploymentInfo.getDeployment().getCurrentManager().addInterfaceIntroduction(introduction);
            }
        });
        introductionType.pushInterceptor(mixinQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName qName) {
                InterfaceIntroduction introduction = (InterfaceIntroduction)parent;
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)child;
                introduction.getMixins().add(mixin);
            }
        });
        introductionType.pushInterceptor(interfacesQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName qName) {
                InterfaceIntroduction introduction = (InterfaceIntroduction)parent;
                String intfs = (String)child;
                StringTokenizer tokens = new StringTokenizer(intfs, ",");
                ArrayList<String> list = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken().trim());
                }
                String[] interfaces = list.toArray(new String[list.size()]);
                introduction.setInterfaces(interfaces);
            }
        });
        TypeBinding mixinType = binding.getType(mixinTypeQName);
        mixinType.setHandler((ParticleHandler)new DefaultElementHandler(){

            public Object startElement(Object parent, QName name, ElementBinding element) {
                return new InterfaceIntroduction.Mixin();
            }

            public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)o;
                boolean isTransient = true;
                String trans = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String localName = attrs.getLocalName(i);
                    if (!"transient".equals(localName)) continue;
                    trans = attrs.getValue(i);
                }
                if ("".equals(trans)) {
                    trans = null;
                }
                if (trans != null) {
                    isTransient = new Boolean(trans);
                }
                mixin.setTrans(isTransient);
            }
        });
        mixinType.pushInterceptor(classQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName qName) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)parent;
                mixin.setClassname((String)child);
            }
        });
        mixinType.pushInterceptor(constructionQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName qName) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)parent;
                mixin.setConstruction((String)child);
            }
        });
        mixinType.pushInterceptor(interfacesQName, (ElementInterceptor)new DefaultElementInterceptor(){

            public void add(Object parent, Object child, QName qName) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)parent;
                String intfs = (String)child;
                StringTokenizer tokens = new StringTokenizer(intfs, ",");
                ArrayList<String> list = new ArrayList<String>();
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken().trim());
                }
                String[] interfaces = list.toArray(new String[list.size()]);
                mixin.setInterfaces(interfaces);
            }
        });
    }

    public void createMetadataLoaderType(SchemaBinding binding) {
    }

    public void createMetadataType(SchemaBinding binding) {
    }

    public void createStackType(SchemaBinding binding) {
    }

    public void createPointcutType(SchemaBinding binding) {
    }

    public void createPluggablePointcutType(SchemaBinding binding) {
    }

    public void createPrepareType(SchemaBinding binding) {
    }

    public void createCflowStackType(SchemaBinding binding) {
    }

    public void createDynamicCflowType(SchemaBinding binding) {
    }

    public void createAnnotationType(SchemaBinding binding) {
    }

    public void createAnnotationIntroductionType(SchemaBinding binding) {
    }

    public void createTypedefType(SchemaBinding binding) {
    }

    protected static class ObjectHolder {
        public Object obj;

        protected ObjectHolder() {
        }
    }

    protected static class AspectElementHandler
    extends DefaultElementHandler {
        protected AspectElementHandler() {
        }

        public Object startElement(Object parent, QName name, ElementBinding element) {
            return new AspectDefinition();
        }

        public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx) {
            AspectDefinition def = (AspectDefinition)o;
            String name = null;
            String scopeString = "PER_VM";
            String clazz = null;
            String factory = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String localName = attrs.getLocalName(i);
                if ("name".equals(localName)) {
                    name = attrs.getValue(i);
                    continue;
                }
                if ("scope".equals(localName)) {
                    scopeString = attrs.getValue(i);
                    continue;
                }
                if ("class".equals(localName)) {
                    clazz = attrs.getValue(i);
                    continue;
                }
                if (!"factory".equals(localName)) continue;
                factory = attrs.getValue(i);
            }
            if ("".equals(name)) {
                name = null;
            }
            if ("".equals(scopeString)) {
                scopeString = "PER_VM";
            }
            Scope scope = ScopeUtil.parse((String)scopeString);
            def.setScope(scope);
            if (clazz != null && !clazz.equals("")) {
                if (name == null || name.equals("")) {
                    name = clazz;
                }
                def.setFactory((AspectFactory)new SimpleAspectFactory(clazz, name));
            } else if (factory != null && !factory.equals("")) {
                if (name == null || name.equals("")) {
                    name = factory;
                }
                def.setFactory((AspectFactory)new DelegatingAspectFactory(factory, name));
            }
            def.setName(name);
        }
    }

    protected static class NotImplemented
    extends DefaultElementHandler {
        protected String elementName;

        public NotImplemented(String elementName) {
            this.elementName = elementName;
        }

        public Object startElement(Object parent, QName name, ElementBinding element) {
            throw new RuntimeException("<" + this.elementName + "> is not yet supported");
        }
    }

    protected static class AspectFactoryElementInterceptor
    extends DefaultElementInterceptor {
        protected AspectFactoryElementInterceptor() {
        }

        public void add(Object parent, Object child, QName qName) {
            AspectDefinition def = (AspectDefinition)parent;
            AbstractBeanMetaData bmd = (AbstractBeanMetaData)child;
            Kernel kernel = DeploymentInfo.getDeployment().getKernel();
            KernelAspectFactory factory = new KernelAspectFactory(kernel, def.getName());
            def.setFactory((AspectFactory)factory);
            bmd.setName(def.getName());
            KernelController controller = kernel.getController();
            try {
                controller.install((BeanMetaData)bmd);
            }
            catch (Throwable throwable) {
                new RuntimeException(throwable);
            }
        }
    }

    protected static class AspectConfigElementInterceptor
    extends DefaultElementInterceptor {
        protected AspectConfigElementInterceptor() {
        }

        public void add(Object parent, Object child, QName qName) {
            AspectDefinition def = (AspectDefinition)parent;
            AbstractBeanMetaData bmd = (AbstractBeanMetaData)child;
            bmd.setName(def.getName());
            Kernel kernel = DeploymentInfo.getDeployment().getKernel();
            GenericKernelAspectFactory factory = new GenericKernelAspectFactory(kernel, def.getName());
            def.setFactory((AspectFactory)factory);
            KernelController controller = kernel.getController();
            try {
                controller.install((BeanMetaData)bmd);
            }
            catch (Throwable throwable) {
                new RuntimeException(throwable);
            }
        }
    }

    private static class InterceptorElementInterceptor
    extends DefaultElementInterceptor {
        private InterceptorElementInterceptor() {
        }

        public void add(Object parent, Object child, QName name) {
            AspectManager type = (AspectManager)parent;
            AspectDefinition def = (AspectDefinition)child;
            type.addAspectDefinition(def);
            ScopedInterceptorFactory factory = new ScopedInterceptorFactory(def);
            type.addInterceptorFactory(def.getName(), (InterceptorFactory)factory);
        }
    }

    private static class AspectElementInterceptor
    extends DefaultElementInterceptor {
        private AspectElementInterceptor() {
        }

        public void add(Object parent, Object child, QName name) {
            AspectManager type = (AspectManager)parent;
            AspectDefinition def = (AspectDefinition)child;
            type.addAspectDefinition(def);
        }
    }
}

