/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.AnnotationDefaultAttribute;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import org.jboss.aop.AOPClassPool;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassLoaderValidation;
import org.jboss.aspects.kernel.MemberValueMapper;
import org.jboss.reflect.plugins.AnnotationAttributeImpl;
import org.jboss.reflect.plugins.AnnotationInfoImpl;
import org.jboss.reflect.plugins.AnnotationValueImpl;
import org.jboss.reflect.plugins.ArrayInfoImpl;
import org.jboss.reflect.plugins.ClassInfoImpl;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.EnumConstantInfoImpl;
import org.jboss.reflect.plugins.EnumInfoImpl;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.InterfaceInfoImpl;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.PrimitiveInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.Value;

public class ClassInfoPool {
    private static HashMap classInfos = new HashMap();
    public static ClassLoaderValidation classLoaderValidator = null;
    public static ClassInfo STRING;
    public static ClassInfo OBJECT;
    public static ClassInfo CLASS;
    private ClassLoader loader;
    private HashMap infoCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfoPool getPool(ClassLoader loader) {
        HashMap hashMap = classInfos;
        synchronized (hashMap) {
            ClassInfoPool.clearUnloadedClassLoaders();
            ClassInfoPool pool = (ClassInfoPool)classInfos.get(loader);
            if (pool != null) {
                return pool;
            }
            pool = new ClassInfoPool(loader);
            classInfos.put(loader, pool);
            return pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearUnloadedClassLoaders() {
        if (classLoaderValidator == null) {
            return;
        }
        HashMap hashMap = classInfos;
        synchronized (hashMap) {
            Iterator it = classInfos.keySet().iterator();
            while (it.hasNext()) {
                ClassLoader loader = (ClassLoader)it.next();
                if (classLoaderValidator.isValidClassLoader(loader)) continue;
                it.remove();
            }
        }
    }

    public ClassInfoPool(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassPool getClassPool() {
        return AspectManager.instance().findClassPool(this.loader);
    }

    public ClassInfoImpl getClassInfo(String classname) throws Exception {
        ClassInfoImpl info = (ClassInfoImpl)this.infoCache.get(classname);
        if (info != null) {
            return info;
        }
        ClassPool pool = this.getClassPool();
        CtClass clazz = pool.get(classname);
        Query query = new Query();
        info = query.fetchClassInfo(clazz);
        this.infoCache.put(info.getName(), info);
        return info;
    }

    public ClassInfoImpl getClassInfo(String classname, Map queryCache) throws Exception {
        ClassInfoImpl info = (ClassInfoImpl)this.infoCache.get(classname);
        if (info != null) {
            return info;
        }
        ClassPool pool = this.getClassPool();
        CtClass clazz = pool.get(classname);
        Query query = new Query(queryCache);
        info = query.fetchClassInfo(clazz);
        queryCache.put(info.getName(), info);
        return info;
    }

    static {
        ClassInfoPool pool = ClassInfoPool.getPool(Class.class.getClassLoader());
        try {
            OBJECT = pool.getClassInfo("java.lang.Object");
            STRING = pool.getClassInfo("java.lang.String");
            CLASS = pool.getClassInfo("java.lang.Class");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class Query {
        private Map queryCache;

        public Query(Map queryCache) {
            this.queryCache = queryCache;
        }

        public Query() {
            this.queryCache = new HashMap();
        }

        TypeInfo getTypeInfo(CtClass clazz) throws Exception {
            if (clazz.isPrimitive()) {
                return PrimitiveInfo.valueOf((String)clazz.getName());
            }
            if (clazz.isArray()) {
                TypeInfo componentType = this.getTypeInfo(clazz.getComponentType());
                return new ArrayInfoImpl(componentType);
            }
            return this.getClassInfo(clazz);
        }

        private ClassInfoImpl getClassInfo(CtClass clazz) throws Exception {
            if (this.queryCache.containsKey(clazz.getName())) {
                return (ClassInfoImpl)this.queryCache.get(clazz.getName());
            }
            if (clazz.getClassPool() instanceof AOPClassPool) {
                AOPClassPool aopPool = (AOPClassPool)clazz.getClassPool();
                return ClassInfoPool.getPool(aopPool.getClassLoader()).getClassInfo(clazz.getName(), this.queryCache);
            }
            return ClassInfoPool.getPool((class$java$lang$Class == null ? (class$java$lang$Class = ClassInfoPool.class$("java.lang.Class")) : class$java$lang$Class).getClassLoader()).getClassInfo(clazz.getName(), this.queryCache);
        }

        ClassInfo getClassFromPools(String classname) throws Exception {
            CtClass clazz = ClassInfoPool.this.getClassPool().get(classname);
            return this.getClassInfo(clazz);
        }

        ClassInfoImpl fetchClassInfo(CtClass clazz) throws Exception {
            if ((clazz.getModifiers() & 0x2000) != 0) {
                return this.loadAnnotationInfo(clazz);
            }
            if (clazz.isInterface()) {
                return this.loadInterfaceInfo(clazz);
            }
            if ((clazz.getModifiers() & 0x4000) != 0 || clazz.getSuperclass() != null && clazz.getSuperclass().getName().equals("org.jboss.lang.Enum")) {
                return this.loadEnumInfo(clazz);
            }
            ClassInfoImpl info = this.loadClassInfo(clazz);
            return info;
        }

        private AnnotationInfoImpl loadAnnotationInfo(CtClass clazz) throws Exception {
            AnnotationInfoImpl info = new AnnotationInfoImpl(clazz.getName(), clazz.getModifiers());
            this.queryCache.put(clazz.getName(), info);
            ClassFile cf = clazz.getClassFile2();
            MethodInfoImpl[] methods = null;
            CtMethod[] ctMethods = clazz.getDeclaredMethods();
            AnnotationAttributeImpl[] attributes = new AnnotationAttributeImpl[ctMethods.length];
            if (ctMethods != null && ctMethods.length > 0) {
                methods = new MethodInfoImpl[ctMethods.length];
                for (int i = 0; i < methods.length; ++i) {
                    methods[i] = this.loadMethodInfo(ctMethods[i], (ClassInfo)info);
                    AnnotationDefaultAttribute adf = (AnnotationDefaultAttribute)ctMethods[i].getMethodInfo().getAttribute("AnnotationDefault");
                    Value defaultValue = null;
                    if (adf != null) {
                        MemberValueMapper mapper = new MemberValueMapper(this, methods[i].getReturnType());
                        adf.getDefaultValue().accept((MemberValueVisitor)mapper);
                        defaultValue = mapper.value;
                    }
                    attributes[i] = new AnnotationAttributeImpl(methods[i].getName(), methods[i].getReturnType(), defaultValue);
                }
            }
            info.setDeclaredMethods(methods);
            info.setAttributes(attributes);
            AnnotationValue[] annotations = null;
            if (cf != null) {
                annotations = this.getAnnotations(cf.getAttribute("RuntimeInvisibleAnnotations"), cf.getAttribute("RuntimeVisibleAnnotations"));
            }
            info.setupAnnotations(annotations);
            return info;
        }

        private EnumInfoImpl loadEnumInfo(CtClass clazz) throws Exception {
            EnumInfoImpl info = new EnumInfoImpl(clazz.getName(), clazz.getModifiers());
            this.queryCache.put(clazz.getName(), info);
            ArrayList<EnumConstantInfoImpl> consts = new ArrayList<EnumConstantInfoImpl>();
            CtField[] ctFields = clazz.getDeclaredFields();
            if (ctFields != null & ctFields.length > 0) {
                for (int i = 0; i < ctFields.length; ++i) {
                    if (!ctFields[i].getType().getName().equals(clazz.getName())) continue;
                    EnumConstantInfoImpl constant = new EnumConstantInfoImpl(ctFields[i].getName(), (EnumInfo)info);
                    consts.add(constant);
                }
            }
            EnumConstantInfoImpl[] constants = consts.toArray(new EnumConstantInfoImpl[consts.size()]);
            info.setEnumConstants(constants);
            return info;
        }

        private InterfaceInfoImpl loadInterfaceInfo(CtClass clazz) throws Exception {
            InterfaceInfo[] interfaces = this.extractInterfaces(clazz);
            ClassFile cf = clazz.getClassFile2();
            InterfaceInfoImpl info = new InterfaceInfoImpl(clazz.getName(), clazz.getModifiers(), interfaces);
            this.queryCache.put(clazz.getName(), info);
            AnnotationValue[] annotations = null;
            if (cf != null) {
                annotations = this.getAnnotations(cf.getAttribute("RuntimeInvisibleAnnotations"), cf.getAttribute("RuntimeVisibleAnnotations"));
            }
            info.setupAnnotations(annotations);
            MethodInfoImpl[] methods = this.extractMethods(clazz, (ClassInfo)info);
            FieldInfoImpl[] fields = this.extractFields(clazz, (ClassInfo)info);
            info.setDeclaredMethods(methods);
            info.setDeclaredFields(fields);
            return info;
        }

        AnnotationValue getAnnotation(Annotation annotation) throws Exception {
            CtClass annotationClass = ClassInfoPool.this.getClassPool().get(annotation.getTypeName());
            AnnotationInfo annotationInfo = null;
            try {
                annotationInfo = (AnnotationInfo)this.getClassInfo(annotationClass);
                if (annotationInfo == null) {
                    throw new RuntimeException("annotationInfo was null: " + annotationClass.getName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(" failed on " + annotation.getTypeName(), e);
            }
            HashMap<String, Value> map = new HashMap<String, Value>();
            if (annotation.getMemberNames() != null) {
                Iterator it = annotation.getMemberNames().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    MemberValue mv = annotation.getMemberValue(name);
                    try {
                        MemberValueMapper mapper = new MemberValueMapper(this, annotationInfo.getAttribute(name).getType());
                        mv.accept((MemberValueVisitor)mapper);
                        map.put(name, mapper.value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("failed to get name from: " + annotationInfo.getName() + " of attribute " + name, e);
                    }
                }
            }
            return new AnnotationValueImpl(annotationInfo, map);
        }

        private AnnotationValue[] getAnnotations(AttributeInfo invis, AttributeInfo vis) throws Exception {
            int i;
            AnnotationsAttribute invisible = (AnnotationsAttribute)invis;
            AnnotationsAttribute visible = (AnnotationsAttribute)vis;
            ArrayList<AnnotationValue> values = new ArrayList<AnnotationValue>();
            Annotation[] annotations = null;
            if (invisible != null) {
                annotations = invisible.getAnnotations();
                for (i = 0; i < annotations.length; ++i) {
                    values.add(this.getAnnotation(annotations[i]));
                }
            }
            if (visible != null) {
                annotations = visible.getAnnotations();
                for (i = 0; i < annotations.length; ++i) {
                    values.add(this.getAnnotation(annotations[i]));
                }
            }
            return values.toArray(new AnnotationValue[values.size()]);
        }

        private FieldInfoImpl loadFieldInfo(CtField ctField, ClassInfo declaring) throws Exception {
            Object type = null;
            type = declaring.getName().equals(ctField.getType().getName()) ? declaring : this.getClassInfo(ctField.getType());
            AnnotationValue[] annotations = this.getAnnotations(ctField.getFieldInfo().getAttribute("RuntimeInvisibleAnnotations"), ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations"));
            return new FieldInfoImpl(annotations, ctField.getName(), (TypeInfo)type, ctField.getModifiers(), declaring);
        }

        private FieldInfoImpl[] extractFields(CtClass clazz, ClassInfo declaring) throws Exception {
            FieldInfoImpl[] fields = null;
            CtField[] ctFields = clazz.getDeclaredFields();
            if (ctFields != null & ctFields.length > 0) {
                fields = new FieldInfoImpl[ctFields.length];
                for (int i = 0; i < ctFields.length; ++i) {
                    fields[i] = this.loadFieldInfo(ctFields[i], declaring);
                }
            }
            return fields;
        }

        private MethodInfoImpl[] extractMethods(CtClass clazz, ClassInfo declaring) throws Exception {
            MethodInfoImpl[] methods = null;
            CtMethod[] ctMethods = clazz.getDeclaredMethods();
            if (ctMethods != null && ctMethods.length > 0) {
                methods = new MethodInfoImpl[ctMethods.length];
                for (int i = 0; i < methods.length; ++i) {
                    methods[i] = this.loadMethodInfo(ctMethods[i], declaring);
                }
            }
            return methods;
        }

        private MethodInfoImpl loadMethodInfo(CtMethod ctMethod, ClassInfo declaring) throws Exception {
            CtClass[] ctParams = ctMethod.getParameterTypes();
            TypeInfo[] params = new TypeInfo[ctParams.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = ctParams[i].getName().equals(declaring.getName()) ? declaring : this.getTypeInfo(ctParams[i]);
            }
            CtClass[] ctExceptions = ctMethod.getExceptionTypes();
            ClassInfo[] exceptions = new ClassInfo[ctExceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = this.getClassInfo(ctExceptions[i]);
            }
            AnnotationValue[] annotations = this.getAnnotations(ctMethod.getMethodInfo().getAttribute("RuntimeInvisibleAnnotations"), ctMethod.getMethodInfo().getAttribute("RuntimeVisibleAnnotations"));
            TypeInfo returnType = this.getTypeInfo(ctMethod.getReturnType());
            try {
                return new MethodInfoImpl(annotations, ctMethod.getName(), returnType, params, exceptions, ctMethod.getModifiers(), declaring);
            }
            catch (Exception e) {
                throw new RuntimeException("failed to create method: " + ctMethod.getName() + " of declaring: " + declaring.getName(), e);
            }
        }

        private ConstructorInfoImpl[] extractConstructors(CtClass clazz, ClassInfo declaring) throws Exception {
            ConstructorInfoImpl[] cons = null;
            CtConstructor[] ctCons = clazz.getDeclaredConstructors();
            if (ctCons != null && ctCons.length > 0) {
                cons = new ConstructorInfoImpl[ctCons.length];
                for (int i = 0; i < cons.length; ++i) {
                    cons[i] = this.loadConstructorInfo(ctCons[i], declaring);
                }
            }
            return cons;
        }

        private ConstructorInfoImpl loadConstructorInfo(CtConstructor ctCon, ClassInfo declaring) throws Exception {
            CtClass[] ctParams = ctCon.getParameterTypes();
            TypeInfo[] params = new TypeInfo[ctParams.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = ctParams[i].getName().equals(declaring.getName()) ? declaring : this.getTypeInfo(ctParams[i]);
                if (params[i] != null) continue;
                throw new RuntimeException("PARAMS is NULL!" + ctParams[i].getName());
            }
            CtClass[] ctExceptions = ctCon.getExceptionTypes();
            ClassInfo[] exceptions = new ClassInfo[ctExceptions.length];
            for (int i = 0; i < exceptions.length; ++i) {
                exceptions[i] = this.getClassInfo(ctExceptions[i]);
            }
            AnnotationValue[] annotations = this.getAnnotations(ctCon.getMethodInfo().getAttribute("RuntimeInvisibleAnnotations"), ctCon.getMethodInfo().getAttribute("RuntimeVisibleAnnotations"));
            return new ConstructorInfoImpl(annotations, params, exceptions, ctCon.getModifiers(), declaring);
        }

        private InterfaceInfo[] extractInterfaces(CtClass clazz) throws Exception {
            InterfaceInfo[] interfaces = null;
            CtClass[] ctInterfaces = clazz.getInterfaces();
            if (ctInterfaces != null && ctInterfaces.length > 0) {
                interfaces = new InterfaceInfo[ctInterfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = (InterfaceInfo)this.getClassInfo(ctInterfaces[i]);
                }
            }
            return interfaces;
        }

        private ClassInfoImpl loadClassInfo(CtClass clazz) throws Exception {
            ClassInfoImpl superInfo = null;
            if (clazz.getSuperclass() != null) {
                superInfo = this.getClassInfo(clazz.getSuperclass());
            }
            InterfaceInfo[] interfaces = this.extractInterfaces(clazz);
            ClassFile cf = clazz.getClassFile2();
            ClassInfoImpl info = new ClassInfoImpl(clazz.getName(), clazz.getModifiers(), interfaces, superInfo);
            this.queryCache.put(clazz.getName(), info);
            AnnotationValue[] annotations = null;
            if (cf != null) {
                annotations = this.getAnnotations(cf.getAttribute("RuntimeInvisibleAnnotations"), cf.getAttribute("RuntimeVisibleAnnotations"));
            }
            info.setupAnnotations(annotations);
            MethodInfoImpl[] methods = this.extractMethods(clazz, (ClassInfo)info);
            FieldInfoImpl[] fields = this.extractFields(clazz, (ClassInfo)info);
            ConstructorInfoImpl[] cons = this.extractConstructors(clazz, (ClassInfo)info);
            info.setDeclaredFields(fields);
            info.setDeclaredMethods(methods);
            info.setDeclaredConstructors(cons);
            return info;
        }
    }
}

