/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.kernel;

import org.jboss.aop.AspectManager;
import org.jboss.aspects.kernel.AspectClassAdapter;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.classadapter.spi.ClassAdapterFactory;
import org.jboss.reflect.plugins.introspection.IntrospectionTypeInfoFactory;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;

public class AspectClassAdapterFactory
implements ClassAdapterFactory {
    protected TypeInfoFactory typeInfoFactory = new IntrospectionTypeInfoFactory();
    protected AspectManager manager;

    public AspectClassAdapterFactory(AspectManager manager) {
        this.manager = manager;
    }

    public ClassAdapter getClassAdapter(Class clazz) {
        return this.createClassAdapter(clazz);
    }

    public ClassAdapter getClassAdapter(String name, ClassLoader cl) throws ClassNotFoundException {
        Class<?> clazz = cl.loadClass(name);
        return this.createClassAdapter(clazz);
    }

    protected ClassAdapter createClassAdapter(Class clazz) {
        TypeInfo typeInfo = this.typeInfoFactory.getTypeInfo(clazz);
        if (!(typeInfo instanceof ClassInfo)) {
            throw new IllegalArgumentException("Not a class " + typeInfo.getName());
        }
        ClassInfo classInfo = (ClassInfo)typeInfo;
        if (classInfo.isInterface()) {
            throw new IllegalArgumentException("Interface not allowed " + typeInfo.getName());
        }
        return new AspectClassAdapter(this.manager, clazz, classInfo);
    }
}

