/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public abstract class AbstractFacesBean {
    private static final String DATA_KEY = "org.apache.shale.DATA";

    protected Application getApplication() {
        return FacesContext.getCurrentInstance().getApplication();
    }

    protected Map getApplicationMap() {
        return this.getExternalContext().getApplicationMap();
    }

    protected ExternalContext getExternalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Lifecycle getLifecycle() {
        String lifecycleId = this.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null || lifecycleId.length() == 0) {
            lifecycleId = "DEFAULT";
        }
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        return lifecycleFactory.getLifecycle(lifecycleId);
    }

    protected Map getRequestHeaderMap() {
        return this.getExternalContext().getRequestHeaderMap();
    }

    protected Map getRequestMap() {
        return this.getExternalContext().getRequestMap();
    }

    protected Map getRequestParameterMap() {
        return this.getExternalContext().getRequestParameterMap();
    }

    protected Map getSessionMap() {
        return this.getExternalContext().getSessionMap();
    }

    protected Object getBean(String name) {
        FacesContext context = this.getFacesContext();
        return context.getApplication().getVariableResolver().resolveVariable(context, name);
    }

    protected void setBean(String name, Object value) {
        this.setValue("#{" + name + "}", value);
    }

    protected Object getValue(String expr) {
        ValueBinding vb = this.getApplication().createValueBinding(expr);
        return vb.getValue(this.getFacesContext());
    }

    protected void setValue(String expr, Object value) {
        ValueBinding vb = this.getApplication().createValueBinding(expr);
        vb.setValue(this.getFacesContext(), value);
    }

    public Object retrieveData(String key) {
        FacesContext context = this.getFacesContext();
        if (context == null) {
            return null;
        }
        UIViewRoot view = context.getViewRoot();
        if (view == null) {
            return null;
        }
        Map map = (Map)view.getAttributes().get(DATA_KEY);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public void saveData(String key, Object data) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.getFacesContext().getViewRoot().getAttributes().get(DATA_KEY);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.getFacesContext().getViewRoot().getAttributes().put(DATA_KEY, map);
        }
        map.put(key, data);
    }

    protected void erase() {
        UIViewRoot view = this.getFacesContext().getViewRoot();
        if (view != null) {
            this.erase((UIComponent)view);
        }
    }

    private void erase(UIComponent component) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(null);
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.erase((UIComponent)kids.next());
        }
    }

    public String getRequestParameter(String name) {
        return (String)this.getExternalContext().getRequestParameterMap().get(name);
    }

    public String[] getRequestParameterValues(String name) {
        return (String[])this.getExternalContext().getRequestParameterValuesMap().get(name);
    }

    protected void log(String message) {
        FacesContext context = this.getFacesContext();
        ExternalContext econtext = null;
        if (context != null) {
            econtext = context.getExternalContext();
        }
        if (econtext != null) {
            econtext.log(message);
        } else {
            System.out.println(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        FacesContext context = this.getFacesContext();
        ExternalContext econtext = null;
        if (context != null) {
            econtext = context.getExternalContext();
        }
        if (econtext != null) {
            econtext.log(message, throwable);
        } else {
            System.out.println(message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void info(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null));
    }

    protected void info(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null));
    }

    protected void warn(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, summary, null));
    }

    protected void warn(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_WARN, summary, null));
    }

    protected void error(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null));
    }

    protected void error(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null));
    }

    protected void fatal(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, null));
    }

    protected void fatal(UIComponent component, String summary) {
        FacesContext context = this.getFacesContext();
        context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, null));
    }
}

