/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remote;

import java.io.IOException;
import java.io.Writer;

public class ResponseWrapper {
    private String encoding = null;
    private boolean open = false;
    private Writer writer = null;

    public ResponseWrapper(Writer writer) {
        this(writer, "ISO-8859-1");
    }

    public ResponseWrapper(Writer writer, String encoding) {
        this.writer = writer;
        this.encoding = encoding;
    }

    public void startDocument() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
    }

    public void startElement(String name) throws IOException {
        this.close();
        this.writer.write(60);
        this.writer.write(name);
        this.open = true;
    }

    public void writeAttribute(String name, Object value) throws IOException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        if (value instanceof String) {
            this.string(this.writer, (String)value);
        } else {
            this.string(this.writer, value.toString());
        }
        this.writer.write("\"");
    }

    public void writeURIAttribute(String name, Object value) throws IOException {
        this.writeAttribute(name, value);
    }

    public void writeComment(Object comment) throws IOException {
        this.close();
        this.writer.write("<!-- ");
        if (comment instanceof String) {
            this.writer.write((String)comment);
        } else {
            this.writer.write(comment.toString());
        }
        this.writer.write(" -->");
    }

    public void writeNewline() throws IOException {
        this.close();
        this.writer.write("\n");
    }

    public void writeText(Object text) throws IOException {
        this.close();
        if (text instanceof String) {
            this.string(this.writer, (String)text);
        } else {
            this.string(this.writer, text.toString());
        }
    }

    public void endElement(String name) throws IOException {
        if (this.open) {
            this.writer.write("/");
            this.close();
        } else {
            this.writer.write("</");
            this.writer.write(name);
            this.writer.write(">");
        }
    }

    public void endDocument() throws IOException {
        this.close();
        this.writer.flush();
    }

    private void close() throws IOException {
        if (this.open) {
            this.writer.write(">");
            this.open = false;
        }
    }

    private void numeric(Writer writer, char ch) throws IOException {
        writer.write("&#");
        writer.write(String.valueOf(ch));
        writer.write(";");
    }

    private void string(Writer writer, String s) throws IOException {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u00ff') {
                if (ch == '\"') {
                    writer.write("&quot;");
                    continue;
                }
                if (ch == '&') {
                    writer.write("&amp;");
                    continue;
                }
                if (ch == '\'') {
                    writer.write("&apos;");
                    continue;
                }
                if (ch == '<') {
                    writer.write("&lt;");
                    continue;
                }
                if (ch == '>') {
                    writer.write("&gt;");
                    continue;
                }
                writer.write(ch);
                continue;
            }
            if (this.substitution()) {
                this.numeric(writer, ch);
                continue;
            }
            writer.write(ch);
        }
    }

    private boolean substitution() {
        return !"UTF-8".equals(this.encoding) && !"UTF-16".equals(this.encoding);
    }
}

