/*
 * Decompiled with CFR 0.152.
 */
package net.sf.facestrace.scopes;

import java.util.Map;
import javax.faces.context.FacesContext;
import net.sf.facestrace.scopes.ApplicationScopeVariables;
import net.sf.facestrace.scopes.CookieVariables;
import net.sf.facestrace.scopes.HeaderVariables;
import net.sf.facestrace.scopes.ParamVariables;
import net.sf.facestrace.scopes.RequestScopeVariables;
import net.sf.facestrace.scopes.SessionScopeVariables;
import net.sf.facestrace.scopes.initParamVariables;
import net.sf.facestrace.utils.TraceUtils;

public class ScopeInitializer {
    public static void initializeScopes() {
        FacesContext fc = FacesContext.getCurrentInstance();
        ScopeInitializer.initializeApplicationScope(fc);
        ScopeInitializer.initializeCookies(fc);
        ScopeInitializer.initializeinitParam(fc);
        ScopeInitializer.initializeParam(fc);
        ScopeInitializer.initializeRequestScope(fc);
        ScopeInitializer.initializeSessionScope(fc);
        ScopeInitializer.initializeHeaderScope(fc);
    }

    private static void initializeHeaderScope(FacesContext fc) {
        Map headerMap = (Map)fc.getApplication().createValueBinding("#{header}").getValue(fc);
        HeaderVariables headerScope = new HeaderVariables();
        headerScope.initialize(headerMap);
        headerScope.setScopeName("Header");
        TraceUtils.getTraceData().setScope(6, headerScope);
    }

    private static void initializeApplicationScope(FacesContext fc) {
        Map appScopeMap = (Map)fc.getApplication().createValueBinding("#{applicationScope}").getValue(fc);
        ApplicationScopeVariables applicationScope = new ApplicationScopeVariables();
        applicationScope.initialize(appScopeMap);
        applicationScope.setScopeName("Application Scope");
        TraceUtils.getTraceData().setScope(0, applicationScope);
    }

    private static void initializeCookies(FacesContext fc) {
        Map cookieMap = (Map)fc.getApplication().createValueBinding("#{cookie}").getValue(fc);
        CookieVariables cookie = new CookieVariables();
        cookie.initialize(cookieMap);
        cookie.setScopeName("Cookie");
        TraceUtils.getTraceData().setScope(5, cookie);
    }

    private static void initializeinitParam(FacesContext fc) {
        Map initParamMap = (Map)fc.getApplication().createValueBinding("#{initParam}").getValue(fc);
        initParamVariables initParam = new initParamVariables();
        initParam.initialize(initParamMap);
        initParam.setScopeName("Init Param");
        TraceUtils.getTraceData().setScope(4, initParam);
    }

    private static void initializeParam(FacesContext fc) {
        Map paramMap = (Map)fc.getApplication().createValueBinding("#{param}").getValue(fc);
        ParamVariables param = new ParamVariables();
        param.initialize(paramMap);
        param.setScopeName("Param");
        TraceUtils.getTraceData().setScope(3, param);
    }

    private static void initializeRequestScope(FacesContext fc) {
        Map requestMap = (Map)fc.getApplication().createValueBinding("#{requestScope}").getValue(fc);
        RequestScopeVariables requestScope = new RequestScopeVariables();
        requestScope.initialize(requestMap);
        requestScope.setScopeName("Request Scope");
        TraceUtils.getTraceData().setScope(2, requestScope);
    }

    private static void initializeSessionScope(FacesContext fc) {
        Map sessionMap = (Map)fc.getApplication().createValueBinding("#{sessionScope}").getValue(fc);
        SessionScopeVariables sessionScope = new SessionScopeVariables();
        sessionScope.initialize(sessionMap);
        sessionScope.setScopeName("Session Scope");
        TraceUtils.getTraceData().setScope(1, sessionScope);
    }
}

