/*
 * Decompiled with CFR 0.152.
 */
package net.sf.facestrace.phase;

import javax.faces.event.PhaseId;
import net.sf.facestrace.utils.TraceUtils;

public class PhaseData {
    private long beginTime;
    private long endTime;
    private PhaseId phaseId;
    private String phaseName;
    private boolean executed;
    private boolean causedResponse;

    public PhaseData(PhaseId phaseId, String phaseName) {
        this.phaseId = phaseId;
        this.phaseName = phaseName;
        this.executed = false;
        this.causedResponse = false;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.setExecuted(true);
        this.endTime = endTime;
    }

    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(PhaseId phaseId) {
        this.phaseId = phaseId;
    }

    public long getTime() {
        long time = this.endTime - this.beginTime;
        if (time < 0L) {
            return TraceUtils.getCurrentTimeinMillis() - this.beginTime;
        }
        return time;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public void setExecuted(boolean executed) {
        this.executed = executed;
    }

    public boolean isCausedResponse() {
        return this.causedResponse;
    }

    public void setCausedResponse(boolean causedResponse) {
        this.causedResponse = causedResponse;
    }
}

