/*
 * Decompiled with CFR 0.152.
 */
package net.sf.facestrace.component;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import net.sf.facestrace.logging.TraceLogEvent;
import net.sf.facestrace.phase.PhaseData;
import net.sf.facestrace.scopes.ScopeInitializer;
import net.sf.facestrace.utils.TraceUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Trace
extends UIOutput {
    public static final String COMPONENT_TYPE = "net.sf.facestrace.component.Trace";
    public static final String COMPONENT_FAMILY = "net.sf.facestrace.component.Trace";
    private Log log;
    private Boolean showTree;
    static /* synthetic */ Class class$0;

    public Trace() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.facestrace.component.Trace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.setRendererType(null);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        ScopeInitializer.initializeScopes();
        ResponseWriter writer = facesContext.getResponseWriter();
        this.renderResourceIncludes(writer);
        this.renderTogglingJavaScript(writer);
        this.renderFacesTraceHeaderLabel(writer);
        this.renderPhaseTimes(writer);
        this.renderPhaseLifeCycle(writer);
        this.renderFacesMessages(facesContext);
        this.renderScopesHeader(writer);
        this.renderScopes(writer);
        this.renderLogs(writer);
        this.renderTree(facesContext, writer);
    }

    private void renderTogglingJavaScript(ResponseWriter writer) throws IOException {
        writer.write("<script> function toggle(field) {if( document.getElementById(field).style.display=='none' ){\tdocument.getElementById(field).style.display = ''; } else { \tdocument.getElementById(field).style.display = 'none';}} </script> ");
    }

    private void renderFacesMessages(FacesContext facesContext) throws IOException {
        if (facesContext.getClientIdsWithMessages().hasNext()) {
            ResponseWriter writer = facesContext.getResponseWriter();
            this.encodeMesageHeader(writer);
            int i = 0;
            Iterator clientIDIterator = facesContext.getClientIdsWithMessages();
            while (clientIDIterator.hasNext()) {
                String clientID = (String)clientIDIterator.next();
                facesContext.getMessages(clientID);
                Iterator messageIterator = facesContext.getMessages(clientID);
                while (messageIterator.hasNext()) {
                    FacesMessage message = (FacesMessage)messageIterator.next();
                    this.renderFacesMessage(writer, clientID, message, "" + (i % 2 + 1));
                    ++i;
                }
            }
            writer.write(" </tbody></TD></TR>");
        }
    }

    private void encodeMesageHeader(ResponseWriter writer) throws IOException {
        writer.write("<TR bgcolor=\"black\"><TD onclick=\"toggle('tbody_message');\" height=\"10\" align=\"left\" colspan=\"3\">");
        writer.write("<span class=\"tableHeaderLabel\">ERROR MESSAGES</span></TD></TR>");
        writer.write("<tbody id=\"tbody_message\">");
        writer.write("<TR class=\"tableHeaderRow\">");
        writer.write("<TD class= \"tableScopeHeaderColumn1\" >");
        writer.write("<span class=\"tableHeaderLabel\">Component ID</span></TD>");
        writer.write("<TD class= \"tableScopeHeaderColumn2\" >");
        writer.write("<span class=\"tableHeaderLabel\">Severity</span></TD>");
        writer.write("<TD height=\"29\" align=\"center\">");
        writer.write("<span class=\"tableHeaderLabel\">Message</span></TD>");
        writer.write("</TR>");
    }

    private void renderFacesMessage(ResponseWriter writer, String clientID, FacesMessage message, String rowNo) throws IOException {
        writer.write("<TR class=\"tableDataRow" + rowNo + "\">");
        writer.write("<TD class=\"tableScopeHeaderColumn1\" >");
        writer.write("<span class=\"tablePhaseLabels\" >" + clientID + "</span></TD>");
        writer.write("<TD align=\"center\" width=\"178\" height=\"20\"><span class=\"tableLabels\" >" + this.getErrorSeverityByCompare(message.getSeverity()) + "</span></TD>");
        writer.write("<TD align=\"left\" height=\"20\"><span class=\"tableLabels\" >" + message.getDetail() + "</span></TD></TR>");
    }

    private String getErrorSeverityByCompare(FacesMessage.Severity severity) {
        if (severity == FacesMessage.SEVERITY_ERROR) {
            return "ERROR";
        }
        if (severity == FacesMessage.SEVERITY_FATAL) {
            return "FATAL";
        }
        if (severity == FacesMessage.SEVERITY_INFO) {
            return "INFO";
        }
        if (severity == FacesMessage.SEVERITY_WARN) {
            return "WARN";
        }
        return "";
    }

    private void renderResourceIncludes(ResponseWriter writer) throws IOException {
        this.renderScriptInclude(writer);
        this.renderFacesStyleInclude(writer);
    }

    private void renderLogs(ResponseWriter writer) throws IOException {
        List logs = TraceUtils.getTraceData().getLogs();
        writer.write("<TR bgcolor=\"black\"><TD height=\"10\" align=\"left\" colspan=\"3\" onclick=\"toggle('tbody_logs');\">");
        writer.write("<span class=\"tableHeaderLabel\">LOGS</span></TD></TR>");
        writer.write("<tbody id=\"tbody_logs\">");
        writer.write("<TR class=\"tableHeaderRow\">");
        writer.write("<TD class= \"tableScopeHeaderColumn1\" >");
        writer.write("<span class=\"tableHeaderLabel\">Name</span></TD>");
        writer.write("<TD class= \"tableScopeHeaderColumn2\" >");
        writer.write("<span class=\"tableHeaderLabel\">Type</span></TD>");
        writer.write("<TD height=\"29\" align=\"center\">");
        writer.write("<span class=\"tableHeaderLabel\">Message</span></TD>");
        writer.write("</TR>");
        int i = 0;
        while (i < logs.size()) {
            TraceLogEvent logEvent = (TraceLogEvent)logs.get(i);
            this.renderLogEvent(writer, logEvent, "" + (i % 2 + 1));
            ++i;
        }
        writer.write(" </tbody></TD></TR>");
    }

    private void renderLogEvent(ResponseWriter writer, TraceLogEvent logEvent, String rowNo) throws IOException {
        writer.write("<TR class=\"tableDataRow" + rowNo + "\">");
        writer.write("<TD class=\"tableScopeHeaderColumn1\" >");
        writer.write("<span class=\"tablePhaseLabels\" >" + logEvent.getName() + "</span></TD>");
        writer.write("<TD align=\"center\" width=\"178\" height=\"20\"><span class=\"tableLabels\" >" + logEvent.getType() + "</span></TD>");
        writer.write("<TD align=\"left\" height=\"20\"><span class=\"tableLabels\" >" + logEvent.getMessage() + "</span></TD></TR>");
    }

    private void renderSectionHeader(ResponseWriter writer, String sectionName) throws IOException {
        writer.write("<TR><TD height=\"30px\" align=\"center\" colspan=\"3\">");
        this.renderStartTableTag(writer, "border=\"1\" width=\"100%\" height=\"10%\"");
        writer.write("<TR class=\"tableHeaderRow\">");
        writer.write("<TD class=\"tableTreeHeader\">");
        writer.write("<span class=\"tableHeaderLabel\" >" + sectionName + "</span>");
        writer.write("</TD></TR>");
    }

    private void renderTree(FacesContext facesContext, ResponseWriter writer) throws IOException {
        this.renderSectionHeader(writer, "COMPONENT TREE");
        writer.write("<TR class=\"tableDataRow1\" ><TD>");
        this.renderComponentTree(facesContext);
        writer.write("</TD></TR>");
        this.renderEndTableTag(writer);
        writer.write("</TD></TR>");
        this.renderEndTableTag(writer);
    }

    private void renderScopes(ResponseWriter writer) throws IOException {
        int i = 0;
        while (i < TraceUtils.getTraceData().getScopes().length) {
            String rowNo = "" + (i % 2 + 1);
            this.renderScope(writer, i, rowNo);
            ++i;
        }
        writer.write("</tbody>\n");
    }

    private void renderScope(ResponseWriter writer, int i, String rowNo) throws IOException {
        int mapSize = TraceUtils.getTraceData().getScopes()[i].getVariableMap().size();
        Map map = TraceUtils.getTraceData().getScopes()[i].getVariableMap();
        this.renderScopeNamePart(writer, i, rowNo, mapSize);
        if (mapSize == 0) {
            writer.write("<TD width=\"178\" ></TD><TD height=\"20\"></TD></TR>");
        } else {
            int count = 0;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                String value = "";
                if (map.get(key) != null) {
                    value = map.get(key).toString();
                }
                if (count == 0) {
                    writer.write("<TD align=\"center\" width=\"178\" height=\"20\"><span class=\"tableLabels\" >" + key.toString() + "</span></TD>");
                    writer.write("<TD align=\"left\" height=\"20\"><span class=\"tableLabels\" >" + value + "</span></TD></TR>");
                    ++count;
                    continue;
                }
                writer.write("<TR class=\"tableDataRow" + rowNo + "\">");
                writer.write("<TD align=\"center\" width=\"178\" height=\"20\"><span class=\"tableLabels\" >" + key.toString() + "</span></TD>");
                writer.write("<TD align=\"left\" height=\"20\"><span class=\"tableLabels\" >" + value + "</span></TD></TR>");
            }
        }
    }

    private void renderScopeNamePart(ResponseWriter writer, int i, String rowNo, int mapSize) throws IOException {
        writer.write("<TR class=\"tableDataRow" + rowNo + "\">");
        if (mapSize == 0) {
            writer.write("<TD class=\"tableScopeHeaderColumn1\" >");
        } else {
            writer.write("<TD class=\"tableScopeHeaderColumn1\" rowspan=\"" + mapSize + "\" >");
        }
        writer.write("<span class=\"tablePhaseLabels\" >" + TraceUtils.getTraceData().getScopes()[i].getScopeName() + "</span></TD>\n");
    }

    private void renderScopesHeader(ResponseWriter writer) throws IOException {
        writer.write("<TR bgcolor=\"black\"><TD height=\"10\" align=\"left\" colspan=\"3\" onclick=\"toggle('tbody_scopes');\">");
        writer.write("<span class=\"tableHeaderLabel\">SCOPE VARIABLES</span></TD></TR>");
        writer.write("<tbody id=\"tbody_scopes\">");
        writer.write("<TR class=\"tableHeaderRow\">");
        writer.write("<TD class= \"tableScopeHeaderColumn1\"   >");
        writer.write("<span class=\"tableHeaderLabel\"> SCOPE </span></TD>");
        writer.write("<TD class= \"tableScopeHeaderColumn2\" >");
        writer.write("<span class=\"tableHeaderLabel\">KEY</span></TD>");
        writer.write("<TD height=\"2\" align=\"center\" >");
        writer.write("<span class=\"tableHeaderLabel\">VALUE</span></TD>");
        writer.write("</TR>");
    }

    private void renderPhaseLifeCycle(ResponseWriter writer) throws IOException {
        writer.write("<TD colspan=\"2\" nowrap width=\"%100\" >");
        this.renderStartTableTag(writer, "border=\"1\" width=\"100%\" height=\"100%\" ");
        writer.write("<TR class=\"tableHeaderRow\" width=\"%100\">");
        writer.write("<TD align=\"center\" width=\"%100\" onclick=\"toggle('tbody_phases1');toggle('tbody_phases2');\">");
        writer.write("<span class=\"tableHeaderLabel\" >REQUEST LIFECYCLE</span></TD>");
        writer.write("</TR>");
        writer.write("<tbody id=\"tbody_phases2\">");
        writer.write("<TR class=\"tableDataRow1\" ><TD height=\"159\">");
        this.renderLifeCycle(writer);
        writer.write("</TD></TR>");
        writer.write("</tbody>");
        this.renderEndTableTag(writer);
        writer.write("</TD></TR>");
    }

    private void renderPhaseTimes(ResponseWriter writer) throws IOException {
        this.renderPhaseTableHeader(writer);
        writer.write("<tbody id=\"tbody_phases1\">");
        int i = 0;
        while (i < TraceUtils.getTraceData().getPhases().length) {
            String rowNo = "" + (i % 2 + 1);
            this.renderPhaseAndTime(writer, i, rowNo);
            ++i;
        }
        writer.write("</tbody>");
        this.renderEndTableTag(writer);
        writer.write("</TD>");
    }

    private void renderPhaseAndTime(ResponseWriter writer, int i, String rowNo) throws IOException {
        writer.write("<TR class=\"tableDataRow" + rowNo + "\">");
        writer.write("<TD class=\"tablePhaseHeaderColumn1\" >");
        writer.write("<span class=\"tablePhaseLabels\" >" + TraceUtils.getTraceData().getPhases()[i].getPhaseName() + "</span></TD>");
        writer.write("<TD class=\"tablePhaseHeaderColumn2\" >");
        writer.write("<span class=\"tablePhaseLabels\" >" + TraceUtils.getTraceData().getPhases()[i].getTime() + " msec</span></TD>");
        writer.write("</TD></TR>");
    }

    private void renderPhaseTableHeader(ResponseWriter writer) throws IOException {
        writer.write("<TR><TD height=\"1\" width=\"375\">");
        this.renderStartTableTag(writer, "border=\"1\" width=\"100%\" height=\"100%\"");
        writer.write("<TR class= \"tableHeaderRow\">");
        writer.write("<TD class= \"tablePhaseHeaderColumn1\" onclick=\"toggle('tbody_phases1');toggle('tbody_phases2');\">");
        writer.write("<span class=\"tableHeaderLabel\">PHASE</span></TD>");
        writer.write("<TD class= \"tablePhaseHeaderColumn2\" onclick=\"toggle('tbody_phases1');toggle('tbody_phases2');\">");
        writer.write("<span class=\"tableHeaderLabel\">PROCESS TIME</span></TD>");
        writer.write("</TD></TR>");
    }

    private void renderEndTableTag(ResponseWriter writer) throws IOException {
        writer.write("</TBODY></TABLE>");
    }

    private void renderFacesTraceHeaderLabel(ResponseWriter writer) throws IOException {
        this.renderStartTableTag(writer, " border=\"1\" cellpadding=\"1\" cellspacing=\"1\" class=\"mainTable\"");
        writer.write("<TR  class = \"headerRow\" >");
        writer.write("<TD colspan=3 class=\"headerColumn\" >");
        writer.write("<span class=\"headerLabel\">Faces Trace v0.8.1</span>");
        writer.write("</TD></TR>");
    }

    private void renderStartTableTag(ResponseWriter writer, String properties) throws IOException {
        writer.write("<TABLE " + properties + " >");
        writer.write("<TBODY>");
    }

    private void renderComponentTree(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        UIViewRoot root = facesContext.getViewRoot();
        if (root == null) {
            return;
        }
        writer.write("<font face=\"Comic Sans MS\">");
        writer.write("\n<ul>\n");
        this.renderComponent((UIComponent)root, writer);
        writer.write("</ul>\n");
        writer.write("</font>\n");
    }

    private void renderComponent(UIComponent component, ResponseWriter writer) throws IOException {
        this.renderComponentInfo(component, writer);
        if (component.getChildCount() > 0) {
            this.renderChildrenInfo(component.getChildren(), writer);
        }
    }

    private void renderComponentInfo(UIComponent component, ResponseWriter writer) throws IOException {
        String id = component.getId();
        String componentType = component.getClass().getName();
        writer.write("<li");
        if (component.getChildCount() > 0) {
            writer.write(" id=\"foldheader\"");
        }
        writer.write(">id:\"" + id + "\" | type:\"" + componentType + "\"");
        if (component instanceof ValueHolder) {
            if (component.isRendered()) {
                Object value = ((ValueHolder)component).getValue();
                writer.write(" | value:\"" + value + "\"</li>\n");
            } else {
                writer.write(" | rendered:\"false\"</li>\n");
            }
        } else {
            writer.write("</li>\n");
        }
    }

    private void renderChildrenInfo(List list, ResponseWriter writer) throws IOException {
        writer.write("<ul id=\"foldinglist\" style=\"display:none\" style=&{head};>\n");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            this.renderComponent(child, writer);
        }
        writer.write("</ul>\n");
    }

    private void renderScriptInclude(ResponseWriter writer) throws IOException {
        writer.write("<script language=\"JavaScript1.2\" src=\"traceResource.jsf?name=tree&type=js\"></script>\n");
    }

    private void renderFacesStyleInclude(ResponseWriter writer) throws IOException {
        writer.write("<LINK rel=\"stylesheet\" type=\"text/css\" href=\"traceResource.jsf?name=facesTrace&type=css\" title=\"Style\">");
    }

    private void renderPhaseColumn(ResponseWriter writer, String phaseName, String color) throws IOException {
        writer.write("<TD width=\"100\" bgcolor=\"" + color + "\"><span class=\"tableLabels\" >" + phaseName + "</span></TD>\n");
    }

    private void renderArrowColumns(ResponseWriter writer) throws IOException {
        writer.write("<TD><b>---></b></TD>");
    }

    private void renderEachPhaseInLifeCycle(ResponseWriter writer) throws IOException {
        PhaseData[] phases = TraceUtils.getTraceData().getPhases();
        this.renderPhaseColumn(writer, phases[0].getPhaseName(), "lime");
        this.renderArrowColumns(writer);
        int i = 1;
        while (i < phases.length - 2) {
            PhaseData phaseData = phases[i];
            if (phaseData.isCausedResponse()) {
                this.renderPhaseColumn(writer, phaseData.getPhaseName(), "red");
            } else if (phaseData.isExecuted()) {
                this.renderPhaseColumn(writer, phaseData.getPhaseName(), "lime");
            } else {
                this.renderPhaseColumn(writer, phaseData.getPhaseName(), "gray");
            }
            this.renderArrowColumns(writer);
            ++i;
        }
        if (phases[4].isExecuted()) {
            this.renderPhaseColumn(writer, phases[4].getPhaseName(), "lime");
        } else {
            this.renderPhaseColumn(writer, phases[4].getPhaseName(), "gray");
        }
        this.renderArrowColumns(writer);
        this.renderPhaseColumn(writer, phases[5].getPhaseName(), "lime");
    }

    private void renderLifeCycle(ResponseWriter writer) throws IOException {
        writer.write("\n<center><TABLE border=\"1\" bordercolor=\"black\">\n");
        writer.write("<TBODY>\n");
        writer.write("<TR align=\"center\" height=\"75\">");
        this.renderEachPhaseInLifeCycle(writer);
        writer.write("</TR>");
        this.renderEndTableTag(writer);
        writer.write("</center>");
    }

    public Boolean isShowTree() {
        if (this.showTree != null) {
            return this.showTree;
        }
        ValueBinding vb = this.getValueBinding("showTree");
        if (vb != null) {
            return (Boolean)vb.getValue(this.getFacesContext());
        }
        return null;
    }

    public void setShowTree(Boolean showTree) {
        this.showTree = showTree;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.showTree};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.showTree = (Boolean)values[1];
        super.restoreState(context, values[0]);
    }
}

