/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.ComponentDefinition;
import org.apache.tiles.ComponentDefinitions;
import org.apache.tiles.NoSuchDefinitionException;

public class ComponentDefinitionsImpl
implements ComponentDefinitions {
    private Map baseDefinitions = new HashMap();
    private Map localeSpecificDefinitions = new HashMap();

    public ComponentDefinition getDefinition(String name) {
        return (ComponentDefinition)this.baseDefinitions.get(name);
    }

    public void addDefinitions(Map defsMap) throws NoSuchDefinitionException {
        this.baseDefinitions.putAll(defsMap);
        this.resolveInheritances();
    }

    public void addDefinitions(Map defsMap, Locale locale) throws NoSuchDefinitionException {
        this.localeSpecificDefinitions.put(locale, defsMap);
        this.resolveInheritances(locale);
    }

    public ComponentDefinition getDefinition(String name, Locale locale) {
        ComponentDefinition definition = null;
        Map localeSpecificMap = (Map)this.localeSpecificDefinitions.get(locale);
        if (localeSpecificMap != null) {
            definition = (ComponentDefinition)localeSpecificMap.get(name);
        }
        if (definition == null) {
            definition = this.getDefinition(name);
        }
        return definition;
    }

    public void resolveInheritances() throws NoSuchDefinitionException {
        Iterator i = this.baseDefinitions.values().iterator();
        while (i.hasNext()) {
            ComponentDefinition definition = (ComponentDefinition)i.next();
            definition.resolveInheritance(this);
        }
    }

    public void resolveInheritances(Locale locale) throws NoSuchDefinitionException {
        this.resolveInheritances();
        Map map = (Map)this.localeSpecificDefinitions.get(locale);
        if (map != null) {
            Iterator i = map.values().iterator();
            while (i.hasNext()) {
                ComponentDefinition definition = (ComponentDefinition)i.next();
                definition.resolveInheritance(this, locale);
            }
        }
    }

    public void reset() {
        this.baseDefinitions = new HashMap();
        this.localeSpecificDefinitions = new HashMap();
    }

    public Map getBaseDefinitions() {
        return this.baseDefinitions;
    }
}

