/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.view.faces;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.shale.view.AbstractApplicationBean;
import org.apache.shale.view.AbstractRequestBean;
import org.apache.shale.view.AbstractSessionBean;

public class LifecycleListener
implements ServletContextAttributeListener,
ServletContextListener,
HttpSessionActivationListener,
HttpSessionAttributeListener,
HttpSessionListener,
ServletRequestAttributeListener,
ServletRequestListener {
    private static final String TIGER_LISTENER = "org.apache.shale.tiger.view.faces.LifecycleListener";
    private LifecycleListener tiger = null;
    private boolean tigerInitialized = false;

    public void contextInitialized(ServletContextEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration names = event.getServletContext().getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(name);
        }
        Iterator keys = list.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            event.getServletContext().removeAttribute(key);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeAdded(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireApplicationInit(value);
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeReplaced(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireApplicationDestroy(value);
        }
        if ((value = event.getServletContext().getAttribute(event.getName())) != null) {
            this.fireApplicationInit(value);
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeRemoved(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireApplicationDestroy(value);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration names = event.getSession().getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                list.add(name);
            }
            Iterator keys = list.iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                event.getSession().removeAttribute(key);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void sessionWillPassivate(HttpSessionEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.sessionWillPassivate(event);
            return;
        }
        Enumeration names = event.getSession().getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = event.getSession().getAttribute(name);
            if (value == null) continue;
            this.fireSessionPassivate(value);
        }
    }

    public void sessionDidActivate(HttpSessionEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.sessionDidActivate(event);
            return;
        }
        Enumeration names = event.getSession().getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = event.getSession().getAttribute(name);
            if (value == null) continue;
            this.fireSessionActivate(value);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeAdded(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireSessionInit(value);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeReplaced(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireSessionDestroy(value);
        }
        if ((value = event.getSession().getAttribute(event.getName())) != null) {
            this.fireSessionInit(value);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeRemoved(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireSessionDestroy(value);
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration names = event.getServletRequest().getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list.add(name);
        }
        Iterator keys = list.iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            event.getServletRequest().removeAttribute(key);
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeAdded(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireRequestInit(value);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeReplaced(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireRequestDestroy(value);
        }
        if ((value = event.getServletRequest().getAttribute(event.getName())) != null) {
            this.fireRequestInit(value);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent event) {
        LifecycleListener tiger = this.tiger();
        if (tiger != null) {
            tiger.attributeRemoved(event);
            return;
        }
        Object value = event.getValue();
        if (value != null) {
            this.fireRequestDestroy(value);
        }
    }

    protected void cacheException(Exception exception) {
        this.log(exception.getMessage(), exception);
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            return;
        }
        ArrayList<Exception> list = (ArrayList<Exception>)context.getExternalContext().getRequestMap().get("org.apache.shale.view.EXCEPTIONS_LIST");
        if (list == null) {
            list = new ArrayList<Exception>(4);
            context.getExternalContext().getRequestMap().put("org.apache.shale.view.EXCEPTIONS_LIST", list);
        }
        list.add(exception);
    }

    protected void fireApplicationDestroy(Object bean) {
        try {
            if (bean instanceof AbstractApplicationBean) {
                ((AbstractApplicationBean)bean).destroy();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireApplicationInit(Object bean) {
        try {
            if (bean instanceof AbstractApplicationBean) {
                ((AbstractApplicationBean)bean).init();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireRequestDestroy(Object bean) {
        try {
            if (bean instanceof AbstractRequestBean) {
                ((AbstractRequestBean)bean).destroy();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireRequestInit(Object bean) {
        try {
            if (bean instanceof AbstractRequestBean) {
                ((AbstractRequestBean)bean).init();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireSessionActivate(Object bean) {
        try {
            if (bean instanceof AbstractSessionBean) {
                ((AbstractSessionBean)bean).activate();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireSessionDestroy(Object bean) {
        try {
            if (bean instanceof AbstractSessionBean) {
                ((AbstractSessionBean)bean).destroy();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireSessionInit(Object bean) {
        try {
            if (bean instanceof AbstractSessionBean) {
                ((AbstractSessionBean)bean).init();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void fireSessionPassivate(Object bean) {
        try {
            if (bean instanceof AbstractSessionBean) {
                ((AbstractSessionBean)bean).passivate();
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
    }

    protected void log(String message) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            context.getExternalContext().log(message);
        } else {
            System.out.println(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            context.getExternalContext().log(message);
        } else {
            System.out.println(message);
        }
    }

    private LifecycleListener tiger() {
        if (this.tigerInitialized) {
            return this.tiger;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(TIGER_LISTENER);
            this.tiger = (LifecycleListener)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tigerInitialized = true;
        return this.tiger;
    }
}

